<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'quiz', language 'th', branch 'MOODLE_32_STABLE'
 *
 * @package   quiz
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'กระทำการ...';
$string['adaptive'] = 'โหมดปรับเปลี่ยน';
$string['add'] = 'เพิ่ม';
$string['addaquestion'] = 'คำถามใหม่';
$string['addarandomquestion'] = 'คำถามแบบสุ่ม';
$string['addarandomselectedquestion'] = 'เพิ่มคำถามแบบสุ่มเลือก';
$string['addingquestion'] = 'กำลังเพิ่มคำถาม';
$string['addingquestions'] = 'หน้านี้เป็นหน้าสำหรับการจัดการฐานข้อมูลของคำถาม  คำถามจะถูกเก็บไว้เป็นหมวดหมู่เพื่อความเป็นระเบียบเรียบร้อย และสามารถนำไปใช้ในแบบทดสอบใด ๆ ในรายวิชาของคุณ หรือ รายวิชาอื่น ๆ หากคุณเลือก "เผยแพร่" <br /><br /> หลังจากที่คุณเลือกหรือสร้างหมวดหมู่ของคำถามแล้ว คุณจะสามารถสร้างหรือแก้ไขคำถาม  ซึ่งสามารถเลือกและนำไปใช้ในแบบทดสอบซึ่งอยู่อีกด้านหนึ่งของหน้านี้';
$string['addquestion'] = 'เพิ่มคำถาม';
$string['addquestionfrombankatend'] = 'เลือกจากคลังข้อสอบ';
$string['addquestionfrombanktopage'] = 'เพิ่มจากคลังข้อสอบไปยังหน้า{$a}';
$string['addquestions'] = 'เพิ่มคำถาม';
$string['addquestionstoquiz'] = 'เพิ่มคำถามลงในแบบทดสอบปัจจุบัน';
$string['addrandom'] = 'เพิ่มคำถามแบบสุ่ม {$a} ข้อ';
$string['addrandom1'] = 'เพิ่ม';
$string['addrandom2'] = 'คำถามแบบสุ่ม';
$string['addrandomfromcategory'] = 'เพิ่มคำถามแบบสุ่มจากประเภท:';
$string['addrandomquestion'] = 'เพิ่มคำถามแบบสุ่ม';
$string['addselectedquestionstoquiz'] = 'เพิ่มคำถามที่เลือกในแบบทดสอบ';
$string['addselectedtoquiz'] = 'เพิ่มคำถามที่เลือกไว้ลงแบบทดสอบ';
$string['addtoquiz'] = 'เพิ่มเข้าไปในแบบทดสอบ';
$string['affectedstudents'] = 'มีผลต่อ{$a}';
$string['age'] = 'อายุ';
$string['allattempts'] = 'การทำแบบทดสอบทั้งหมด';
$string['allinone'] = 'ไม่จำกัด';
$string['allowreview'] = 'ให้ดูแบบทดสอบได้หลังวันสุดท้ายที่ให้ทำแบบทดสอบ';
$string['alreadysubmitted'] = 'เป็นไปได้ว่าคุณได้ส่งคำตอบไปแล้ว';
$string['alternativeunits'] = 'หน่วยอื่น';
$string['alwaysavailable'] = 'ทำได้ตลอด';
$string['analysisoptions'] = 'วิเคราะห์ตัวเลือก';
$string['analysistitle'] = 'ตารางวิเคราะห์คำถาม';
$string['answer'] = 'คำตอบ';
$string['answered'] = 'คำตอบ';
$string['answerhowmany'] = 'คำตอบเดียวหรือหลายคำตอบ';
$string['answers'] = 'คำตอบที่ถูกต้อง';
$string['answersingleno'] = 'มีหลายคำตอบได้';
$string['answersingleyes'] = 'คำตอบเดียวเท่านั้น';
$string['answertoolong'] = 'คำตอบยาวเกินไปหลังจากบรรทัดที่ {$a}  ( ตอบได้ 255 ตัวอักษร)';
$string['aon'] = 'รูปแบบ AON';
$string['areyousureremoveselected'] = 'คุณแน่ใจแล้วหรือที่จะลบคำถามที่เลือกไว้?';
$string['attempt'] = 'ครั้ง {$a}';
$string['attemptduration'] = 'เวลาที่ใช้';
$string['attemptedon'] = 'ทำเมื่อ';
$string['attemptfirst'] = 'ตอบครั้งแรก';
$string['attemptincomplete'] = 'ยังทำไม่เสร็จ ทำโดย {$a}';
$string['attemptlast'] = 'ตอบครั้งสุดท้าย';
$string['attemptquiznow'] = 'ทำแบบทดสอบตอนนี้';
$string['attempts'] = 'ครั้ง';
$string['attemptsallowed'] = 'จำนวนครั้งที่ให้ตอบ';
$string['attemptselection'] = 'เลือกว่าต้องการใช้การทำแบบทดสอบใดในการวิเคราะห์สำหรับนักเรียนแต่ละคน';
$string['attemptsexist'] = 'คุณทำแบบทดสอบนี้ไปแล้วค่ะ';
$string['attemptsonly'] = 'แสดงเฉพาะนักเรียนที่ทำแบบทดสอบแล้ว';
$string['attemptsunlimited'] = 'ตอบได้ไม่จำกัดจำนวนครั้ง';
$string['back'] = 'กลับไปยังหน้าดูตัวอย่างคำถาม';
$string['backtocourse'] = 'กลับสู่รายวิชา';
$string['backtoquestionlist'] = 'กลับไปยังรายการคำถาม';
$string['backtoquiz'] = 'กลับไปแก้ไขแบบทดสอบ';
$string['bestgrade'] = 'คะแนนดีที่สุด';
$string['bothattempts'] = 'แสดงนักเรียนทั้งที่ทำและไม่ทำแบบทดสอบ';
$string['browsersecurity'] = 'ความปลอดภัยของบราวเซอร์';
$string['calculated'] = 'คำถามคำนวณ';
$string['calculatedquestion'] = 'คำถามแบบคำนวณบรรทัดที่  {$a} ไม่ถูกต้อง ระบบจะไม่นำคำถามนี้มาใช้';
$string['cannotcreatepath'] = 'ไม่สามารถสร้าง path ได้ ({$a})';
$string['cannotinsert'] = 'ไม่สามารถแทรกคำถาม';
$string['cannotinsertrandomquestion'] = 'ไม่สามารถเพิ่มคำถามแบบสุ่มได้!';
$string['cannotloadquestion'] = 'ไม่สามารถโหลดตัวเลือกคำถามได้';
$string['cannotopen'] = 'ไม่สามารถเปิดไฟล์ส่งออก ({$a})';
$string['cannotwrite'] = 'ไม่สามารถเขียนไปยังไฟล์ที่ส่งออก ({$a})';
$string['caseno'] = 'ไม่ : ตัวพิมพ์ใหญ่ พิมพ์เล็กถือเป็นตัวเดียวกัน';
$string['casesensitive'] = 'ตัวพิมพ์ใหญ่และตัวพิมพ์เล็ดถือเป็นคนละตัว';
$string['caseyes'] = 'ใช่ ตัวพิมพ์ใหญ่พิมพ์เล็กต้องถูกต้อง';
$string['categoryadded'] = 'เพิ่มประเภท{$a} แล้ว';
$string['categorydeleted'] = 'ลบประเภท  {$a} แล้ว';
$string['categorynoedit'] = 'คุณไม่ได้รับสิทธิให้แก้ไขประเภท  {$a}';
$string['categoryupdated'] = 'อัพเดทประเภทเรียบร้อยแล้ว';
$string['close'] = 'ปิดหน้าการแสดงผล';
$string['closed'] = 'ปิดแล้ว';
$string['closepreview'] = 'ปิดหน้าแสดงตัวอย่าง';
$string['closereview'] = 'ปิดการ review';
$string['comment'] = 'แสดงความคิดเห็น';
$string['commentorgrade'] = 'สร้างความเห็นหรือให้คะแนนทับของเดิม';
$string['comments'] = 'ความเห็น';
$string['completedon'] = 'เมื่อ';
$string['configurerandomquestion'] = 'ตั้งค่าคำถาม';
$string['confirmclose'] = 'คุณกำลังจะออกจากการทำแบบทดสอบ หากออกจากการทำแบบทดสอบแล้วคุณจะไม่สามารถเปลี่ยนแปลงคำตอบได้';
$string['confirmremovequestion'] = 'คุณต้องการที่จะลบคำถาม  {$a} ?';
$string['confirmserverdelete'] = 'แน่ใจนะคะว่าต้องการนำเซิร์ฟเวอร์  {$a} ออกจากรายการ';
$string['connectionok'] = 'การเชื่อมต่อเน็ตเวิร์คกลับมาแล้ว คุณสามารถดำเนินการต่อได้อย่างปลอดภัย';
$string['containercategorycreated'] = 'ระบบทำการสร้างประเภทนี้เพื่อทำการเก็บประเภทเดิมที่ย้ายไประดับเว็บไซต์เนื่องจากเหตุผลต่อไปนี้';
$string['continueattemptquiz'] = 'ทำต่อจากครั้งที่แล้ว';
$string['continuepreview'] = 'กลับสู่การแสดงตัวอย่างล่าสุด';
$string['copyingfrom'] = 'สร้างสำเนาของคำถาม \'{$a}\'';
$string['copyingquestion'] = 'กำลังสร้างสำเนาคำถาม';
$string['correct'] = 'ถูกต้อง';
$string['correctanswer'] = 'คำตอบที่ถูกต้อง';
$string['correctanswerformula'] = 'สูตรของคำตอบที่ถูกต้อง';
$string['correctansweris'] = 'คำตอบที่ถูกต้องคือ: {$a}';
$string['correctanswerlength'] = 'เลขนัยสำคัญ';
$string['correctanswers'] = 'คำตอบที่ถูกต้อง';
$string['correctanswershows'] = 'คำตอบที่ถูกต้องแสดง';
$string['corrresp'] = 'เมื่อตอบคำถามถูกให้แสดงข้อความว่า..';
$string['countdown'] = 'นับถอยหลัง';
$string['countdownfinished'] = 'กำลังหมดเวลาทำแบบทดสอบคุณควรส่งคำตอบเดี๋ยวนี้';
$string['countdowntenminutes'] = 'หมดเวลาทำแบบทดสอบในอีกสิบนาที';
$string['coursetestmanager'] = 'รูปแบบ Course Test Manager';
$string['createcategoryandaddrandomquestion'] = 'สร้างประเภทและเพิ่มคำถามแบบสุ่ม';
$string['createfirst'] = 'ต้องสร้างคำถามแบบเติมคำไว้ก่อนค่ะ';
$string['createmultiple'] = 'สุ่มคำถามมาใช้ในแบบทดสอบ';
$string['createnewquestion'] = 'สร้างคำถามใหม่(ทีละคำถาม)';
$string['createquestionandadd'] = 'สร้างคำถามใหม่และเพิ่มเข้าแบบทดสอบ';
$string['custom'] = 'รูปแบบใหม่(สร้างเอง)';
$string['dataitemneed'] = 'ท่านจำเป็นต้องเพิ่มอย่างน้อยหนึ่งชุดข้อมูลเพื่อให้ได้คำถามที่ถูกต้อง';
$string['datasetdefinitions'] = 'คำจำกัดความของกลุ่มข้อมูลที่นำมาใช้ใหม่ได้สำหรับประเภท {$a}';
$string['datasetnumber'] = 'ชุดข้อมูลที่';
$string['daysavailable'] = 'จำนวนวันที่เปิดให้ตอบ';
$string['decimaldigits'] = 'ตำแหน่งทศนิยมในการให้คะแนน';
$string['decimalpoints'] = 'จุดทศนิยม';
$string['default'] = 'ค่าที่ตั้งไว้';
$string['defaultgrade'] = 'คะแนนที่ตั้งไว้';
$string['defaultinfo'] = 'ตั้งค่าประเภทให้เป็น';
$string['delay1'] = 'ระยะห่างระหว่างการทำแบบทดสอบครั้งแรกกับครั้งที่สอง';
$string['delay2'] = 'ระยะห่างระหว่างการทำแบบสอบครั้งถัดไป';
$string['deleteattemptcheck'] = 'คุณแน่ใจนะคะว่าต้องการลบคำตอบที่ทำมา';
$string['deleteselected'] = 'ลบที่เลือก';
$string['description'] = 'คำอธิบาย';
$string['disabled'] = 'ปิดการใช้งาน';
$string['displayoptions'] = 'แสดงตัวเลือก';
$string['donotuseautosave'] = 'คุณไม่สามารถใช้ auto-save';
$string['download'] = 'คลิกเพื่อทำการดาวน์โหลดไฟล์ประเภทที่ส่งออก';
$string['downloadextra'] = '(ไฟล์ถูกจัดเก็บไว้ในไฟล์ของรายวิชาในแฟ้ม quiz)';
$string['dragtoafter'] = 'หลังจาก {$a}';
$string['duplicateresponse'] = 'ไม่นับการส่งคำตอบในครั้งนี้เพราะว่าตอบคำถามไม่ต่างจากครั้งที่ผ่านมา';
$string['eachattemptbuildsonthelast'] = 'อนุญาตให้ทำต่อจากครั้งที่แล้ว';
$string['eachattemptbuildsonthelast_help'] = '<p>If multiple attempts are allowed and this setting is set to <b>Yes</b>, then each new attempt contains the results of the previous attempt.  This allows a quiz to be completed over several attempts.</p>

<p>To show a fresh quiz on every attempt, select <b>No</b> for this setting.';
$string['editcategories'] = 'แก้ไขประเภท';
$string['editcategory'] = 'แก้ไขประเภท';
$string['editcatquestions'] = 'แก้ไขประเภทคำถาม';
$string['editingquestion'] = 'แก้ไขคำถาม';
$string['editingquiz'] = 'กำลังแก้ไขแบบทดสอบ';
$string['editingquizx'] = 'แก้ไขแบบทดสอบ: {$a}';
$string['editqcats'] = 'แก้ไขประเภทคำถาม';
$string['editquestion'] = 'แก้ไขคำถาม';
$string['editquestions'] = 'แก้ไขคำถาม';
$string['editquiz'] = 'แก้ไขแบบทดสอบ';
$string['editquizquestions'] = 'แก้ไขคำถามในแบบทดสอบ';
$string['empty'] = 'ว่างเปล่า';
$string['enabled'] = 'เปิดการใช้งาน';
$string['erroraccessingreport'] = 'คุณไม่สามารถเข้าถึงรายงาน';
$string['errormissingquestion'] = 'มีข้อผิดพลาด  คำถามหมายเลข {$a} หายไปจากระบบ';
$string['errornotnumbers'] = 'มีข้อผิดพลาด คำตอบต้องเป็นตัวเลข';
$string['essay'] = 'ความเรียง';
$string['essayquestions'] = 'คำถาม';
$string['everynquestions'] = 'ทุก {$a} คำถาม';
$string['everyquestion'] = 'ทุกคำถาม';
$string['exportcategory'] = 'ส่งออกประเภท';
$string['exporterror'] = 'มีข้อผิดพลาดในระหว่างกระบวนการส่งออก';
$string['exportingquestions'] = 'ส่งออกคำถามเป็นไฟล์';
$string['exportname'] = 'ชื่อไฟล์';
$string['exportquestions'] = 'ส่งออกคำถามเป็นไฟล์';
$string['false'] = 'ผิด';
$string['feedback'] = 'Feedback';
$string['file'] = 'ไฟล์';
$string['fileformat'] = 'รูปแบบไฟล์';
$string['fillcorrect'] = 'เติมที่ถูกต้อง';
$string['filloutoneanswer'] = 'คุณต้องเติมคำตอบอย่างน้อยหนึ่งคำตอบ ช่องว่างที่ว่างไว้จะไม่นำมาใช้';
$string['filloutthreequestions'] = 'คุณต้องเติมอย่างน้อยสามคำถาม คำถามที่ว่างไว้จะไม่นำมาใช้';
$string['fillouttwochoices'] = 'คุณต้องเติมคำตอบอย่างน้อยสองคำตอบ ช่องว่างที่ว่างไว้ จะไม่นำมาใช้';
$string['forceregeneration'] = 'บังคับให้สร้างใหม่ ( regeneration )';
$string['formatnotfound'] = 'ไม่พบรูปแบบนำเข้า/ส่งออก {$a}';
$string['fractionsaddwrong'] = 'คะแนนที่คุณเลือก รวมแล้วไม่ได้ 100 เปอร์เซ็นต์

<br />รวมแล้วได้ {$a}%
<br />ต้องการกลับไปแก้ไขหรือเปล่า?';
$string['fractionsnomax'] = 'หนึ่งในคำตอบ ควร มีคะแนน 100% เพื่อ
<br />ความเป็นไปได้ในการได้คะแนนเต็ม สำหรับคำถามข้อนี้
<br />ต้องการกลับไปแก้ไขหรือเปล่า?';
$string['fromfile'] = 'จากไฟล์:';
$string['functiondisabledbysecuremode'] = 'ขณะนี้ปิดการใช้งานฟังก์ชั่นนี้';
$string['generalfeedback'] = 'คำติชมทั่วไป';
$string['grade'] = 'คะแนน';
$string['gradeall'] = 'ให้คะแนนทั้งหมด';
$string['gradeaverage'] = 'คะแนนเฉลี่ย';
$string['gradeessays'] = 'ให้คะแนนความเรียง';
$string['gradehighest'] = 'คะแนนสูงสุด';
$string['grademethod'] = 'วิธีตัดเกรด';
$string['grademethod_help'] = '<P ALIGN=CENTER><B>การให้คะแนน</B></P>

<P>เมื่อให้ทดลองตอบคำถามหลายครั้ง จึงมีวิธีการให้คะแนนหลายวิธี
เพื่อคำนวณคะแนนสุดท้ายในการตอบคำถามของนักเรียน
<P><B>คะแนนสูงสุด</B><P>
<UL>
<P>คะแนนสุดท้ายคือคะแนนที่สูงที่สูด (ดีที่สุด)ของการทดลอง ทั้งหมด</UL>

<P><B>คะแนนเฉลี่ย</B><P>
<UL>
<P>คะแนนสุดท้ายคือค่าเฉลี่ย (ค่ากลาง) ของการทดลองทั้งหมด</UL>

<P><B>คะแนนครั้งแรก</B><P>
<UL>
<P>คะแนนสุดท้ายคือ คะแนนที่ได้จากการทดลองตอบคำถามในครั้งแรก (ครั้งอื่นๆ ไม่นับ)</UL>

<P><B>คะแนนครั้งสุดท้าย</B><P>
<UL>
<P>คะแนนสุดท้ายจะได้จากการทดลองตอบคำถามครั้งล่าสุดเท่านั้น</UL>';
$string['gradingdetails'] = 'คะแนนที่ได้ : {$a->raw}/{$a->max}.';
$string['gradingdetailsadjustment'] = 'หักคะแนนจากครั้งก่อนรวมแล้วได้ <strong>{$a->cur}/{$a->max}</strong>';
$string['gradingdetailspenalty'] = 'หักคะแนน {$a} คะแนน';
$string['gradingdetailszeropenalty'] = 'คุณไม่ถูกหักคะแนนสำหรับการทำแบบทดสอบครั้งนี้';
$string['guestsno'] = 'ขออภัยค่ะบุคคลทั่วไปไม่สามารถทำแบบทดสอบได้';
$string['history'] = 'ประวัติการตอบคำถาม';
$string['imagedisplay'] = 'ภาพที่ต้องการแสดง';
$string['importcategory'] = 'นำเข้าประเภท';
$string['importerror'] = 'มีข้อผิดพลาดระหว่างกระบวนการนำเข้า';
$string['importfilearea'] = 'นำเข้าจากไฟล์ที่มีอยู่ในคลังเก็บไฟล์ของรายวิชา';
$string['importfileupload'] = 'นำเข้าจากไฟล์อัพโหลด';
$string['importfromthisfile'] = 'นำเข้าจากไฟล์นี้';
$string['importingquestions'] = 'นำเข้า {$a} คำถามจากไฟล์';
$string['importmax10error'] = 'มีข้อผิดพลาดในคำถามคุณไม่สามารถสร้างคำตอบเกิน 10 ข้อ';
$string['importmaxerror'] = 'มีข้อผิดพลาดในคำถาม มีคำตอบมากเกินไป';
$string['importquestions'] = 'นำเข้าคำถามจากไฟล์';
$string['incorrect'] = 'ไม่ถูกต้อง';
$string['indivresp'] = 'ความคิดเห็นของแต่ละคนที่มีต่อแต่ละคำถาม';
$string['info'] = 'ข้อมูล';
$string['inprogress'] = 'อยู่ระหว่างดำเนินการ';
$string['introduction'] = 'คำนำ';
$string['invalidcategory'] = 'รหัสประเภทไม่ถูกต้อง';
$string['invalidquestionid'] = 'รหัสคำถามไม่ถูกต้อง';
$string['invalidquizid'] = 'รหัสแบบทดสอบไม่ถูกต้อง';
$string['invalidsource'] = 'แหล่งข้อมูลไม่ถูกต้อง';
$string['invalidsourcetype'] = 'ประเภทของแหล่งข้อมูลไม่ถูกต้อง';
$string['lastanswer'] = 'คำตอบเดิมของคุณคือ';
$string['layout'] = 'รูปแบบ';
$string['link'] = 'ลิงก์';
$string['listitems'] = 'รายการคำถามในแบบทดสอบ';
$string['literal'] = 'ค่าคงที่';
$string['loadingquestionsfailed'] = 'การโหลดคำถามล้มเหลว: {$a}';
$string['makecopy'] = 'บันทึกคำถามใหม่';
$string['managetypes'] = 'จัดการประเภทคำถามและเซิร์ฟเวอร์';
$string['manualgrading'] = 'ให้คะแนน';
$string['mark'] = 'ส่งข้อนี้';
$string['markall'] = 'ส่งทั้งหน้า';
$string['marks'] = 'คะแนน';
$string['match'] = 'คำถามจับคู่';
$string['matchanswer'] = 'จับคู่คำตอบ';
$string['max'] = 'สูงสุด';
$string['min'] = 'ต่ำสุด';
$string['minutes'] = 'นาที';
$string['missingcorrectanswer'] = 'ต้องระบุคำตอบที่ถูก';
$string['missingitemtypename'] = 'ขาดชื่อ';
$string['modulename'] = 'แบบทดสอบ';
$string['modulenameplural'] = 'แบบทดสอบ';
$string['moveselectedonpage'] = 'ย้ายคำถามที่เลือกไปหน้า: {$a}';
$string['multichoice'] = 'คำถามปรนัย';
$string['multipleanswers'] = 'เลือกอย่างน้อยหนึ่งคำตอบ';
$string['name'] = 'ชื่อ';
$string['newattemptfail'] = 'มีข้อผิดพลาด ไม่สามารถเริ่มทำแบบทดสอบใหม่ได้';
$string['newpage'] = 'หน้าใหม่';
$string['newpageevery'] = 'เริ่มหน้าใหม่โดยอัตโนมัติ';
$string['noanswers'] = 'คุณไม่ได้เลือกคำตอบ';
$string['noattempts'] = 'คุณไม่ได้ทำแบบทดสอบ';
$string['noattemptstoshow'] = 'ไม่มีการแสดงผลการทำแบบทดสอบ';
$string['nocategory'] = 'ไม่ถูกต้องหรือไม่ได้ระบุประเภท';
$string['noclose'] = 'ไม่ได้ระบุวันสิ้นสุด';
$string['nocommentsyet'] = 'ไม่มีความคิดเห็น';
$string['noconnection'] = 'ยังไม่มีการติดต่อกับ web service ที่สามารถใช้คำถามนี้ได้ กรุณาติดต่อผู้ดูแลระบบ';
$string['nodataset'] = 'ไม่มี (ไม่ใช่ wild card)';
$string['nodatasubmitted'] = 'ไม่มีข้อมูลส่งเข้ามา';
$string['noessayquestionsfound'] = 'ไม่พบคำถามที่ต้องให้คะแนนด้วยตนเอง';
$string['nomoreattempts'] = 'หมดสิทธิ์ทำแบบทดสอบแล้ว';
$string['none'] = 'ไม่มี';
$string['noopen'] = 'ไม่ได้ระบุวันเริ่มต้น';
$string['nopossibledatasets'] = 'ไม่มีเซ็ตข้อมูลที่เป็นไปได้';
$string['noquestionintext'] = 'ไม่มีโค้ดคำถามใด ๆ ในเนื้อความ';
$string['noquestions'] = 'ยังไม่มีคำถามในแบบทดสอบ';
$string['noquestionsfound'] = 'ไม่พบคำถาม';
$string['noquestionsonpage'] = 'หน้าว่าง';
$string['noresponse'] = 'ไม่มีการโต้ตอบ';
$string['noreview'] = 'คุณไม่ได้รับอนุญาตให้ทำแบบทดสอบนี้ใหม่';
$string['noreviewuntil'] = 'คุณไม่ได้รับอนุญาตให้ทำแบบทดสอบนี้ใหม่ จนกว่า {$a}';
$string['noscript'] = 'คุณต้องเปิดการใช้งาน JavaScript';
$string['notavailabletostudents'] = 'หมายเหตุ  คำถามนี้ยังไม่เปิดให้นักเรียนทำ';
$string['notenoughsubquestions'] = 'ข้อมูลเกี่ยวกับคำถามย่อยๆ ยังไม่สมบูรณ์ คุณต้องการกลับไปแก้ไขหรือไม่';
$string['notimedependentitems'] = 'โมดูลแบบทดสอบยังไม่สนับสนุนการจำกัดเวลาในแต่ละข้อ หากต้องการตั้งเวลาให้ตั้งเวลาสำหรับแบบทดสอบทั้งหมด คุณต้องการเลือกคำถามอื่นหรือไม่คะ (หรือใช้คำถามปัจจุบันโดยไม่สนใจเรื่องเวลา)';
$string['numattempts'] = '{$a->studentnum} {$a->studentstring} ทำแบบทดสอบนี้แล้ว {$a->attemptnum} ครั้ง';
$string['numberabbr'] = '#';
$string['numerical'] = 'คำถามเติมคำตอบด้วยตัวเลขหรือช่วง';
$string['numquestionsx'] = 'คำถาม: {$a}';
$string['oneminute'] = '1 นาที';
$string['onlyteachersexport'] = 'เฉพาะอาจารย์เท่านั้นที่จะสามารถส่งออกคำถามได้';
$string['onlyteachersimport'] = 'เฉพาะอาจารย์เท่านั้นที่จะมีสิทธิ์นำเข้าคำถาม';
$string['onthispage'] = 'หน้านี้';
$string['open'] = 'ไม่มีคำตอบ';
$string['optional'] = 'ทางเลือก';
$string['orderandpaging'] = 'จัดเรียงลำดับและหน้า';
$string['orderingquiz'] = 'จัดเรียงลำดับและหน้า';
$string['orderingquizx'] = 'จัดเรียงลำดับและหน้า: {$a}';
$string['outof'] = 'จากคะแนนเต็ม';
$string['overdue'] = 'เกินกำหนด';
$string['overduehandling'] = 'เมื่อหมดเวลา';
$string['page-mod-quiz-edit'] = 'แก้ไขหน้าแบบทดสอบ';
$string['page-mod-quiz-view'] = 'ข้อมูลแบบทดสอบ';
$string['page-mod-quiz-x'] = 'หน้ารายละเอียดโมดูลแบบทดสอบ';
$string['pagesize'] = 'แสดงจำนวนครั้งที่ทำต่อหน้า';
$string['parent'] = 'ประเภทที่สูงขึ้นไป';
$string['parentcategory'] = 'ประเภทก่อนหน้า';
$string['partiallycorrect'] = 'ถูกส่วนเดียว';
$string['penalty'] = 'หักคะแนน';
$string['penaltyscheme'] = 'หักคะแนนทันที';
$string['percentcorrect'] = 'เปอร์เซ็นต์ที่ถูก';
$string['pleaseclose'] = 'ปิดหน้าต่างได้แล้วค่ะ';
$string['pluginadministration'] = 'บริการจัดการคำถาม';
$string['pluginname'] = 'แบบทดสอบ';
$string['popup'] = 'แสดงแบบทดสอบในหน้าต่างโหมด secure';
$string['popupblockerwarning'] = 'แบบทดสอบส่วนนี้อยู่ใน secure mode หมายความว่าคุณต้องทำแบบทดสอบในหน้าต่าง secure กรุณาปิด popup blocker';
$string['popupnotice'] = 'นักเรียนจะเห็นแบบทดสอบนี้ในหน้าต่างที่ securre';
$string['preview'] = 'ดูตัวอย่าง';
$string['previewquestion'] = 'ดูตัวอย่างคำถาม';
$string['previewquiz'] = 'ดูตัวอย่าง  {$a}';
$string['previewquiznow'] = 'แสดงตัวอย่างคำถามเดี๋ยวนี้';
$string['previous'] = 'สถานะก่อนหน้า';
$string['publish'] = 'ใช้คำถามร่วมกับคนอื่น';
$string['publishedit'] = 'คุณต้องได้รับอนุญาตในการเผยแพร่ก่อนค่ะ จึงจะสามารถเพิ่มหรือแก้ไขคำถามในประเภทดังกล่าวได้';
$string['qname'] = 'ชื่อ';
$string['qti'] = 'รูปแบบ IMS QTI';
$string['qtypename'] = 'ประเภท, ชื่อ';
$string['question'] = 'คำถาม';
$string['questionbank'] = 'จากธนาคารข้อสอบ';
$string['questionbehaviour'] = 'การกระทำของคำถาม';
$string['questioncats'] = 'ประเภทคำถาม';
$string['questiondeleted'] = 'คำถามนี้ถูกลบไปแล้วกรุณาติดต่ออาจารย์ประจำรายวิชา';
$string['questioninuse'] = 'กำลังใช้คำถาม \'{$a}\'';
$string['questionname'] = 'ชื่อคำถาม';
$string['questionnotloaded'] = 'ไม่สามารถโหลดคำถาม {$a} จากฐานข้อมูล';
$string['questionorder'] = 'จัดเรียงคำถาม';
$string['questionposition'] = 'การจัดเรียงคำถาม {$a} ในตำแหน่งใหม่';
$string['questions'] = 'คำถาม';
$string['questionsinclhidden'] = 'คำถาม (รวมที่ซ่อนอยู่)';
$string['questionsinthisquiz'] = 'คำถามในแบบทดสอบ';
$string['questionsperpage'] = 'จำนวนคำถามสูงสุดต่อหน้า';
$string['questiontext'] = 'ข้อคำถาม';
$string['questiontextisempty'] = '[ไม่มีข้อคำถาม]';
$string['questiontype'] = 'ประเภทของคำถาม {$a}';
$string['questiontypesetupoptions'] = 'ตั้งค่าตัวเลือกสำหรับประเภทคำถาม :';
$string['quiz:addinstance'] = 'เพิ่มแบบทดสอบ';
$string['quizavailable'] = 'สามารถทำแบบทดสอบได้จนถึง: {$a}';
$string['quizclose'] = 'วันสุดท้ายที่อนุญาตให้ทำแบบทดสอบ';
$string['quizclosed'] = 'ปิดการใช้งานแบบทดสอบเมื่อ {$a}';
$string['quizcloses'] = 'หมดเวลาทำแบบทดสอบ';
$string['quizcloseson'] = 'แบบทดสอบจะปิดเมื่อ {$a}';
$string['quizisclosed'] = 'แบบทดสอบนี้ปิดแล้ว';
$string['quizisclosedwillopen'] = 'แบบทดสอบนี้ปิดแล้ว (เปิด {$a})';
$string['quizisopen'] = 'แบบทดสอบนี้เปิดอยู่';
$string['quizisopenwillclose'] = 'แบบทดสอบนี้เปิดอยู่ (ปิด {$a})';
$string['quiz:manage'] = 'จัดการแบบทดสอบ';
$string['quiznavigation'] = 'นำทางแบบทดสอบ';
$string['quizopen'] = 'วันแรกที่สามารถทำแบบทดสอบได้';
$string['quizopenclose'] = 'วันที่เปิดและปิด';
$string['quizopenedon'] = 'แบบทดสอบนี้เปิดเมื่อ {$a}';
$string['quizopens'] = 'ทำแบบทดสอบได้';
$string['quiz:preview'] = 'แสดงตัวอย่างแบบทดสอบ';
$string['quizsettings'] = 'ตั้งค่าแบบทดสอบ';
$string['quiztimer'] = 'เวลาที่ใช้';
$string['quiz:view'] = 'ดูข้อมูลแบบทดสอบ';
$string['quiz:viewreports'] = 'ดูรายงานแบบทดสอบ';
$string['quizwillopen'] = 'แบบทดสอบนี้จะเปิด {$a}';
$string['random'] = 'คำถามแบบสุ่ม';
$string['randomcreate'] = 'สร้างคำถามแบบสุ่ม';
$string['randomfromcategory'] = 'คำถามแบบสุ่มจากประเภท:';
$string['randomfromexistingcategory'] = 'คำถามแบบสุ่มจากประเภทที่มีอยู่แล้ว:';
$string['randomnumber'] = 'จำนวนของคำถามแบบสุ่ม';
$string['randomquestionusinganewcategory'] = 'ใช้คำถามแบบสุ่มจากประเภทใหม่';
$string['randomwithsubcat'] = 'คำถามจากประเภทนี้และประเภทย่อยภายใน';
$string['readytosend'] = 'คุณกำลังจะส่งแบบทดสอบ  ต้องการส่งหรือเปล่าคะ';
$string['reattemptquiz'] = 'ทำแบบทดสอบใหม่';
$string['recentlyaddedquestion'] = 'คำถามเพิ่มใหม่ล่าสุด';
$string['recurse'] = 'แสดงคำถามจากประเภทย่อยด้วย';
$string['redoquestion'] = 'ทำซ้ำคำถาม';
$string['regrade'] = 'ให้คะแนนแต่ละครั้งที่ทำใหม่';
$string['regradecomplete'] = 'ให้คะแนนแบบทดสอบแต่ละครั้งใหม่แล้ว';
$string['regradecount'] = 'คะแนน {$a->changed} out of {$a->attempt}  ได้รับการเปลี่ยนแปลงแล้ว';
$string['regradedisplayexplanation'] = 'คะแนนที่ได้รับการเปลี่ยนแปลงจะมีการแสดงในรูปแบบของไฮเปอร์ลิงก์ไปยังหน้าต่างการ review คำถาม';
$string['regradingquestion'] = 'ปรับคะแนน {$a}';
$string['regradingquiz'] = 'ปรับคะแนนแบบทดสอบ {$a}';
$string['remove'] = 'เอาออก';
$string['removeemptypage'] = 'ลบหน้าว่าง';
$string['removepagebreak'] = 'ลบตัวคั่นหน้า';
$string['removeselected'] = 'ลบที่เลือก';
$string['rename'] = 'เปลี่ยนชื่อ';
$string['renderingserverconnectfailed'] = 'เซิร์ฟเวอร์ {$a} ไม่สามารถตอบสนอง RQP Request ได้ให้ตรวจสอบ url ว่าถูกต้องหรือไม่';
$string['reorderquestions'] = 'เรียงลำดับคำถามใหม่';
$string['reordertool'] = 'แสดงเครื่องมือการจัดเรียงลำดับ';
$string['repaginate'] = 'ตั้งค่าหน้าให้มี {$a} คำถามต่อหน้า';
$string['replace'] = 'แทนที่';
$string['replacementoptions'] = 'ตัวเลือกการแทนที่';
$string['report'] = 'รายงาน';
$string['reportanalysis'] = 'การวิเคราะห์คำถาม';
$string['reportdisplayoptions'] = 'ตัวเลือกการแสดงผล';
$string['reportfullstat'] = 'รายละเอียดสถิติ';
$string['reportmulti_percent'] = 'Multi-Percentages';
$string['reportmulti_q_x_student'] = 'ตัวเลือกจากนักเรียนหลายคน';
$string['reportmulti_resp'] = 'คำตอบของแต่ละคน';
$string['reportoverview'] = 'ภาพรวม';
$string['reportregrade'] = 'ให้คะแนนใหม่';
$string['reportresponses'] = 'ข้อความโต้ตอบอย่างละเอียด';
$string['reports'] = 'รายงาน';
$string['reportsimplestat'] = 'สถิติอย่างง่าย';
$string['requirepassword'] = 'ต้องใส่รหัสผ่าน';
$string['requirepassword_help'] = '<p>This field is optional</p>

<p>If you specify a password in here then participants must
   enter the same password before they are allowed to make an
   attempt on the quiz.</p>';
$string['requiresubnet'] = 'ต้องมีที่อยู่เน็ตเวิร์ก';
$string['requiresubnet_help'] = '<p>This field is optional.</p>

<p>You can restrict access for a quiz to particular subnets
   on the LAN or Internet by specifying a comma-separated list of
   partial or full IP address numbers.</p>

<p>This is especially useful for a proctored quiz, where you want
   to be sure that only people in a certain room are able to
   access the quiz.</p>

<p>For example:  <b>192.168. , 231.54.211.0/20, 231.3.56.211</b></p>

<p>There are three types of numbers you can use (you can not use
   text based domain names like example.com):
<ol>
<li>Full IP addresses, such as <b>192.168.10.1</b> which will match
    a single computer (or proxy).</li>
<li>Partial addresses, such as <b>192.168</b> which will match anything
    starting with those numbers.</li>
<li>CIDR notation, such as <b>231.54.211.0/20</b> which allows you to specify
    more detailed subnets.</li>
</ol>
</p>

<p>Spaces are ignored.</p>';
$string['response'] = 'ข้อที่เลือก';
$string['responses'] = 'ข้อที่เลือก';
$string['results'] = 'ผลสอบ';
$string['reuseifpossible'] = 'นำที่เอาออกไปแล้วกลับมาใช้ใหม่';
$string['review'] = 'Review';
$string['reviewafter'] = 'ให้ดูแบบทดสอบหลังจากที่สิ้นสุดเวลาให้ทำแล้ว';
$string['reviewalways'] = 'ให้ดูแบบทดสอบได้ทุกเวลา';
$string['reviewbefore'] = 'ให้ดูแบบทดสอบในขณะที่เปิดให้ทำแบบทดสอบ';
$string['reviewclosed'] = 'หลังจากปิดแบบทดสอบ';
$string['reviewimmediately'] = 'ทันทีหลังจากทำแบบทดสอบ';
$string['reviewnever'] = 'ไม่อนุญาตให้ดูแบบทดสอบ';
$string['reviewofattempt'] = 'Review ของการทำแบบทดสอบ{$a}';
$string['reviewofpreview'] = 'รีวิวของการแสดงตัวอย่าง';
$string['reviewopen'] = 'หลังจากนี้ขณะที่ยังเปิดการใช้งานแบบทดสอบ';
$string['reviewoptions'] = 'นักเรียนสามารถ review';
$string['reviewresponse'] = 'review ข้อที่เลือกตอบ';
$string['rqp'] = 'คำถามภายใน';
$string['rqps'] = 'คำถามภายใน';
$string['save'] = 'บันทึก';
$string['saveandedit'] = 'บันทึกการเปลี่ยนแปลงและแก้ไขคำถาม';
$string['savedfromdeletedcourse'] = 'บันทึกจากรายวิชา{$a} ที่ลบไปแล้ว';
$string['savegrades'] = 'บันทึกคะแนน';
$string['savemyanswers'] = 'บันทึกคำตอบ';
$string['savenosubmit'] = 'บันทึกโดยไม่ส่งคำตอบ';
$string['savequiz'] = 'บันทึกแบบทดสอบ';
$string['saving'] = 'กำลังบันทึก';
$string['score'] = 'คะแนนดิบ';
$string['scores'] = 'คะแนน';
$string['seequestions'] = '(ดูคำถาม)';
$string['select'] = 'เลือก';
$string['selectall'] = 'เลือกทั้งหมด';
$string['selectedattempts'] = 'เลือกการทำแบบทดสอบทั้งหมด';
$string['selectnone'] = 'ไม่เลือกทั้งหมด';
$string['serveradded'] = 'เพิ่มเซิร์ฟเวอร์แล้ว';
$string['serveridentifier'] = 'Identifier';
$string['serverinfo'] = 'ข้อมูลเซิร์ฟเวอร์';
$string['servers'] = 'เซิร์ฟเวอร์';
$string['serverurl'] = 'url ของเซิร์ฟเวอร์';
$string['shortanswer'] = 'คำถามอัตนัย';
$string['show'] = 'แสดง';
$string['showall'] = 'แสดงคำถามทั้งหมดใน 1 หน้า';
$string['showbreaks'] = 'แสดงการแบ่งหน้า';
$string['showcategorycontents'] = 'แสดงเนื้อหาประเภท  {$a->arrow}';
$string['showcorrectanswer'] = 'ต้องแสดงคำตอบ ใน feedback หรือเปล่า';
$string['showdetailedmarks'] = 'แสดงรายละเอียดคะแนน';
$string['showeachpage'] = 'แสดงทั้งหมดในครั้งเดียว';
$string['showfeedback'] = 'ต้องการให้แสดง  feedback หลังตอบคำถามหรือไม่';
$string['showlargeimage'] = 'รูปภาพขนาดใหญ่';
$string['shownoattempts'] = 'แสดงนักเรียนที่ไม่ทำแบบทดสอบ';
$string['shownoattemptsonly'] = 'แสดงเฉพาะนักเรียนที่ไม่ทำแบบทดสอบ';
$string['shownoimage'] = 'ไม่มีรูป';
$string['showreport'] = 'แสดงรายงาน';
$string['showsmallimage'] = 'รูปขนาดเล็ก';
$string['showteacherattempts'] = 'แสดงการทำแบบทดสอบของอาจารย์';
$string['showuserpicture'] = 'แสดงรูปภาพประจำตัว';
$string['shuffle'] = 'สลับ';
$string['shuffleanswers'] = 'สลับคำตอบ';
$string['shuffledrandomly'] = 'สุ่มสลับตำแหน่ง';
$string['shufflequestions'] = 'สลับคำถาม';
$string['shufflewithin'] = 'สลับคำตอบหรือสลับภายในคำถาม';
$string['singleanswer'] = 'เลือกคำตอบเดียว';
$string['sortage'] = 'เรียงตามอายุ';
$string['sortalpha'] = 'เรียงตามชื่อ';
$string['sortsubmit'] = 'เรียงลำดับคำถาม';
$string['sorttypealpha'] = 'เรียงตามประเภท,ชื่อ';
$string['startagain'] = 'เริ่มใหม่';
$string['startedon'] = 'เริ่มเมื่อ';
$string['startnewpreview'] = 'เริ่มการแสดงตัวอย่างใหม่';
$string['statefinished'] = 'เสร็จสิ้น';
$string['stateinprogress'] = 'อยู่ระหว่างดำเนินการ';
$string['status'] = 'สถานะ';
$string['stoponerror'] = 'หยุดเมื่อมีข้อผิดพลาด';
$string['submitallandfinish'] = 'ส่งคำตอบแล้วสิ้นสุดการทำแบบทดสอบ';
$string['subneterror'] = 'ขออภัยค่ะ แบบทดสอบนี้ถูกล็อกเอาไว้สามารถทำได้ภายในที่ตั้งที่ระบุไว้เท่านั้น คอมพิวเตอร์ของคุณอยู่ในพื้นที่นอกเหนือจากเขตที่ระบุเอาไว้';
$string['subnetnotice'] = 'แบบทดสอบนี้ถูกล็อกเอาไว้ สามารถใช้งานได้จากหมายเลขไอพี ที่ระบุเอาไว้ทั้งนั้น แต่ในฐานะอาจารย์ท่านสามารถดูตัวอย่างคำถามได้';
$string['subplugintype_quiz'] = 'รายงาน';
$string['subplugintype_quizaccess'] = 'กฎการเข้าถึง';
$string['subplugintype_quizaccess_plural'] = 'กฎการเข้าถึง';
$string['subplugintype_quiz_plural'] = 'รายงาน';
$string['substitutedby'] = 'แทนที่โดย';
$string['temporaryblocked'] = 'คุณไม่สามารถทำแบบทดสอบใหม่ได้ในขณะนี้ <br/> คุณจะทำได้อีกครั้งในวันที่ :';
$string['time'] = 'เวลา';
$string['timecompleted'] = 'ทำเสร็จเมื่อ';
$string['timedelay'] = 'คุณยังไม่สามารถทำแบบทดสอบเพราะคุณยังไม่ถึงกำหนดเวลาที่จะทำแบบทดสอบครั้งต่อไปได้';
$string['timeleft'] = 'เหลือเวลา';
$string['timelimit'] = 'ให้เวลา';
$string['timelimitexeeded'] = 'ขออภัยค่ะ หมดเวลาทำแบบทดสอบแล้ว';
$string['timelimit_help'] = '<p align="center"><strong>Time limit</strong></p>

<p>By default, quizzes do not have a time limit, which allows
   students as much time as they need to complete the quiz.

<p>If you do specify a time limit, the several things are done to try and
   ensure that quizzes are completed within that time:</p>

<ul>
  <li>Javascript support in the brower becomes mandatory - this allows
      the timer to work correctly.</li>
  <li>A floating timer window is shown with a countdown</li>
  <li>When the timer has run out, the quiz is submitted automatically
      with whatever answers have been filled in so far</li>
  <li>If a student manages to cheat and spends more than 60 seconds
      over the allotted time then the quiz is automatically graded zero</li>
</ul>';
$string['timestr'] = '%H:%M:%S on %d/%m/%y';
$string['timesup'] = 'หมดเวลา';
$string['timetaken'] = 'เวลาที่ใช้';
$string['timing'] = 'กำหนดเวลา';
$string['tofile'] = 'ไปยังไฟล์';
$string['tolerance'] = 'ความคลาดเคลื่อน';
$string['toomanyrandom'] = 'จำนวนของคำถามที่ต้องการ มีมากกว่าจำนวนที่มีอยู่ในฐานข้อมูล ({$a})';
$string['top'] = 'กลับด้านบน';
$string['totalquestionsinrandomqcategory'] = 'มี {$a}คำถามในประเภทนี้';
$string['true'] = 'ถูก';
$string['truefalse'] = 'คำถามถูก/ผิด';
$string['type'] = 'ประเภท';
$string['unfinished'] = 'เปิด';
$string['ungraded'] = 'อัพเกรด';
$string['unit'] = 'หน่วย';
$string['unknowntype'] = 'ประเภทคำถามไม่ถูกต้องที่บรรทัดที่ {$a} ระบบจะไม่นำคำถามนี้มาใช้';
$string['updatesettings'] = 'อัพเดทการตั้งค่าแบบทดสอบ';
$string['upgradesure'] = '<div style="color: red;">ในโมดูลแบบทดสอบจะมีการเปลี่ยนแปลงตาราง การอัพเกรดในครั้งนี้ยังไม่ผ่านการทดสอบ คุณควรทำการสำรองข้อมูลไว้ก่อนมิเช่นนั้นข้อมูลอาจจะสูญหายและไม่สามารถทำการกู้คืนได้ </div>';
$string['url'] = 'url';
$string['usedcategorymoved'] = 'มีการย้ายประเภทนี้ไปยังระดับเว็บไซต์ หลังจากที่มีการลบรายวิชาทิ้งไป มีการใช้คำถามอยู่ในแบบทดสอบอื่นในเซิร์ฟเวอร์นี้';
$string['validate'] = 'ใช้ได้ถึง';
$string['viewallanswers'] = 'มีการทำแบบทดสอบแล้ว  {$a} ครั้ง';
$string['viewallreports'] = 'ดูรายงานสำหรับ {$a}  ครั้ง';
$string['viewed'] = 'ดูแล้ว';
$string['warningmissingtype'] = 'คำถามนี้จัดอยู่ในประเภทที่ยังไม่มีการติดตั้งใน Moodle  กรุณาแจ้งให้ผู้ดูแลระบบทราบ';
$string['wheregrade'] = 'คะแนนของฉัน';
$string['wildcard'] = 'Wild  card';
$string['withsummary'] = 'พร้อมกับสรุปสถิติ';
$string['wronguse'] = 'คุณไม่สามารถใช้หน้านี้แบบนี้นี้ได้';
$string['xhtml'] = 'รูปแบบ XHTML';
$string['youneedtoenrol'] = 'คุณต้องสมัครเข้ารายวิชาก่อนที่คุณจะทำแบบทดสอบ';
$string['yourfinalgradeis'] = 'คะแนนที่ได้คือ {$a}';
