<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'glossary', language 'th', branch 'MOODLE_32_STABLE'
 *
 * @package   glossary
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addcomment'] = 'เพิ่มเติมความคิดเห็น';
$string['addentry'] = 'เพิ่มคำศัพท์ใหม่';
$string['addingcomment'] = 'เพิ่มเติมความคิดเห็น';
$string['aliases'] = 'คำที่ใช้ในการค้นหา';
$string['allcategories'] = 'ทุกหัวข้อ';
$string['allentries'] = 'ทั้งหมด';
$string['allowcomments'] = 'อนุญาตให้แสดงความคิดเห็น';
$string['allowcomments_help'] = '<p>อาจอนุญาตให้นักเรียนเพิ่มเติมความเห็นที่มีต่อคำศัพท์หรือนิยามของอภิธานศัพท์</p>

 <p>ซึ่งคุณสามารถเลือกอนุญาตให้ส่วนแสดงความเห็นต่อคำศัพท์หรือนิยามทำงานหรือไม่ทำงานก็ได้</p>

<p>ตัวผู้สอนสามารถเพิ่มเติมความเห็นต่อคำศัพท์หรือนิยามของอภิธานศัพท์ได้เสมอ</p>';
$string['allowduplicatedentries'] = 'อนุญาตให้โพสต์คำศัพท์ซ้ำ';
$string['allowduplicatedentries_help'] = '<p>หากคุณเลือกให้ส่วนนี้ทำงาน ศัพท์หรือนิยามหลายๆ คำอาจใช้ชื่อภายใต้แนวคิดเดียวกันได้</p>';
$string['allowprintview'] = 'แสดงมุมมองการพิมพ์';
$string['answer'] = 'ตอบ';
$string['approve'] = 'อนุมัติ';
$string['areaentry'] = 'คำจำกัดความ';
$string['areyousuredelete'] = 'แน่ใจนะคะว่าต้องการลบคำศัพท์นี้';
$string['areyousuredeletecomment'] = 'แน่ใจนะคะว่าต้องการลบความเห็นนี้';
$string['areyousureexport'] = 'แม่ใจนะคะว่าต้องการส่งออกคำศัพท์นี้ไปที่';
$string['ascending'] = 'เรียงจากน้อยไปมาก';
$string['attachment'] = 'ไฟล์ที่แนบมาด้วย';
$string['authorview'] = 'เลือกดูจากชื่อผู้เขียน';
$string['back'] = 'กลับไป';
$string['cantinsertcat'] = 'ไม่สามารถเพิ่มประเภทคำศัพท์นี้ได้';
$string['cantinsertrec'] = 'ไม่สามารถเพิ่มบันทึกนี้ได้';
$string['cantinsertrel'] = 'ไม่สามารถเพิ่มคำศัพท์ลงในประเภทที่เกี่ยวข้อง';
$string['casesensitive'] = 'ศัพท์ภาษาอังกฤษต้องระวังระหว่างตัวพิมพ์เล็กและใหญ่';
$string['casesensitive_help'] = '<p>การตั้งค่าส่วนนี้สามารถกำหนด ว่าจะอนุญาตให้คำที่พิมพ์ด้วยอักษรตัวเล็ก และคำที่พิมพ์ด้วยอักษรตัวใหญ่ ใช้แทนกันได้หรือไม่ ในกรณีกำหนดให้เป็นลิงก์ไปยังศัพท์หรือนิยามโดยอัตโนมัติ</p>

<p>เช่น หากตั้งค่าให้ส่วนนี้ทำงาน คำ "html" บนกระดานเสวนาจะไม่สามารถลิงก์ไปยังอภิธานศัพท์คำว่า "HTML"</p>';
$string['categories'] = 'ประเภทคำศัพท์';
$string['category'] = 'ประเภทคำศัพท์';
$string['categorydeleted'] = 'ประเภทคำศัพท์ถูกลบออก';
$string['categoryview'] = 'เลือกดูจากประเภทศัพท์';
$string['cnfallowcomments'] = 'เลือกให้ผู้อ่านแสดงความคิดเห็นในคำศัพท์ได้';
$string['cnfallowdupentries'] = 'เลือกให้เพิ่มคำศัพท์ซ้ำได้';
$string['cnfapprovalstatus'] = 'เลือกให้การเพิ่มคำศัพท์โดยนักเรียนต้องได้รับการอนุมัติหรือไม่';
$string['cnfcasesensitive'] = 'เลือกให้การเพิ่มคำศัพท์ภาษาอังกฤษนับตัวพิมพ์เล็กว่าไม่เหมือนกับตัวใหญ่ CAT ต่างจาก cat';
$string['cnfdefaulthook'] = 'เลือกให้กลุ่มคำศัพท์ที่จะปรากฏขึ้นอัตโนมัติเมื่อมีคนเข้ามาอ่านคำศัพท์นี้';
$string['cnfdefaultmode'] = 'เลือกเฟรมที่ต้องการแสดงคำศัพท์เมื่อเข้ามาอ่านครั้งแรก';
$string['cnffullmatch'] = 'เลือกว่าจะให้เวลาค้นหาคำศัพท์ตัวพิมพ์ใหญ่ให้แสดงผลตัวพิมพ์เล็กด้วย';
$string['cnflinkentry'] = 'เลือกว่าเมื่อมีคำศัพท์เพิ่มใหม่จะให้สร้างลิงก์อัตโนมัติหรือไม่';
$string['cnflinkglossaries'] = 'เลือกว่าควรลิงก์อภิธานศัพท์โดยอัตโนมัติหรือไม่';
$string['cnfrelatedview'] = 'เลือกรูปแบบการนำเสนอ';
$string['cnfshowgroup'] = 'กำหนดว่าจะให้แสดงการแบ่งกลุ่มคำศัพท์หรือไม่';
$string['cnfsortkey'] = 'เลือกให้เรียงคำค้นหา';
$string['cnfsortorder'] = 'เลือกให้มีการเรียงลำดับ';
$string['cnfstudentcanpost'] = 'เลือกว่าจะให้นักเรียนโพสต์คำศัพท์เพิ่มได้อัตโนมัติหรือไม่';
$string['comment'] = 'ความคิดเห็น';
$string['commentdeleted'] = 'ความคิดเห็นนี้ถูกลบออก';
$string['comments'] = 'ความคิดเห็น';
$string['commentson'] = 'แสดงความคิดเห็นเมื่อ';
$string['commentupdated'] = 'ความคิดเห็นถูกเพิ่มเติม';
$string['concept'] = 'คำศัพท์';
$string['concepts'] = 'คำศัพท์';
$string['configenablerssfeeds'] = 'ตรงนี้ใช้สำหรับเปิดให้การป้อนข้อมูลแบบ RSS เกิดขึ้นได้ในทุกหมวดคำศัพท์  คุณยังจะต้องเปิดการป้อนข้อมูลเองในการตั้งค่าของแต่ละหมวดคำศัพท์';
$string['currentglossary'] = 'อภิธานศัพท์ปัจจุบัน';
$string['dateview'] = 'เลือกโดยดูจากวันที่';
$string['defaultapproval'] = 'สถานะการอนุมัติ';
$string['defaultapproval_help'] = '<p>การตั้งค่านี้อนุญาตให้ผู้สอนกำหนดว่าคำศัพท์ที่เพิ่มเติมโดยนักเรียนจะเป็นอย่างไร อาจกำหนดให้ทุกๆ คนใช้คำศัพท์เหล่านั้นได้โดยอัตโนมัติ หรือมิเช่นนั้น ผู้สอนจะต้องตรวจสอบและอนุมัติให้ศัพท์เหล่านั้นใช้ได้ทีละคำ</p>';
$string['definition'] = 'คำจำกัดความ';
$string['definitions'] = 'คำจำกัดความ';
$string['deleteentry'] = 'ลบคำนี้ออก';
$string['deletingcomment'] = 'กำลังลบความคิดเห็นนี้';
$string['deletingnoneemptycategory'] = 'การลบประเภทคำศัพท์ไม่ได้ลบรายการคำศัพท์ที่มีอยู่ในกลุ่มคำศัพท์นี้  คำศัพท์เหล่านั้นจะถูกนำไปไว้ในคำศัพท์ที่จัดกลุ่มไม่ได้';
$string['descending'] = 'เรียงจากมากไปน้อย';
$string['destination'] = 'ที่หมาย';
$string['destination_help'] = '<p>สามารถระบุได้ว่าต้องการนำเข้าคำศัพท์จากที่ไหน:</p>
<ul>
<li><strong>อภิธานศัพท์ปัจจุบัน:</strong>จะเพิ่มคำศัพท์นำเข้าเข้าสู่อภิธานศัพท์ที่เปิดใช้อยู่ปัจจุบัน</li>
<li><strong> อภิธานศัพท์ใหม่:</strong>  จะสร้างอภิธานศัพท์ใหม่จากข้อมูลที่พบในไฟล์ที่ต้องการนำเข้าและแทรกคำจำกัดความหรือคำอธิบายเพิ่มเติมให้กับอภิธานศัพท์นั้น</li>
</ul>';
$string['displayformat'] = 'รูปแบบการนำเสนอ';
$string['displayformatcontinuous'] = 'ต่อเนื่องพร้อมชื่อผู้เขียน';
$string['displayformatdictionary'] = 'อย่างง่ายรูปแบบพจนานุกรม';
$string['displayformatencyclopedia'] = 'สารานุกรม';
$string['displayformatentrylist'] = 'รายการคำศัพท์มาใหม่';
$string['displayformatfaq'] = 'คำถามถามบ่อย';
$string['displayformatfullwithauthor'] = 'เต็มรูปแบบพร้อมชื่อผู้เขียน';
$string['displayformatfullwithoutauthor'] = 'เต็มรูปแบบไม่รวมชื่อผู้เขียน';
$string['displayformat_help'] = '<p>การตั้งค่านี้ใช้กำหนดรายละเอียดว่าศัพท์หรือนิยามแต่ละคำจะปรากฏออกมาในรูปแบบใดในอภิธานศัพท์ ค่าที่ตั้งไว้คือ</p>
<blockquote>
<dl>
<dt><b>อย่างง่ายรูปแบบพจนานุกรม</b>:</dt>
<dd>จะดูเหมือนพจนานุกรมแบบที่ใช้อยู่ทั่วไป คำศัพท์แต่ละคำแยกกัน ไม่มีการระบุผู้เขียนคำศัพท์ เอกสารหรือไฟล์แนบจะแสดงในรูปแบบลิงก์</dd>
<dt><b>ต่อเนื่องพร้อมชื่อผู้เขียน</b>:</dt>
<dd>แสดงศัพท์คำต่อคำโดยไม่แยกกัน พร้อมไอคอนแก้ไข</dd>
<dt><b>เต็มรูปแบบพร้อมชื่อผู้เขียน</b>:</dt>
<dd>รูปแบบคล้ายกระดานเสวนา ซึ่งแสดงข้อมูลเกี่ยวกับผู้เขียน เอกสารหรือไฟล์แนบแสดงเป็นลิงก์</dd>
<dt><b>เต็มรูปแบบไม่รวมเชื่อผู้เขียน</b>:</dt>
<dd>รูปแบบคล้ายกระดานเสวนาโดยไม่แสดงข้อมูลเกี่ยวกับผู้เขียน  เอกสารหรือไฟล์แนบแสดงเป็นลิงก์</dd>
<dt><b>สารานุกรม</b>:</dt>
<dd>เหมือนแบบเต็มโดยแสดงผู้เขียน พร้อมแสดงรูปภาพที่แนบมาด้วย</dd>
<dt><b> คำถามถามบ่อย</b>:</dt>
<dd>เป็นประโยชน์สำหรับแสดงรายการคำถามที่ถามบ่อย ซึ่งผนวกคำ "คำถาม" และ "คำตอบ" โดยอัตโนมัติเข้าไปในแนวคิดและคำนิยามตามลำดับ</dd>
</dl>
</blockquote>

<hr />
<p>ผู้ดูแลระบบMoodle สามารถสร้างรูปแบบใหม่ๆ ตามคำแนะนำใน <b>mod/glossary/formats/README.txt</b>.</p>';
$string['displayformats'] = 'รูปแบบนำเสนอ';
$string['displayformatssetup'] = 'การตั้งค่ารูปแบบนำเสนอ';
$string['duplicateentry'] = 'มีศัพท์คำนี้แล้ว';
$string['editalways'] = 'แก้ไขได้ตลอด';
$string['editalways_help'] = '<p align="center"><b>แก้ไขได้ตลอด
</b></p>

<p>คุณอาจเลือกตั้งค่าว่าจะให้นักเรียนสามารถแก้ไขคำที่เพิ่มเข้าไป ณ เวลาใดๆ
<p>You can select โดยเลือก:

<ul>
<li><b>ใช่</b>หากต้องการให้คำที่เพิ่มเข้ามาใหม่สามารถแก้ไขเมื่อใดก็ได้

<li><b>ไม่ใช่</b>คำที่เพิ่มเข้ามาใหม่จะสามารถแก้ไขได ้ต่อเมื่อตั้งค่าเวลาให้แก้ไขได้
</ul>';
$string['editcategories'] = 'แก้ไขประเภทคำศัพท์';
$string['editentry'] = 'แก้ไขคำศัพท์';
$string['editingcomment'] = 'แก้ไขความคิดเห็น';
$string['entbypage'] = 'จำนวนคำศัพท์ที่ต้องการแสดงในหนึ่งหน้า';
$string['entries'] = 'คำศัพท์';
$string['entrieswithoutcategory'] = 'คำศัพท์ไม่มีประเภท';
$string['entry'] = 'คำศัพท์';
$string['entryalreadyexist'] = 'มีคำศัพท์นี้แล้ว';
$string['entryapproved'] = 'คำศัพท์นี้ได้รับการอนุมัติ';
$string['entrydeleted'] = 'คำศัพท์ถูกลบ';
$string['entryexported'] = 'ส่งออกคำศัพท์สำเร็จแล้ว';
$string['entryishidden'] = '(คำศัพท์นี้ถูกซ่อนอยู่)';
$string['entryleveldefaultsettings'] = 'การตั้งค่าระดับคำศัพท์';
$string['entrysaved'] = 'บันทึกคำศัพท์แล้ว';
$string['entryupdated'] = 'อัพเดทคำศัพท์แล้ว';
$string['entryusedynalink'] = 'ควรลิงก์คำศัพท์นี้อัตโนมัติ';
$string['entryusedynalink_help'] = '<p>การเปิดให้ส่วนนี้ทำงานจะทำให้คำศัพท์ลิงก์โดยอัตโนมัติ เมื่อไรก็ตามที่คำหรือวลีที่อธิบายแนวคิดมีใช้ในส่วนอื่นของรายวิชาเดียวกัน ซึ่งรวมถึงข้อความที่โพสต์บนกระดานเสวนา แหล่งข้อมูลภายใน สรุปผลรายสัปดาห์ บันทึกความก้าวหน้า และอื่นๆ</p>

<p>หากไม่ต้องการให้ข้อความใดลิงก์ไปที่อื่น (สมมติว่าเป็นข้อความในกระดานเสวนา) ให้เพิ่มแท็ก &lt;nolink&gt; และ &lt;/nolink&gt; รอบข้อความนั้น</p>

<p>หากต้องการให้ส่วนนี้ทำงาน ต้องเปิดให้การลิงก์อัตโนมัติทำงานในส่วนอภิธานศัพท์</p>';
$string['explainaddentry'] = 'เพิ่มคำศัพท์ใหม่ <br /> ต้องใส่คอนเซปต์และความหมาย';
$string['explainall'] = 'แสดงคำศัพท์ทั้งหมดในหน้าเดียว';
$string['explainalphabet'] = 'เลือกดูโดยใช้ดัชนีคำศัพท์';
$string['explainexport'] = 'ไฟล์ถูกสร้างขึ้น <br /> ดาวน์โหลดและเก็บไว้ในที่ปลอดภัย  คุณสามารถจะนำไปไว้ในรายวิชาใด ๆ ก็ได้เมื่อคุณต้องการ';
$string['explainimport'] = 'คุณต้องเลือกไฟล์ที่จะนำมาไว้ และกำหนดหลักการคัดเลือก <p> ส่งคำสั่งเลือกและตรวจทานผล';
$string['explainspecial'] = 'แสดงคำศัพท์ที่ไม่ได้เริ่มต้นด้วยตัวอักษร';
$string['exportedentry'] = 'คำศัพท์ที่ถูกส่งออกไป';
$string['exportentries'] = 'ส่งออกคำศัพท์';
$string['exportfile'] = 'ไฟล์ที่ทำการส่งออก';
$string['exportglossary'] = 'ส่งออกอภิธานศัพท์';
$string['exporttomainglossary'] = 'ส่งออกไปยังอภิธานศัพท์หลัก';
$string['filetoimport'] = 'ไฟล์ที่ต้องการส่งออก';
$string['filetoimport_help'] = '<p>เลือกไฟล์ XML ที่มีคำศัพท์ที่ต้องการจะนำเข้าจากคอมพิวเตอร์ของคุณ</p>';
$string['fillfields'] = 'ต้องเติมคอนเซปต์และคำจำกัดความของคำนะคะ';
$string['filtername'] = 'ลิงก์อภิธานศัพท์อัตโนมัติ';
$string['fullmatch'] = 'เลือกมาเฉพาะศัพท์ที่ตรงตัวค้นหา';
$string['fullmatch_help'] = '<p>หากเปิดใช้งานการลิงก์อัตโนมัติ เมื่อทำให้การตั้งค่านี้ทำงาน จะบังคับให้คำที่เหมือนกันทุกประการเท่านั้นที่จะลิงก์ได้


<p>เช่น อภิธานศัพท์คำว่า "construct" จะไม่ปรากฏเป็นลิงก์ภายใต้คำว่า "constructivism"</p>';
$string['glossaryleveldefaultsettings'] = 'ค่าที่ตั้งไว้ของระดับอภิธานศัพท์';
$string['glossarytype'] = 'ประเภทอภิธานศัพท์';
$string['glossarytype_help'] = '<p>คุณสามารถส่งคำศัพท์ซึ่งเป็นอภิธานศัพท์รองสู่อภิธานศัพท์หลักของรายวิชานั้นๆ ได้ ในระบบอภิธานศัพท์</p>

<p>หากต้องการส่งอภิธานศัพท์รองสู่อภิธานศัพท์หลัก ควรกำหนดว่าอภิธานศัพท์ใดเป็นอภิธานศัพท์หลักเสียก่อน</p>

<p>หมายเหตุ: คุณสามารถมีอภิธานศัพท์หลักได้เพียงอภิธานศัพท์เดียวต่อหนึ่งรายวิชา และมีเพียงผู้สอนเท่านั้นที่จะสามารถปรับปรุงให้เป็นปัจจุบันได้</p>';
$string['importcategories'] = 'นำเข้าประเภท';
$string['importedcategories'] = 'ประเภทคำศัพท์ถูกนำเข้า';
$string['importedentries'] = 'คำศัพท์ที่ถูกนำเข้า';
$string['importentries'] = 'นำเข้าคำศัพท์';
$string['isglobal'] = 'อภิธานศัพท์นี้ใช้สำหรับทั้งเว็บหรือไม่';
$string['isglobal_help'] = '<p align="center"><b>อภิธานศัพท์นี้ใช้สำหรับทั้งเว็บหรือไม่
</b></p>


<p>ผู้ดูแลระบบสามารถกำหนดอภิธานศัพท์ที่ใช้เป็นการทั่วไปได้</p>


<p>ซึ่งอภิธานศัพท์เหล่านี้อาจเป็นส่วนหนึ่งของรายวิชาใดก็ได้ (แต่โดยทั่วไปแล้วใช้กับหน้าแรก)</p>

   <p>ความแตกต่างที่ต่างจากอภิธานศัพท์สามัญก็คือ อภิธานศัพท์ทั่วไปจะใช้สำหรับลิงก์อัตโนมัติไปทั่วทั้งไซต์ (และไม่จำกัดอยู่แค่เพียงรายวิชาใดวิชาหนึ่ง)</p>';
$string['linkcategory'] = 'ลิงก์คำศัพท์อัตโนมัติ';
$string['linkcategory_help'] = '<p>สามารถกำหนดว่าต้องการทำลิงก์อัตโนมัติให้คำศัพท์ทั้งกลุ่มหรือไม่</p>

<p>หมายเหตุ: จะสามารถทำลิงก์ให้กลุ่มประเภทคำศัพท์ได้ ขึ้นอยู่กับการเลือกทำลิงก์อัตโนมัติให้คำศัพท์กรณีเป็นอักษรตัวเล็ก - ใหญ่ หรือ ทำลิงก์อัตโนมัติให้คำศัพท์ทั้งหมด</p>';
$string['mainglossary'] = 'อภิธานศัพท์หลัก';
$string['maxtimehaspassed'] = 'ขออภัย แต่คุณเลยกำหนดเวลาที่จะเขียนความคิดเห็น ({$a}) นี้แล้ว';
$string['modulename'] = 'อภิธานศัพท์';
$string['modulenameplural'] = 'อภิธานศัพท์';
$string['newentries'] = 'อภิธานศัพท์ใหม่';
$string['newglossary'] = 'อภิธานศัพท์ใหม่';
$string['newglossarycreated'] = 'อภิธานศัพท์ใหม่ที่เพิ่งถูกสร้างขึ้น';
$string['newglossaryentries'] = 'อภิธานศัพท์ใหม่:';
$string['nocomment'] = 'ไม่พบความคิดเห็น';
$string['nocomments'] = 'ไม่พบความคิดเห็นในรายการนี้';
$string['noconceptfound'] = 'ไม่พบคอนเซปต์ หรือ คำจำกัดความ';
$string['noentries'] = 'ไม่คำศัพท์ในส่วนนี้';
$string['noentry'] = 'ไม่พบคำศัพท์นี้';
$string['notcategorised'] = 'ไม่อยู่ในประเภทใด';
$string['numberofentries'] = 'จำนวนคำศัพท์';
$string['onebyline'] = 'หนึ่งคำต่อบรรทัด';
$string['pluginname'] = 'อภิธานศัพท์';
$string['printerfriendly'] = 'รูปแบบที่สะดวกต่อการพิมพ์';
$string['printviewnotallowed'] = 'ไม่อนุญาตให้ใช้มุมมองการพิมพ์';
$string['question'] = 'คำถาม';
$string['rejectedentries'] = 'ไม่รับการเพิ่มคำศัพท์นี้';
$string['rejectionrpt'] = 'รายงานการปฏิเสธการเพิ่มคำศัพท์';
$string['rssarticles_help'] = '<p>สามารถเลือกตั้งค่าจำนวนคำศัพท์เพื่อให้รวมอยู่ใน RSS Feed ได้ที่นี่

<p>จำนวนคำศัพท์สำหรับอภิธานศัพท์ โดยปกติอยู่ที่ 5 ถึง 20 บทความ อาจเพิ่มจำนวนบทความให้มากขึ้นหากอภิธานศัพท์ได้รับการปรับปรุงให้เป็นปัจจุบันบ่อยครั้ง';
$string['rsssubscriberss'] = 'แสดง RSS feed สำหรับ \'{$a}\'  คอนเซปต์';
$string['rsstype_help'] = '<p>สามารถเลือกตั้งค่าให้ RSS Feed ทำงานจากอภิธานศัพท์นี้

<p>คุณสามารถเลือกว่าจะใช้ feed ประเภทใดใน 2 ประเภทนี้

<ul>
<li><b>With author การป้อนข้อมูลแบบแสดงชื่อผู้เขียน:</b>การป้อนข้อมูลที่สร้างขึ้นจะแสดงโดยรวมชื่อผู้เขียนในทุกบทความ

<li><b>Without author การป้อนข้อมูลแบบไม่แสดงชื่อผู้เขียน:</b> การป้อนข้อมูลที่สร้างขึ้นจะแสดงโดยไม่รวมชื่อผู้เขียนในทุกบทความ
</ul>';
$string['searchindefinition'] = 'หาคำจำกัดความทั้งหมด';
$string['secondaryglossary'] = 'อภิธานศัพท์ขั้นรอง';
$string['showall'] = 'แสดงลิงก์ทั้งหมด';
$string['showall_help'] = '<p>คุณสามารถตั้งค่าว่าผู้ใช้จะ browse อภิธานศัพท์อย่างไรก็ได้ ปกติ การ browse และการสืบค้นจะได้รับการตั้งค่าให้ทำได้อยู่แล้ว  ซึ่งคุณอาจกำหนดทางเลือกสำหรับผู้ใช้ได้ 3 แบบ ดังนี้</p>

<p><b>SHOW SPECIAL แสดงแบบพิเศษ</b> ให้ browse ได้หรือไม่ได้ด้วยตัวอักษรพิเศษ อย่าง เครื่องหมาย @ เครื่องหมายชาร์ป (#) หรืออื่นๆ</p>

<p><b>SHOW ALPHABET แสดงแบบเรียงตามลำดับตัวอักษร</b> ให้หรือไม่ให้ browse แบบเรียงตามลำดับตัวอักษร</p>

<p><b>SHOW ALL แสดงทั้งหมด</b>ให้ browse คำศัพท์ทั้งหมดได้ในครั้งเดียว หรือไม่ก็ได้</p>';
$string['showalphabet'] = 'แสดงตัวอักษร';
$string['showalphabet_help'] = '<p>คุณสามารถตั้งค่าว่าผู้ใช้จะ browse อภิธานศัพท์อย่างไรก็ได้ ปกติ การ browse และการสืบค้นจะได้รับการตั้งค่าให้ทำได้อยู่แล้ว  ซึ่งคุณอาจกำหนดทางเลือกสำหรับผู้ใช้ได้ 3 แบบ ดังนี้</p>

<p><b>SHOW SPECIAL แสดงแบบพิเศษ</b> ให้ browse ได้หรือไม่ได้ด้วยตัวอักษรพิเศษ อย่าง เครื่องหมาย @ เครื่องหมายชาร์ป (#) หรืออื่นๆ</p>

<p><b>SHOW ALPHABET แสดงแบบเรียงตามลำดับตัวอักษร</b> ให้หรือไม่ให้ browse แบบเรียงตามลำดับตัวอักษร</p>

<p><b>SHOW ALL แสดงทั้งหมด</b>ให้ browse คำศัพท์ทั้งหมดได้ในครั้งเดียว หรือไม่ก็ได้</p>';
$string['showspecial'] = 'แสดงลิงก์พิเศษ';
$string['showspecial_help'] = '<p>คุณสามารถตั้งค่าว่าผู้ใช้จะ browse อภิธานศัพท์อย่างไรก็ได้ ปกติ การ browse และการสืบค้นจะได้รับการตั้งค่าให้ทำได้อยู่แล้ว  ซึ่งคุณอาจกำหนดทางเลือกสำหรับผู้ใช้ได้ 3 แบบ ดังนี้</p>

<p><b>SHOW SPECIAL แสดงแบบพิเศษ</b> ให้ browse ได้หรือไม่ได้ด้วยตัวอักษรพิเศษ อย่าง เครื่องหมาย @ เครื่องหมายชาร์ป (#) หรืออื่นๆ</p>

<p><b>SHOW ALPHABET แสดงแบบเรียงตามลำดับตัวอักษร</b> ให้หรือไม่ให้ browse แบบเรียงตามลำดับตัวอักษร</p>

<p><b>SHOW ALL แสดงทั้งหมด</b>ให้ browse คำศัพท์ทั้งหมดได้ในครั้งเดียว หรือไม่ก็ได้</p>';
$string['sortby'] = 'เรียงโดย';
$string['sortbycreation'] = 'วันที่สร้าง';
$string['sortbylastupdate'] = 'วันที่อัพเดทครั้งสุดท้าย';
$string['sortchronogically'] = 'เรียงจากวันที่';
$string['special'] = 'พิเศษ';
$string['standardview'] = 'เลือกโดยตัวอักษร';
$string['studentcanpost'] = 'นักเรียนสามารถเพิ่มคำศัพท์ได้';
$string['totalentries'] = 'จำนวนคำศัพท์ทั้งหมด';
$string['usedynalink'] = 'ลิงก์ไปที่คำศัพท์อัตโนมัติ';
$string['usedynalink_help'] = '<p> การเปิดให้ส่วนนี้ทำงานจะทำให้คำศัพท์ในอภิธานศัพท์กลายเป็นลิงก์อัตโนมัติ เมื่อใดก็ตามที่คำหรือวลีที่อธิบายแนวคิดมีใช้ในส่วนอื่นของรายวิชาเดียวกัน ซึ่งรวมถึงข้อความที่โพสต์บนกระดานเสวนา แหล่งข้อมูลภายใน สรุปผลรายสัปดาห์ บันทึกความก้าวหน้า และอื่นๆ </p>

<p>พึงจำไว้ว่า การทำลิงก์สำหรับอภิธานศัพท์ไม่ได้หมายความว่า ลิงก์สำหรับคำศัพท์แต่ละคำจะทำงานโดยอัตโนมัติ หากต้องตั้งค่าการทำงานให้กับลิงก์แต่ละคำแยกต่างหาก</p>

<p>หากไม่ต้องการให้ข้อความใดลิงก์ไปที่อื่น (สมมติว่าเป็นข้อความในกระดานเสวนา) ให้เพิ่มแท็ก &lt;nolink&gt; และ &lt;/nolink&gt; รอบข้อความนั้น</p>

<p>พึงจำไว้ว่า ชื่อกลุ่มประเภทคำศัพท์สามารถทำลิงก์ได้เช่นกัน</p>';
$string['waitingapproval'] = 'รอการอนุมัติอยู่';
$string['warningstudentcapost'] = '(ใช้ในกรณีที่คำศัพท์ไม่ได้อยู่ในอภิธานศัพท์)';
$string['withauthor'] = 'คอนเซปต์และชื่อผู้แต่ง';
$string['withoutauthor'] = 'คอนเซปต์ที่ไม่ชื่อผู้แต่ง';
$string['writtenby'] = 'โดย';
$string['youarenottheauthor'] = 'คุณไม่ใช่ผู้ที่เขียนความคิดเห็นนี้ขึ้น  คุณจึงไม่สามารถแก้ไขความคิดเห็นนี้ได้ค่ะ';
