<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'editor_tinymce', language 'th', branch 'MOODLE_32_STABLE'
 *
 * @package   editor_tinymce
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['advanced:address'] = 'ที่อยู่';
$string['advanced:anchor_delta_height'] = '';
$string['advanced:anchor_delta_width'] = '';
$string['advanced:anchor_desc'] = 'เพิ่ม/แก้ไข ข้อความลิ้งค์';
$string['advanced:backcolor_desc'] = 'เลือกสีพื้นหลัง';
$string['advanced:block'] = 'รูปแบบ';
$string['advanced:blockquote'] = 'อ้างอิง';
$string['advanced:blockquote_desc'] = 'อ้างถึง';
$string['advanced:bold_desc'] = 'ตัวหนา (Ctrl+B)';
$string['advanced:bullist_desc'] = 'ลำดับรายการ';
$string['advanced:charmap_delta_height'] = '';
$string['advanced:charmap_delta_width'] = '';
$string['advanced:charmap_desc'] = 'เลือกตัวอักษร';
$string['advanced:cleanup_desc'] = 'ล้างโค๊ด';
$string['advanced:clipboard_msg'] = 'คัดลอก / ตัด / วางยังไม่มีให้บริการใน Mozilla และ Firefox.nDo คุณต้องการข้อมูลเพิ่มเติมเกี่ยวกับปัญหานี้หรือไม่?';
$string['advanced:code'] = 'โค๊ด';
$string['advanced:code_desc'] = 'แก้ไข HTML';
$string['advanced:colorpicker_delta_height'] = '';
$string['advanced:colorpicker_delta_width'] = '';
$string['advanced:copy_desc'] = 'คัดลอก';
$string['advanced:custom1_desc'] = 'ใส่รายละเอียดเองได้ที่นี่';
$string['advanced:cut_desc'] = 'ตัด';
$string['advanced:dd'] = 'รายละเอียดคำนิยาม';
$string['advanced:div'] = 'Div';
$string['advanced_dlg:about_author'] = 'ผู้เขียน';
$string['advanced_dlg:about_general'] = 'เกี่ยวกับเรา';
$string['advanced_dlg:about_help'] = 'ช่วยเลหือ';
$string['advanced_dlg:about_license'] = 'ลิขสิทธิ';
$string['advanced_dlg:about_loaded'] = 'โหลดปลั๊กอิน';
$string['advanced_dlg:about_plugin'] = 'ปลั๊กอิน';
$string['advanced_dlg:about_plugins'] = 'ปลั๊กอิน';
$string['advanced_dlg:about_title'] = 'เกี่ยวกับ TinyMCE';
$string['advanced_dlg:about_version'] = 'รุ่น';
$string['advanced_dlg:anchor_name'] = 'ข้อความลิ้งค์';
$string['advanced_dlg:anchor_title'] = 'เพิ่ม/แก้ไข ข้อความลิ้งค์';
$string['advanced_dlg:charmap_title'] = 'เลือกตัวอักษรที่กำหนดเอง';
$string['advanced_dlg:code_title'] = 'แก้ไข HTML';
$string['advanced_dlg:code_wordwrap'] = 'ตัดคำ';
$string['advanced_dlg:colorpicker_color'] = 'สี:';
$string['advanced_dlg:colorpicker_name'] = 'ชื่อ:';
$string['advanced_dlg:colorpicker_named_tab'] = 'ชื่อ';
$string['advanced_dlg:colorpicker_named_title'] = 'ชื่อสี';
$string['advanced_dlg:colorpicker_palette_tab'] = 'จานสี';
$string['advanced_dlg:colorpicker_palette_title'] = 'จานสี';
$string['advanced_dlg:colorpicker_picker_tab'] = 'เลือกสี';
$string['advanced_dlg:colorpicker_picker_title'] = 'จานสี';
$string['advanced_dlg:colorpicker_title'] = 'เลือกสี';
$string['advanced_dlg:image_align'] = 'ตำแหน่งจัดวาง';
$string['advanced_dlg:image_align_baseline'] = 'เส้นพื้น';
$string['advanced_dlg:image_align_bottom'] = 'ล่าง';
$string['advanced_dlg:image_align_left'] = 'ซ้าย';
$string['advanced_dlg:image_align_middle'] = 'กลาง';
$string['advanced_dlg:image_align_right'] = 'ขวา';
$string['advanced_dlg:image_align_textbottom'] = 'ข้อความอยู่ล่าง';
$string['advanced_dlg:image_align_texttop'] = 'ข้อความอยู่บน';
$string['advanced_dlg:image_align_top'] = 'บน';
$string['advanced_dlg:image_alt'] = 'รายละอียดรูป';
$string['advanced_dlg:image_border'] = 'กรอบ';
$string['advanced_dlg:image_dimensions'] = 'ขนาด';
$string['advanced_dlg:image_hspace'] = 'ระยะห่างแนวนอน';
$string['advanced_dlg:image_list'] = 'รายการรูป';
$string['advanced_dlg:image_src'] = 'URL รูป';
$string['advanced_dlg:image_title'] = 'เพิ่ม/แก้ไข รูป';
$string['advanced_dlg:image_vspace'] = 'ระยะห่างแนวตั้ง';
$string['advanced_dlg:link_is_email'] = 'URL ที่คุณป้อนดูเหมือนว่าจะมีที่อยู่อีเมลอยู่ต้องการเพิ่ม mailto: นำหน้าหรือไม่ ?';
$string['advanced_dlg:link_is_external'] = 'URL ที่คุณป้อนดูเหมือนว่าภายนอกลิงคคุณต้องการเพิ่ม  http:// หรือไม่ ?';
$string['advanced_dlg:link_list'] = 'รายการลิ้งค์';
$string['advanced_dlg:link_target'] = 'เป้าหมาย';
$string['advanced_dlg:link_target_blank'] = 'เปิดลิงก์ในหน้าต่างใหม่';
$string['advanced_dlg:link_target_same'] = 'เปิดลิงก์ในหน้าต่างเดียวกัน';
$string['advanced_dlg:link_title'] = 'เพิ่ม/แก้ไข ลิ้งค์';
$string['advanced_dlg:link_titlefield'] = 'ชื่อ';
$string['advanced_dlg:link_url'] = 'ลิ้งค์ URL';
$string['advanced:dt'] = 'คำนิยาม';
$string['advanced:fontdefault'] = 'เลือกตัวอักษร';
$string['advanced:font_size'] = 'ขนาดตัวอักษร';
$string['advanced:forecolor_desc'] = 'เลือกสีข้อความ';
$string['advanced:h1'] = 'Heading 1';
$string['advanced:h2'] = 'Heading 2';
$string['advanced:h3'] = 'Heading 3';
$string['advanced:h4'] = 'Heading 4';
$string['advanced:h5'] = 'Heading 5';
$string['advanced:h6'] = 'Heading 6';
$string['advanced:help_desc'] = 'ช่วยเหลือ';
$string['advanced:hr_desc'] = 'ใส่เส้นบันทัด';
$string['advanced:image_delta_height'] = '';
$string['advanced:image_delta_width'] = '';
$string['advanced:image_desc'] = 'เพิ่ม/แก้ไข รูป';
$string['advanced:image_props_desc'] = 'คุณสมบัติรูป';
$string['advanced:indent_desc'] = 'เยื้องขวา';
$string['advanced:italic_desc'] = 'ตัวเอียง (Ctrl+I)';
$string['advanced:justifycenter_desc'] = 'จัดกลาง';
$string['advanced:justifyfull_desc'] = 'จัดเต็มหน้า';
$string['advanced:justifyleft_desc'] = 'จัดซ้าย';
$string['advanced:justifyright_desc'] = 'จัดขวา';
$string['advanced:link_delta_height'] = '';
$string['advanced:link_delta_width'] = '';
$string['advanced:link_desc'] = 'เพิ่ม/แก้ไข ลิ้งค์';
$string['advanced:more_colors'] = 'สีอื่นๆ';
$string['advanced:newdocument'] = 'คุณแน่ใจหรือไม่ว่าต้องการล้างเนื้อหาทั้งหมด?';
$string['advanced:newdocument_desc'] = 'เอกสารใหม่';
$string['advanced:numlist_desc'] = 'ลำดับตัวเลข';
$string['advanced:outdent_desc'] = 'ลดการเยื้อง';
$string['advanced:paragraph'] = 'ย่อหน้า';
$string['advanced:paste_desc'] = 'วาง';
$string['advanced:path'] = 'พาท';
$string['advanced:pre'] = 'รูปแบบพื้นฐาน';
$string['advanced:redo_desc'] = 'ย้อนกลับ (Ctrl+Y)';
$string['advanced:removeformat_desc'] = 'ล้างรูปแบบ';
$string['advanced:samp'] = 'โค๊ดตัวอย่าง';
$string['advanced:striketrough_desc'] = 'ขีดฆ่า';
$string['advanced:style_select'] = 'รูปแบบ';
$string['advanced:sub_desc'] = 'ตัวห้อย';
$string['advanced:sup_desc'] = 'ตัวยก';
$string['advanced:toolbar_focus'] = 'Jump to tool buttons - Alt+Q, Jump to editor - Alt-Z, Jump to element path - Alt-X';
$string['advanced:underline_desc'] = 'ตัวขีดเส้นใต้(Ctrl+U)';
$string['advanced:undo_desc'] = 'ยกเลิก (Ctrl+Z)';
$string['advanced:unlink_desc'] = 'ยกเลิกลิ้งค์';
$string['advanced:visualaid_desc'] = 'สลับ guidelines/ซ่อน elements';
$string['advhr:advhr_desc'] = 'เส้นบันทัด';
$string['advhr:delta_height'] = '';
$string['advhr:delta_width'] = '';
$string['advhr_dlg:noshade'] = 'ไม่มีเงา';
$string['advhr_dlg:size'] = 'สูง';
$string['advhr_dlg:width'] = 'กว้าง';
$string['advimage:delta_height'] = '';
$string['advimage:delta_width'] = '';
$string['advimage_dlg:align'] = 'ตำแหน่งจัดวาง';
$string['advimage_dlg:align_baseline'] = 'เส้นพื้น';
$string['advimage_dlg:align_bottom'] = 'ล่าง';
$string['advimage_dlg:align_left'] = 'ซ้าย';
$string['advimage_dlg:align_middle'] = 'กลาง';
$string['advimage_dlg:align_right'] = 'ขวา';
$string['advimage_dlg:align_textbottom'] = 'ตัวอักษรอยู่ล่าง';
$string['advimage_dlg:align_texttop'] = 'ตัวอักษรอยู่บน';
$string['advimage_dlg:align_top'] = 'บน';
$string['advimage_dlg:alt'] = 'รายละเอียดรูป';
$string['advimage_dlg:alt_image'] = 'ข้อความรูป';
$string['advimage_dlg:border'] = 'กรอบ';
$string['advimage_dlg:classes'] = 'คลาส';
$string['advimage_dlg:constrain_proportions'] = 'คงสัดส่วน';
$string['advimage_dlg:dialog_title'] = 'เพิ่ม/แก้ไข image';
$string['advimage_dlg:dimensions'] = 'ตำแหน่ง';
$string['advimage_dlg:example_img'] = 'ดูตัวอย่างลักษณะของรูป';
$string['advimage_dlg:general'] = 'ทั่วไป';
$string['advimage_dlg:hspace'] = 'ระยะห่างแนวนอน';
$string['advimage_dlg:id'] = 'Id';
$string['advimage_dlg:image_list'] = 'รายการรูป';
$string['advimage_dlg:langcode'] = 'โค๊ดภาษา';
$string['advimage_dlg:langdir'] = 'ทิศทางการอ่าน';
$string['advimage_dlg:list'] = 'รายการรูป';
$string['advimage_dlg:long_desc'] = 'รายละเอียดลิ้งค์';
$string['advimage_dlg:ltr'] = 'ซ้ายไปขวา';
$string['advimage_dlg:map'] = 'Image map';
$string['advimage_dlg:misc'] = 'เบ็ดเตล็ด';
$string['advimage_dlg:missing_alt'] = 'คุณแน่ใจหรือไม่ว่าต้องการดำเนินการต่อโดยไม่ใส่คำอธิบายรูปภาพ ? การใส่คำอธิบายรูปทำให้ผู้พิการทางสายตาสามารถรู้ได้ว่ารูปคุณคือรูปอะไร';
$string['advimage_dlg:mouseout'] = 'เมื่อเอาเม้าส์ออก';
$string['advimage_dlg:mouseover'] = 'เมื่อเอาเม้าส์ชี้';
$string['advimage_dlg:preview'] = 'ดูตัวอย่าง';
$string['advimage_dlg:rtl'] = 'ขวาไปซ้าย';
$string['advimage_dlg:src'] = 'ที่อยู่รูป';
$string['advimage_dlg:style'] = 'รูปแบบ';
$string['advimage_dlg:swap_image'] = 'Swap image';
$string['advimage_dlg:tab_advanced'] = 'ขั้นสูง';
$string['advimage_dlg:tab_appearance'] = 'ลักษณะ';
$string['advimage_dlg:tab_general'] = 'ทั่วไป';
$string['advimage_dlg:title'] = 'ชื่อ';
$string['advimage_dlg:vspace'] = 'ระยะห่างแนวตั้ง';
$string['advimage:image_desc'] = 'เพิ่ม/แก้ไข รูป';
$string['advlink:delta_height'] = '';
$string['advlink:delta_width'] = '';
$string['advlink_dlg:accesskey'] = 'Accesskey';
$string['advlink_dlg:advanced_props'] = 'ตั้งค่าขั้นสูง';
$string['advlink_dlg:advanced_tab'] = 'ขั้นสูง';
$string['advlink_dlg:anchor_names'] = 'ชื่อลิ้งค์';
$string['advlink_dlg:classes'] = 'คลาส';
$string['advlink_dlg:encoding'] = 'เป้าหมายตัวอักษร';
$string['advlink_dlg:event_props'] = 'กิจกรรม';
$string['advlink_dlg:events_tab'] = 'กิจกรรม';
$string['advlink_dlg:general_props'] = 'ตั้งค่าทั่วไป';
$string['advlink_dlg:general_tab'] = 'ทั่วไป';
$string['advlink_dlg:id'] = 'Id';
$string['advlink_dlg:is_email'] = 'URL ที่คุณป้อนดูเหมือนว่าจะมีที่อยู่อีเมลอยู่ต้องการเพิ่ม mailto: นำหน้าหรือไม่';
$string['advlink_dlg:is_external'] = 'URL ที่คุณป้อนดูเหมือนว่าภายนอกลิงคคุณต้องการเพิ่ม  http:// หรือไม่ ?';
$string['advlink_dlg:langcode'] = 'โค๊ดภาษา';
$string['advlink_dlg:langdir'] = 'ทิศทางการอ่าน';
$string['advlink_dlg:link_list'] = 'รายการลิ้งค์';
$string['advlink_dlg:list'] = 'รายการลิ้งค์';
$string['advlink_dlg:ltr'] = 'ซ้ายไปขวา';
$string['advlink_dlg:mime'] = 'เป้าหมาย MIME type';
$string['advlink_dlg:popup'] = 'จาวา ป๊อป-อัพ';
$string['advlink_dlg:popup_dependent'] = 'Dependent (Mozilla/Firefox only)';
$string['advlink_dlg:popup_location'] = 'แสดงช่องที่อยู่';
$string['advlink_dlg:popup_menubar'] = 'แสดงเมนูบาร์';
$string['advlink_dlg:popup_name'] = 'ชื่อหน้าต่าง';
$string['advlink_dlg:popup_opts'] = 'ตัวเลือก';
$string['advlink_dlg:popup_position'] = 'ตำแหน่ง (X/Y)';
$string['advlink_dlg:popup_props'] = 'ตั้งค่าป๊อป-อัพ';
$string['advlink_dlg:popup_resizable'] = 'เปลี่ยนขนาดของหน้าต่างได้';
$string['advlink_dlg:popup_return'] = 'เพิ่ม \'return false\'';
$string['advlink_dlg:popup_scrollbars'] = 'แสดงสกอลบาร์';
$string['advlink_dlg:popup_size'] = 'ขนาด';
$string['advlink_dlg:popup_statusbar'] = 'แสดง สเตตัสบาร์';
$string['advlink_dlg:popup_tab'] = 'ป๊อป-อัพ';
$string['advlink_dlg:popup_toolbar'] = 'แสเงทูลบาร์';
$string['advlink_dlg:popup_url'] = 'ป๊อป-อัพ URL';
$string['advlink_dlg:rel'] = 'Relationship page to target';
$string['advlink_dlg:rev'] = 'Relationship target to page';
$string['advlink_dlg:rtl'] = 'ขวาไปซ้าย';
$string['advlink_dlg:style'] = 'รูปแบบ';
$string['advlink_dlg:tabindex'] = 'Tabindex';
$string['advlink_dlg:target'] = 'เป้าหมาย';
$string['advlink_dlg:target_blank'] = 'เปิดในหน้าต่างใหม่';
$string['advlink_dlg:target_langcode'] = 'เป้าหมาย ภาษา';
$string['advlink_dlg:target_name'] = 'ชื่อเป้าหมาย';
$string['advlink_dlg:target_parent'] = 'เปิดในหน้าต่างเดิม / เฟรม';
$string['advlink_dlg:target_same'] = 'เปิดในหน้าต่างใหม่ / เฟรม';
$string['advlink_dlg:target_top'] = 'เปิดที่เฟรมบน (แทนที่ทุกเฟรม)';
$string['advlink_dlg:title'] = 'เพิ่ม/แก้ไข ลิ้งค์';
$string['advlink_dlg:titlefield'] = 'ชื่อ';
$string['advlink_dlg:url'] = 'ที่อยู่ ลิ้งค์';
$string['advlink:link_desc'] = 'เพิ่ม/แก้ไข ลิ้งค์';
$string['autosave:unload_msg'] = 'การเปลี่ยนแปลงที่คุณทำจะหายไปหากคุณออกจากหน้านี้';
$string['common:apply'] = 'ใช้งาน';
$string['common:browse'] = 'เลือกไฟล์';
$string['common:cancel'] = 'ยกเลิก';
$string['common:class_name'] = 'คลาส';
$string['common:clipboard_msg'] = 'คัดลอก / ตัด / วางยังไม่มีให้บริการใน Mozilla และ Firefox.nDo คุณต้องการข้อมูลเพิ่มเติมเกี่ยวกับปัญหานี้หรือไม่?';
$string['common:clipboard_no_support'] = 'ขณะนี้ยังไม่สนับสนุนเบราเซอร์ของคุณ ให้ใช้แป้นพิมพ์ลัดแทน';
$string['common:close'] = 'ปิด';
$string['common:edit_confirm'] = 'คุณต้องการใช้โหมด WYSIWYG ในการเขียนบทความหรือไม่ ?';
$string['common:insert'] = 'เพิ่ม';
$string['common:invalid_data'] = 'ข้อผิดพลาด: ป้อนค่าในช้องสีแดงให้ถูกต้อง';
$string['common:more_colors'] = 'สีอื่นๆ';
$string['common:not_set'] = '-- ไม่ได้ตั้งค่า --';
$string['common:popup_blocked'] = 'ขออภัยแต่เราพบว่าคุณมีระบบป้องกันป๊อปอัป คุณจะต้องปิดการใช้งานการบล็อคป๊อปอัป';
$string['common:update'] = 'อัพเดต';
$string['contextmenu:align'] = 'ตำแหน่งจัดวาง';
$string['contextmenu:center'] = 'กลาง';
$string['contextmenu:full'] = 'เต็ม';
$string['contextmenu:left'] = 'ซ้าย';
$string['contextmenu:right'] = 'ขวา';
$string['directionality:ltr_desc'] = 'อ่านจากซ้ายไปขวา';
$string['directionality:rtl_desc'] = 'อ่านจากขวาไปซ้าย';
$string['emotions:delta_height'] = '';
$string['emotions:delta_width'] = '';
$string['emotions_dlg:cool'] = 'เจ๋ง';
$string['emotions_dlg:cry'] = 'ร้องให้';
$string['emotions_dlg:desc'] = 'แสดงอารมณ์';
$string['emotions_dlg:embarassed'] = 'อาย';
$string['emotions_dlg:foot_in_mouth'] = 'ปิดปาก';
$string['emotions_dlg:frown'] = 'บึ้งตึง';
$string['emotions_dlg:innocent'] = 'ไร้เดียงสา';
$string['emotions_dlg:kiss'] = 'จูบ';
$string['emotions_dlg:laughing'] = 'หัวเราะ';
$string['emotions_dlg:money_mouth'] = 'เงินๆๆๆ';
$string['emotions_dlg:sealed'] = 'ปิดปาก';
$string['emotions_dlg:smile'] = 'Smile';
$string['emotions_dlg:surprised'] = 'ประหลาดใจ';
$string['emotions_dlg:title'] = 'เพิ่มรูปแสดงอารมณ์';
$string['emotions_dlg:tongue_out'] = 'แลบลิ้น';
$string['emotions_dlg:undecided'] = 'ลังเล';
$string['emotions_dlg:wink'] = 'ขยิบตา';
$string['emotions_dlg:yell'] = 'โวยวาย';
$string['emotions:emotions_desc'] = 'Emotions';
$string['fullpage:delta_height'] = '';
$string['fullpage:delta_width'] = '';
$string['fullpage:desc'] = 'คุณสมบัติเอกสาร';
$string['fullpage_dlg:active_color'] = 'Active color';
$string['fullpage_dlg:add'] = 'Add new element';
$string['fullpage_dlg:add_base'] = 'Base element';
$string['fullpage_dlg:add_comment'] = 'Comment node';
$string['fullpage_dlg:add_link'] = 'Link element';
$string['fullpage_dlg:add_meta'] = 'Meta element';
$string['fullpage_dlg:add_script'] = 'Script element';
$string['fullpage_dlg:add_style'] = 'รูปแบบ element';
$string['fullpage_dlg:add_title'] = 'ชื่อ element';
$string['fullpage_dlg:advanced_props'] = 'ขั้นสูง';
$string['fullpage_dlg:advanced_tab'] = 'ขั้นสูง';
$string['fullpage_dlg:appearance_bgprops'] = 'คุณสมบัติพื้นหลัง';
$string['fullpage_dlg:appearance_linkprops'] = 'สีลิ้งค์';
$string['fullpage_dlg:appearance_marginprops'] = 'Body margins';
$string['fullpage_dlg:appearance_style'] = 'รูปแบบsheet and style properties';
$string['fullpage_dlg:appearance_tab'] = 'รูปลักษณ์';
$string['fullpage_dlg:appearance_textprops'] = 'คุณสมบัติข้อความ';
$string['fullpage_dlg:author'] = 'Author';
$string['fullpage_dlg:base_element'] = 'Base element';
$string['fullpage_dlg:bgcolor'] = 'พื้นหลัง color';
$string['fullpage_dlg:bgimage'] = 'พื้นหลัง image';
$string['fullpage_dlg:bottom_margin'] = 'ขอบล่าง';
$string['fullpage_dlg:charset'] = 'Charset';
$string['fullpage_dlg:comment_element'] = 'Comment';
$string['fullpage_dlg:content'] = 'Content';
$string['fullpage_dlg:copyright'] = 'Copyright';
$string['fullpage_dlg:defer'] = 'Defer';
$string['fullpage_dlg:doctypes'] = 'Doctype';
$string['fullpage_dlg:encoding'] = 'Character encoding';
$string['fullpage_dlg:fontface'] = 'เลือกตัวอกษร';
$string['fullpage_dlg:font_face'] = 'ตัวอักษร';
$string['fullpage_dlg:fontsize'] = 'ขนาดตัวอักษร';
$string['fullpage_dlg:font_size'] = 'ขนาดตัวอักษร';
$string['fullpage_dlg:general_props'] = 'ทั่วไป';
$string['fullpage_dlg:head_elements'] = 'Head elements';
$string['fullpage_dlg:hover_color'] = 'Hover color';
$string['fullpage_dlg:href'] = 'Href';
$string['fullpage_dlg:hreflang'] = 'Href lang';
$string['fullpage_dlg:info'] = 'Information';
$string['fullpage_dlg:langcode'] = 'โค๊ดภาษา';
$string['fullpage_dlg:langdir'] = 'ทิศทางการอ่าน';
$string['fullpage_dlg:langprops'] = 'ภาษา และ การเข้ารหัส';
$string['fullpage_dlg:language'] = 'ภาษา';
$string['fullpage_dlg:left_margin'] = 'ขอบซ้าย';
$string['fullpage_dlg:link_color'] = 'สีลิ้งค์';
$string['fullpage_dlg:link_element'] = 'Link element';
$string['fullpage_dlg:ltr'] = 'ซ้ายไปขวา';
$string['fullpage_dlg:media'] = 'Media';
$string['fullpage_dlg:meta_description'] = 'รายละเอียด';
$string['fullpage_dlg:meta_element'] = 'Meta element';
$string['fullpage_dlg:meta_index_follow'] = 'Index and follow the ลิ้งค์s';
$string['fullpage_dlg:meta_index_nofollow'] = 'Index and don\'t follow the ลิ้งค์s';
$string['fullpage_dlg:meta_keywords'] = 'คำสำคัญ';
$string['fullpage_dlg:meta_noindex_follow'] = 'Do not index but follow the ลิ้งค์s';
$string['fullpage_dlg:meta_noindex_nofollow'] = 'Do not index and don\'t follow the ลิ้งค์s';
$string['fullpage_dlg:meta_props'] = 'รายละเอียดเมต้า';
$string['fullpage_dlg:meta_robots'] = 'Robots';
$string['fullpage_dlg:meta_tab'] = 'ทั่วไป';
$string['fullpage_dlg:meta_title'] = 'ชื่อ';
$string['fullpage_dlg:movedown'] = 'Move selected element down';
$string['fullpage_dlg:moveup'] = 'Move selected element up';
$string['fullpage_dlg:name'] = 'Name';
$string['fullpage_dlg:properties'] = 'Properties';
$string['fullpage_dlg:rel'] = 'Rel';
$string['fullpage_dlg:remove'] = 'Remove selected element';
$string['fullpage_dlg:rev'] = 'Rev';
$string['fullpage_dlg:right_margin'] = 'ขอบขวา';
$string['fullpage_dlg:rtl'] = 'ขวาไปซ้าย';
$string['fullpage_dlg:script_element'] = 'Script element';
$string['fullpage_dlg:src'] = 'Src';
$string['fullpage_dlg:style'] = 'รูปแบบ';
$string['fullpage_dlg:style_element'] = 'รูปแบบ element';
$string['fullpage_dlg:stylesheet'] = 'รูปแบบsheet';
$string['fullpage_dlg:target'] = 'เป้าหมาย';
$string['fullpage_dlg:textcolor'] = 'สี';
$string['fullpage_dlg:text_color'] = 'สีข้อความ';
$string['fullpage_dlg:title'] = 'คุณสมบัติเอกสาร';
$string['fullpage_dlg:title_element'] = 'ชื่อ element';
$string['fullpage_dlg:top_margin'] = 'ขอบบม';
$string['fullpage_dlg:type'] = 'Type';
$string['fullpage_dlg:value'] = 'Value';
$string['fullpage_dlg:visited_color'] = 'Visited color';
$string['fullpage_dlg:xml_pi'] = 'XML declaration';
$string['fullscreen:desc'] = 'สลับไปแสดงแบบเต็มหน้า';
$string['iespell:download'] = 'หากระบบตรวจสอบคำผิดไม่พบ คุณต้องการติดตั้งเดี๋ยวนี้ ?';
$string['iespell:iespell_desc'] = 'เรียกใช้ตรวจการสะกด';
$string['insertdatetime:date_fmt'] = '%Y-%m-%d';
$string['insertdatetime:day_long'] = 'วันอาทิตย์,วันจันทร์,วันอังคาร,วันพุธ,วันพฤหัสบดี,วันศุกร์,วันเสาร์,อาทิตย์';
$string['insertdatetime:day_short'] = 'อา,จ,อัง,พ,พฤ,ศ,ส,อ';
$string['insertdatetime:insertdate_desc'] = 'Insert date';
$string['insertdatetime:inserttime_desc'] = 'Insert time';
$string['insertdatetime:months_long'] = 'มกราคม,กุมภาพันธ์,มีนาคม,เมษายน,พฤษภาคม,มิถุนายน,กรกฎาคม,สิงหาคม,กันยายน,ตุลาคม,พฤศจิกายน,ธันวาคม';
$string['insertdatetime:months_short'] = 'ม.ค.,ก.พ.,มี.ค.,เม.ย.,พ.ค.,มิ.ย.,ก.ค.,ส.ค.,ก.ย.,ต.ค.,พ.ย.,ธ.ค.';
$string['insertdatetime:time_fmt'] = '%H:%M:%S';
$string['layer:absolute_desc'] = 'สลับการวาง';
$string['layer:backward_desc'] = 'ย้ายไปข้างหลัง';
$string['layer:content'] = 'เลเยอร์ใหม่...';
$string['layer:forward_desc'] = 'ย้ายไปข้างหน้า';
$string['layer:insertlayer_desc'] = 'เพิ่มเลเยอร์ใหม่';
$string['media:delta_height'] = '';
$string['media:delta_width'] = '';
$string['media:desc'] = 'เพิ่ม / แก้ไข มีเดีย';
$string['media_dlg:advanced'] = 'ขั้นสูง';
$string['media_dlg:align'] = 'Align';
$string['media_dlg:align_bottom'] = 'ล่าง';
$string['media_dlg:align_bottom_left'] = 'ล่าง ซ้าย';
$string['media_dlg:align_bottom_right'] = 'ล่าง ขวา';
$string['media_dlg:align_center'] = 'กลาง';
$string['media_dlg:align_left'] = 'ซ้าย';
$string['media_dlg:align_right'] = 'ขวา';
$string['media_dlg:align_top'] = 'บน';
$string['media_dlg:align_top_left'] = 'บน ซ้าย';
$string['media_dlg:align_top_right'] = 'บน ขวา';
$string['media_dlg:autogotourl'] = 'Auto goto URL';
$string['media_dlg:autohref'] = 'AutoHREF';
$string['media_dlg:autostart'] = 'เล่นอัตโนมัติ';
$string['media_dlg:balance'] = 'Balance';
$string['media_dlg:base'] = 'Base';
$string['media_dlg:baseurl'] = 'Base URL';
$string['media_dlg:bgcolor'] = 'พื้นหลัง';
$string['media_dlg:cache'] = 'Cache';
$string['media_dlg:captioningid'] = 'Captioning id';
$string['media_dlg:center'] = 'Center';
$string['media_dlg:class_name'] = 'คลาส';
$string['media_dlg:console'] = 'Console';
$string['media_dlg:constrain_proportions'] = 'คงอัตราส่วน';
$string['media_dlg:controller'] = 'แผงควบคุม';
$string['media_dlg:controls'] = 'Controls';
$string['media_dlg:correction'] = 'No correction';
$string['media_dlg:currentmarker'] = 'Current marker';
$string['media_dlg:currentposition'] = 'Current position';
$string['media_dlg:defaultframe'] = 'Default frame';
$string['media_dlg:enabled'] = 'Enabled';
$string['media_dlg:enablejavascript'] = 'Enable JavaScript';
$string['media_dlg:endtime'] = 'End time';
$string['media_dlg:file'] = 'ไฟล์/URL';
$string['media_dlg:flash_options'] = 'Flash options';
$string['media_dlg:flashvars'] = 'Flashvars';
$string['media_dlg:fullscreen'] = 'Fullscreen';
$string['media_dlg:general'] = 'ทั่วไป';
$string['media_dlg:hidden'] = 'Hidden';
$string['media_dlg:href'] = 'Href';
$string['media_dlg:hspace'] = 'ระยะห่างแนวนอน';
$string['media_dlg:id'] = 'Id';
$string['media_dlg:imagestatus'] = 'Image status';
$string['media_dlg:invokeurls'] = 'Invoke URLs';
$string['media_dlg:kioskmode'] = 'Kiosk mode';
$string['media_dlg:list'] = 'รายการ';
$string['media_dlg:liveconnect'] = 'SWLiveConnect';
$string['media_dlg:loop'] = 'เล่นซ้ำ';
$string['media_dlg:maintainaspect'] = 'Maintain aspect';
$string['media_dlg:menu'] = 'แสดงเมนู';
$string['media_dlg:mute'] = 'Mute';
$string['media_dlg:name'] = 'ชื่อ';
$string['media_dlg:nojava'] = 'No java';
$string['media_dlg:numloop'] = 'Num loops';
$string['media_dlg:play'] = 'เล่นอัตโนมัติ';
$string['media_dlg:playcount'] = 'Play count';
$string['media_dlg:playeveryframe'] = 'Play every frame';
$string['media_dlg:prefetch'] = 'Prefetch';
$string['media_dlg:preview'] = 'ดูตัวอย่าง';
$string['media_dlg:progress'] = 'Progress';
$string['media_dlg:qt_options'] = 'Quicktime options';
$string['media_dlg:qtsrc'] = 'QT Src';
$string['media_dlg:qtsrcchokespeed'] = 'Choke speed';
$string['media_dlg:qt_stream_warn'] = 'Streamed rtsp resources should be added to the QT Src field under the advanced tab.nYou should also add a non streamed version to the Src field..';
$string['media_dlg:quality'] = 'ความละเอียด';
$string['media_dlg:rate'] = 'Rate';
$string['media_dlg:rmp_options'] = 'Real media player options';
$string['media_dlg:salign'] = 'SAlign';
$string['media_dlg:scale'] = 'ขนาด';
$string['media_dlg:scriptcallbacks'] = 'Script callbacks';
$string['media_dlg:shockwave_options'] = 'Shockwave options';
$string['media_dlg:shuffle'] = 'Shuffle';
$string['media_dlg:size'] = 'ตำแหน่ง';
$string['media_dlg:sound'] = 'Sound';
$string['media_dlg:starttime'] = 'Start time';
$string['media_dlg:stretchtofit'] = 'Stretch to fit';
$string['media_dlg:swstretchhalign'] = 'Stretch H-Align';
$string['media_dlg:swstretchstyle'] = 'Stretch style';
$string['media_dlg:swstretchvalign'] = 'Stretch V-Align';
$string['media_dlg:target'] = 'เป้าหมาย';
$string['media_dlg:targetcache'] = 'เป้าหมาย cache';
$string['media_dlg:title'] = 'เพิ่ม / แก้ไข มีเดีย';
$string['media_dlg:type'] = 'ชนิด';
$string['media_dlg:uimode'] = 'UI Mode';
$string['media_dlg:volume'] = 'Volume';
$string['media_dlg:vspace'] = 'ระยะห่างแนวตั้ง';
$string['media_dlg:windowlessvideo'] = 'Windowless video';
$string['media_dlg:wmode'] = 'WMode';
$string['media_dlg:wmp_options'] = 'Windows media player options';
$string['media:edit'] = 'แก้ไขมีเดีย';
$string['nonbreaking:nonbreaking_desc'] = 'แทรกอักขระว่าง';
$string['pagebreak:desc'] = 'ใส่เส้นแบ่งหน้า';
$string['paste_dlg:text_linebreaks'] = 'Keep linebreaks';
$string['paste_dlg:text_title'] = 'Use CTRL+V on your keyboard to paste the text into the window.';
$string['paste_dlg:word_title'] = 'Use CTRL+V on your keyboard to paste the text into the window.';
$string['paste:paste_text_desc'] = 'วางโดยข้อความธรรมดา';
$string['paste:paste_word_desc'] = 'วางจากโปรแกรม Word';
$string['paste:selectall_desc'] = 'เลือกทั้งหมด';
$string['preview:preview_desc'] = 'ดูตัวอย่าง';
$string['print:print_desc'] = 'พิมพ์';
$string['save:cancel_desc'] = 'ยกเลิกทุกอย่าง';
$string['save:save_desc'] = 'บันทึก';
$string['searchreplace:delta_height'] = '';
$string['searchreplace:delta_width'] = '';
$string['searchreplace_dlg:allreplaced'] = 'ทุกคำที่ใส่ถูกแทนที่แล้ว';
$string['searchreplace_dlg:direction'] = 'ตำแหน่ง';
$string['searchreplace_dlg:down'] = 'ล่าง';
$string['searchreplace_dlg:findnext'] = 'ค้นหาต่อไป';
$string['searchreplace_dlg:findwhat'] = 'ค้นหา';
$string['searchreplace_dlg:mcase'] = 'เหมือนทุกอย่าง';
$string['searchreplace_dlg:notfound'] = 'การค้นหาสิ้นสุด เราไม่พบอะไรเลย';
$string['searchreplace_dlg:replace'] = 'แทนที่';
$string['searchreplace_dlg:replaceall'] = 'แทนที่ทั้งหมด';
$string['searchreplace_dlg:replace_title'] = 'ค้นหา/แทนที่';
$string['searchreplace_dlg:replacewith'] = 'แทนที่ด้วย';
$string['searchreplace_dlg:searchnext_desc'] = 'ค้นหาอีกครั้ง';
$string['searchreplace_dlg:search_title'] = 'ค้นหา';
$string['searchreplace_dlg:up'] = 'บน';
$string['searchreplace:replace_desc'] = 'ค้นหา/แทนที่';
$string['searchreplace:search_desc'] = 'ค้นหา';
$string['simple:bold_desc'] = 'ตัวหนา (Ctrl+B)';
$string['simple:bullist_desc'] = 'ลำดับรายการ';
$string['simple:cleanup_desc'] = 'ล้างรหัสขยะ';
$string['simple:italic_desc'] = 'ตัวเอียง (Ctrl+I)';
$string['simple:numlist_desc'] = 'ลำดับตัวเลข';
$string['simple:redo_desc'] = 'ทำซ้ำ (Ctrl+Y)';
$string['simple:striketrough_desc'] = 'ขีดฆ่า';
$string['simple:underline_desc'] = 'ตัวเขีดเส้นใต้ (Ctrl+U)';
$string['simple:undo_desc'] = 'ยกเลิก (Ctrl+Z)';
$string['spellchecker:desc'] = 'ปิดการสะกดคำ';
$string['spellchecker:ignore_word'] = 'ละเว้นบางคำ';
$string['spellchecker:ignore_words'] = 'ละเว้นทั้งหมด';
$string['spellchecker:langs'] = 'ภาษา';
$string['spellchecker:menu'] = 'ตั้งค่าการสะกดคำ';
$string['spellchecker:no_mpell'] = 'ไม่พบระบบสะกดคำผิด';
$string['spellchecker:no_sug'] = 'ไม่มีคำแนะนำ';
$string['spellchecker:sug'] = 'คำแนะนำ';
$string['spellchecker:wait'] = 'โปรดรอ...';
$string['style:delta_height'] = '';
$string['style:delta_width'] = '';
$string['style:desc'] = 'แก้ไข CSS';
$string['style_dlg:apply'] = 'ใช้งาน';
$string['style_dlg:background_attachment'] = 'Attachment';
$string['style_dlg:background_color'] = 'สีพื้นหลัง';
$string['style_dlg:background_hpos'] = 'Horizontal position';
$string['style_dlg:background_image'] = 'รูปพื้นหลัง';
$string['style_dlg:background_repeat'] = 'Repeat';
$string['style_dlg:background_tab'] = 'พื้นหลัง';
$string['style_dlg:background_vpos'] = 'Vertical position';
$string['style_dlg:block_display'] = 'Display';
$string['style_dlg:block_letterspacing'] = 'Letter spacing';
$string['style_dlg:block_tab'] = 'Block';
$string['style_dlg:block_text_align'] = 'ข้อความ align';
$string['style_dlg:block_text_indent'] = 'ข้อความ indent';
$string['style_dlg:block_vertical_alignment'] = 'Vertical alignment';
$string['style_dlg:block_whitespace'] = 'Whitespace';
$string['style_dlg:block_wordspacing'] = 'Word spacing';
$string['style_dlg:border_tab'] = 'กรอบ';
$string['style_dlg:bottom'] = 'ล่าง';
$string['style_dlg:box_clear'] = 'Clear';
$string['style_dlg:box_float'] = 'Float';
$string['style_dlg:box_height'] = 'Height';
$string['style_dlg:box_tab'] = 'Box';
$string['style_dlg:box_width'] = 'Width';
$string['style_dlg:bullet_image'] = 'Bullet image';
$string['style_dlg:clip'] = 'Clip';
$string['style_dlg:color'] = 'สี';
$string['style_dlg:height'] = 'Height';
$string['style_dlg:left'] = 'ซ้าย';
$string['style_dlg:list_tab'] = 'List';
$string['style_dlg:list_type'] = 'Type';
$string['style_dlg:margin'] = 'Margin';
$string['style_dlg:overflow'] = 'Overflow';
$string['style_dlg:padding'] = 'Padding';
$string['style_dlg:placement'] = 'Placement';
$string['style_dlg:position'] = 'Position';
$string['style_dlg:positioning_tab'] = 'Positioning';
$string['style_dlg:positioning_type'] = 'Type';
$string['style_dlg:right'] = 'ขวา';
$string['style_dlg:same'] = 'Same for all';
$string['style_dlg:style'] = 'รูปแบบ';
$string['style_dlg:text_blink'] = 'blink';
$string['style_dlg:text_case'] = 'Case';
$string['style_dlg:text_color'] = 'สี';
$string['style_dlg:text_decoration'] = 'Decoration';
$string['style_dlg:text_font'] = 'ตัวหนังสือ';
$string['style_dlg:text_lineheight'] = 'ความสูงของบันทัด';
$string['style_dlg:text_none'] = 'none';
$string['style_dlg:text_overline'] = 'overline';
$string['style_dlg:text_props'] = 'ข้อความ';
$string['style_dlg:text_size'] = 'ขนาด';
$string['style_dlg:text_striketrough'] = 'strikethrough';
$string['style_dlg:text_style'] = 'รูปแบบ';
$string['style_dlg:text_tab'] = 'ข้อความ';
$string['style_dlg:text_underline'] = 'underline';
$string['style_dlg:text_variant'] = 'Variant';
$string['style_dlg:text_weight'] = 'น้ำหนัก';
$string['style_dlg:title'] = 'แก้ไข CSS';
$string['style_dlg:top'] = 'บน';
$string['style_dlg:visibility'] = 'Visibility';
$string['style_dlg:width'] = 'Width';
$string['style_dlg:zindex'] = 'Z-index';
$string['table:cell'] = 'Cell';
$string['table:cell_desc'] = 'Table cell properties';
$string['table:cellprops_delta_height'] = '';
$string['table:cellprops_delta_width'] = '';
$string['table:col'] = 'Column';
$string['table:col_after_desc'] = 'Insert column after';
$string['table:col_before_desc'] = 'Insert column before';
$string['table:copy_row_desc'] = 'Copy table row';
$string['table:cut_row_desc'] = 'Cut table row';
$string['table:del'] = 'Delete table';
$string['table:delete_col_desc'] = 'Remove column';
$string['table:delete_row_desc'] = 'Delete row';
$string['table:desc'] = 'Inserts a new table';
$string['table_dlg:advanced_props'] = 'คุณสมบัติขั้นสูง';
$string['table_dlg:advanced_tab'] = 'ขั้นสูง';
$string['table_dlg:align'] = 'ตำแหน่งจัดวาง';
$string['table_dlg:align_bottom'] = 'ล่าง';
$string['table_dlg:align_default'] = 'ค่าเริ่มต้น';
$string['table_dlg:align_left'] = 'ซ้าย';
$string['table_dlg:align_middle'] = 'กลาง';
$string['table_dlg:align_right'] = 'ขวา';
$string['table_dlg:align_top'] = 'บน';
$string['table_dlg:bgcolor'] = 'สีพื้นหลัง';
$string['table_dlg:bgimage'] = 'พื้นหลัง image';
$string['table_dlg:border'] = 'กรอบ';
$string['table_dlg:bordercolor'] = 'สีกรอบ';
$string['table_dlg:caption'] = 'Table caption';
$string['table_dlg:cell_all'] = 'Update all cells in table';
$string['table_dlg:cell_cell'] = 'Update current cell';
$string['table_dlg:cell_limit'] = 'You\'ve exceeded the maximum number of cells of {$cells}.';
$string['table_dlg:cellpadding'] = 'Cellpadding';
$string['table_dlg:cell_row'] = 'Update all cells in row';
$string['table_dlg:cellspacing'] = 'Cellspacing';
$string['table_dlg:cell_title'] = 'คุณสมบัติเซลล์ในาราง';
$string['table_dlg:cell_type'] = 'Cell type';
$string['table_dlg:colgroup'] = 'Col Group';
$string['table_dlg:col_limit'] = 'You\'ve exceeded the maximum number of columns of {$cols}.';
$string['table_dlg:cols'] = 'คอลัมพ์';
$string['table_dlg:frame'] = 'Frame';
$string['table_dlg:frame_all'] = 'all';
$string['table_dlg:frame_cols'] = 'cols';
$string['table_dlg:frame_groups'] = 'groups';
$string['table_dlg:frame_none'] = 'none';
$string['table_dlg:frame_rows'] = 'rows';
$string['table_dlg:general_props'] = 'คุณสมบัติทั่วไป';
$string['table_dlg:general_tab'] = 'ทั่วไป';
$string['table_dlg:height'] = 'สูง';
$string['table_dlg:id'] = 'Id';
$string['table_dlg:langcode'] = 'โค๊ดภาษา';
$string['table_dlg:langdir'] = 'ทิศทางการอ่าน';
$string['table_dlg:ltr'] = 'ซ้ายไปขวา';
$string['table_dlg:merge_cells_title'] = 'Merge table cells';
$string['table_dlg:mime'] = 'เป้าหมาย MIME type';
$string['table_dlg:missing_scope'] = 'Are you sure you want to continue without specifying a scope for this table header cell. Without it, it may be difficult for some users with disabilities to understand the content or data displayed of the table.';
$string['table_dlg:row_all'] = 'Update all rows in table';
$string['table_dlg:row_even'] = 'Update even rows in table';
$string['table_dlg:rowgroup'] = 'Row Group';
$string['table_dlg:row_limit'] = 'You\'ve exceeded the maximum number of rows of {$rows}.';
$string['table_dlg:row_odd'] = 'Update odd rows in table';
$string['table_dlg:row_row'] = 'Update current row';
$string['table_dlg:rows'] = 'แถว';
$string['table_dlg:row_title'] = 'คุณสมบัติแถวในตาราง';
$string['table_dlg:rowtype'] = 'Row in table part';
$string['table_dlg:rtl'] = 'ขวาไปซ้าย';
$string['table_dlg:rules'] = 'Rules';
$string['table_dlg:rules_above'] = 'above';
$string['table_dlg:rules_below'] = 'below';
$string['table_dlg:rules_border'] = 'border';
$string['table_dlg:rules_box'] = 'box';
$string['table_dlg:rules_hsides'] = 'hsides';
$string['table_dlg:rules_lhs'] = 'lhs';
$string['table_dlg:rules_rhs'] = 'rhs';
$string['table_dlg:rules_void'] = 'void';
$string['table_dlg:rules_vsides'] = 'vsides';
$string['table_dlg:scope'] = 'Scope';
$string['table_dlg:style'] = 'รูปแบบ';
$string['table_dlg:summary'] = 'Summary';
$string['table_dlg:tbody'] = 'Table Body';
$string['table_dlg:td'] = 'Data';
$string['table_dlg:tfoot'] = 'Table Foot';
$string['table_dlg:th'] = 'Header';
$string['table_dlg:thead'] = 'Table Head';
$string['table_dlg:title'] = 'เพิ่ม/แก้ไข ตาราง';
$string['table_dlg:valign'] = 'Vertical alignment';
$string['table_dlg:width'] = 'กว้าง';
$string['table:merge_cells_delta_height'] = '';
$string['table:merge_cells_delta_width'] = '';
$string['table:merge_cells_desc'] = 'Merge table cells';
$string['table:paste_row_after_desc'] = 'Paste table row after';
$string['table:paste_row_before_desc'] = 'Paste table row before';
$string['table:props_desc'] = 'Table properties';
$string['table:row'] = 'Row';
$string['table:row_after_desc'] = 'Insert row after';
$string['table:row_before_desc'] = 'Insert row before';
$string['table:row_desc'] = 'Table row properties';
$string['table:rowprops_delta_height'] = '';
$string['table:rowprops_delta_width'] = '';
$string['table:split_cells_desc'] = 'Split merged table cells';
$string['table:table_delta_height'] = '';
$string['table:table_delta_width'] = '';
$string['template:desc'] = 'เพิ่มแม่แบบเอกสาร';
$string['template_dlg:cdate_format'] = '%Y-%m-%d %H:%M:%S';
$string['template_dlg:day_long'] = 'วันอาทิตย์,วันจันทร์,วันอังคาร,วันพุธ,วันพฤหัสบดี,วันศุกร์,วันเสาร์,อาทิตย์';
$string['template_dlg:day_short'] = 'อา,จ,อ,พ,พฤ,ศ,ส,อา';
$string['template_dlg:desc'] = 'เพิ่มแม่แบบเอกสา';
$string['template_dlg:desc_label'] = 'รายละเอียด';
$string['template_dlg:label'] = 'แม่แบบเอกสาร';
$string['template_dlg:mdate_format'] = '%Y-%m-%d %H:%M:%S';
$string['template_dlg:months_long'] = 'มกราคม,กุมภาพันธ์,มีนาคม,เมษายน,พฤษภาคม,มิถุนายน,กรกฎาคม,สิงหาคม,กันยายน,ตุลาคม,พฤศจิกายน,ธันวาคม';
$string['template_dlg:months_short'] = 'ม.ค.,ก.พ.,มี.ค.,เม.ย.,พ.ค.,มิ.ย.,ก.ค.,ส.ค.,ก.ย.,ต.ค.,พ.ย.,ธ.ค.';
$string['template_dlg:preview'] = 'ดูตัวอย่าง';
$string['template_dlg:select'] = 'เลือกแม่แบบเอกสาร';
$string['template_dlg:title'] = 'แม่แบบเอกสาร';
$string['template_dlg:warning'] = 'คำเตือน: การปรับปรุงแม่แบบเอกสารที่แตกต่างกันหนึ่งอาจทำให้ข้อมูลสูญหาย';
$string['visualchars:desc'] = 'การควบคุมตัวอักษร เปิด/ปิด';
$string['xhtmlxtras:abbr_delta_height'] = '';
$string['xhtmlxtras:abbr_delta_width'] = '';
$string['xhtmlxtras:abbr_desc'] = 'ตัวย่อ';
$string['xhtmlxtras:acronym_delta_height'] = '';
$string['xhtmlxtras:acronym_delta_width'] = '';
$string['xhtmlxtras:acronym_desc'] = 'อักษรย่อ';
$string['xhtmlxtras:attribs_delta_height'] = '';
$string['xhtmlxtras:attribs_delta_width'] = '';
$string['xhtmlxtras:attribs_desc'] = 'เพิ่ม/แก้ไข แอททริบิว';
$string['xhtmlxtras:cite_delta_height'] = '';
$string['xhtmlxtras:cite_delta_width'] = '';
$string['xhtmlxtras:cite_desc'] = 'การอ้างอิง';
$string['xhtmlxtras:del_delta_height'] = '';
$string['xhtmlxtras:del_delta_width'] = '';
$string['xhtmlxtras:del_desc'] = 'ลบ';
$string['xhtmlxtras_dlg:attribs_title'] = 'เพิ่ม/แก้ไข Attributes';
$string['xhtmlxtras_dlg:attrib_tab'] = 'Attributes';
$string['xhtmlxtras_dlg:attribute_attrib_tab'] = 'Attributes';
$string['xhtmlxtras_dlg:attribute_events_tab'] = 'กิจกรรม';
$string['xhtmlxtras_dlg:attribute_label_accesskey'] = 'AccessKey';
$string['xhtmlxtras_dlg:attribute_label_cite'] = 'Cite';
$string['xhtmlxtras_dlg:attribute_label_class'] = 'คลาส';
$string['xhtmlxtras_dlg:attribute_label_datetime'] = 'วัน/เวลา';
$string['xhtmlxtras_dlg:attribute_label_id'] = 'ID';
$string['xhtmlxtras_dlg:attribute_label_langcode'] = 'ภาษา';
$string['xhtmlxtras_dlg:attribute_label_langdir'] = 'ทิศทางตัวอักษร';
$string['xhtmlxtras_dlg:attribute_label_style'] = 'รูปแบบ';
$string['xhtmlxtras_dlg:attribute_label_tabindex'] = 'TabIndex';
$string['xhtmlxtras_dlg:attribute_label_title'] = 'ชื่อ';
$string['xhtmlxtras_dlg:attribute_option_ltr'] = 'ซ้ายไปขวา';
$string['xhtmlxtras_dlg:attribute_option_rtl'] = 'ขวาไปซ้าย';
$string['xhtmlxtras_dlg:events_tab'] = 'กิจกรรม';
$string['xhtmlxtras_dlg:fieldset_attrib_tab'] = 'Element Attributes';
$string['xhtmlxtras_dlg:fieldset_events_tab'] = 'Element กิจกรรม';
$string['xhtmlxtras_dlg:fieldset_general_tab'] = 'ตั้งค้าทั่วไป';
$string['xhtmlxtras_dlg:general_tab'] = 'ทั่วไป';
$string['xhtmlxtras_dlg:insert_date'] = 'เพิ่ม วัน/เวลา';
$string['xhtmlxtras_dlg:option_ltr'] = 'ซ้ายไปขวา';
$string['xhtmlxtras_dlg:option_rtl'] = 'ขวาไปซ้าย';
$string['xhtmlxtras_dlg:remove'] = 'ลบ';
$string['xhtmlxtras_dlg:title_abbr_element'] = 'Abbreviation Element';
$string['xhtmlxtras_dlg:title_acronym_element'] = 'Acronym Element';
$string['xhtmlxtras_dlg:title_cite_element'] = 'Citation Element';
$string['xhtmlxtras_dlg:title_del_element'] = 'Deletion Element';
$string['xhtmlxtras_dlg:title_ins_element'] = 'Insertion Element';
$string['xhtmlxtras:ins_delta_height'] = '';
$string['xhtmlxtras:ins_delta_width'] = '';
$string['xhtmlxtras:ins_desc'] = 'เพิ่ม';
