<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'th', branch 'MOODLE_32_STABLE'
 *
 * @package   admin
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'ไม่สามารถเข้าไปในส่วนนี้ได้';
$string['accounts'] = 'บัญชีผู้ใช้';
$string['addcategory'] = 'เพิ่มประเภท';
$string['additionalhtml'] = 'HTML เพิ่มเติม';
$string['additionalhtml_desc'] = 'การตั้งค่านี้ เป็นการเปิดการใช้งานโค้ด HTML ที่ต้องการในทุกหน้า ท่านสามารถตั้งค่า HTMLที่ต้องการเพิ่มใน Head Tag ของหน้านั้น ๆทันที่หลังจากเปิด BODY Tag หรือ ทันทีก่อน ปิด Body Tag  <br/> การกระทำดังกล่าวเป็นการเพิ่ม ส่วนหัวหรือท้ายของแต่ละหน้าตามที่ท่านต้องการ หรือเพื่อสนับสนุนการใช้งาน services บางอย่าง เช่น Google Analytics ซึ่งง่ายมากและไม่ขึ้นอยู่กับรูปแบบเว็บไซต์ที่เลือกใช้งาน';
$string['additionalhtmlfooter'] = 'ก่อนปิด BODY';
$string['additionalhtmlfooter_desc'] = 'เนื้อหาถูกเพิ่มเข้าไปในหน้าก่อนปิด BODY tag';
$string['additionalhtmlhead'] = 'ใน HEAD';
$string['additionalhtmlhead_desc'] = 'เนื้อหานี้จะเพิ่มเข้าไปในด้านล่างของ แท็ก HEAD สำหรับทุกหน้า';
$string['additionalhtml_heading'] = 'HTML เพิ่มเติมที่จะเพิ่มเข้าไปในทุกหน้า';
$string['additionalhtmltopofbody'] = 'เมื่อมีการเปิดแท็ก BODY';
$string['additionalhtmltopofbody_desc'] = 'เนื้อหาจะถูกเพิ่มเข้าไปในทุกหน้าหลังจากเปิดแท็ก BODY';
$string['admincategory'] = 'ประเภท {$a}';
$string['adminseesall'] = 'ผู้ดูแลระบบเห็นข้อมูลได้ทั้งหมด';
$string['adminseesallevents'] = 'ผู้ดูแลระบบเห็นกิจกรรมได้ทั้งหมด';
$string['adminseesownevents'] = 'ผู้ดูแลระบบเข้าถึงข้อมูลได้เท่ากับสมาชิกอื่น';
$string['advancedfeatures'] = 'คุณสมบัติขั้นสูง';
$string['allcountrycodes'] = 'รหัสประเทศทั้งหมด';
$string['allowbeforeblock'] = 'จัดการรายการที่ได้รับการอนุญาตก่อน';
$string['allowbeforeblockdesc'] = 'ระบบจะจัดการรายการที่ถูกบล็อคก่อน  หากเปิดใช้งานตัวเลือกนี้  ระบบจะจัดการกับหมายเลขไอพีในช่องนี้ก่อน จากนั้นจึงตามด้วยรายการที่ถูกบล็อค';
$string['allowblockstodock'] = 'เปิดการใช้งานบล็อคให้ใช้งานที่วาง';
$string['allowcategorythemes'] = 'เลือกรูปแบบเว็บสำหรับแต่ละประเภทได้';
$string['allowcoursethemes'] = 'เลือกรูปแบบเว็บสำหรับแต่ละหลักสูตรได้';
$string['allowediplist'] = 'หมายเลขไอพีที่น่าเชื่อถือ';
$string['allowemailaddresses'] = 'อนุญาตให้ใช้งานอีเมลจากโดเมนต่อไปนี้';
$string['allowframembedding'] = 'เปิดการใช้งาน embed frame';
$string['allowframembedding_help'] = 'เปิดการใช้งาน EMBED  สำหรับเว็บไซต์นี้ในเฟรมของเว็บไซต์ภายนอก  ไม่แนะนำให้ใช้งานเพราะไม่ปลอดภัย';
$string['allowguestmymoodle'] = 'เปิดให้บุคคลทั่วไปเข้าถึง Dashboard';
$string['allowobjectembed'] = 'เปิดใช้งานแท็ก EMBED และOBJECT';
$string['allowthemechangeonurl'] = 'แสดง URL สำหรับเปลี่ยนรูปแบบเว็บ';
$string['allowuserblockhiding'] = 'สมาชิกสามารถซ่อนบล็อคที่ไม่ต้องการได้';
$string['allowusermailcharset'] = 'สมาชิกสามารถเลือกชุดอักขระที่ใช้งาน';
$string['allowuserswitchrolestheycantassign'] = 'อนุญาตให้สมาชิกที่ยังไม่ได้รับการตั้งบทบาทให้สามารถเปลี่ยนแปลงบทบาทได้';
$string['allowuserthemes'] = 'สมาชิกสามารถเปลี่ยนรูปแบบเว็บ';
$string['alternativefullnameformat'] = 'รูปแบบการเขียนชื่อเต็ม';
$string['alternativefullnameformat_desc'] = 'กำหนดการแสดงรายชื่อต่อสมาชิกที่ได้รับสิทธิ์ แสดงรายชื่อเต็ม ( ค่าที่ตั้งไว้ สมาชิกที่เป็น ผู้จัดการ ผู้สอน และ ผู้สอนที่ไม่มีสิทธิ์แก้ไข )  เป็นที่ที่สามารถใช้สำหรับตั้งค่า "รูปแบบชื่อเต็ม"';
$string['appearance'] = 'การแสดงผลของเว็บ';
$string['aspellpath'] = 'Path ของ aspell';
$string['authentication'] = 'การอนุมัติ';
$string['authpreventaccountcreation'] = 'ป้องกันการสร้างบัญชีผู้ใช้เมื่อมีการอนุมัติ';
$string['authpreventaccountcreation_help'] = 'เมื่อสมาชิกได้รับการอนุมัติ บัญชีผู้ใช้ในเว็บไซต์นี้จะได้รับการสร้างโดยอัตโนมัติในกรณีที่ยังไม่มีบัญชีนั้นอยู่ ถ้าหากใช้ฐานข้อมูลภายนอก เช่น LDAP  ในการอนุมัติ หากต้องการให้เฉพาะสมาชิกที่มีบัญชีอยู่ในเว็บเท่านั้น ควรเปิดการใช้งานฟังก์ชั่นนี้   ทำให้บัญชีผู้ใช้ใหม่ต้องมีการสร้างเองหรือโดยการอัพโหลดสมาชิก  หมายเหตุ:  การตั้งค่านี้ไม่รวมถึงการอนุมัติผ่าน MNet';
$string['authsettings'] = 'จัดการวิธีการอนุมัติ';
$string['autolang'] = 'เลือกภาษาอัตโนมัติ';
$string['autologinguests'] = 'เข้าสู่ระบบในฐานะบุคคลทั่วไป';
$string['availablelicenses'] = 'อนุสัญญานุญาตที่มีอยู่';
$string['availableto'] = 'เปิดให้กับ';
$string['backgroundcolour'] = 'สีของพื้นหลัง';
$string['backups'] = 'สำรองข้อมูล';
$string['backup_shortname'] = 'ใช้ชื่อรายวิชาในชื่อไฟล์สำรอง';
$string['backup_shortnamehelp'] = 'ใช้ชื่อรายวิชาเป็นส่วนหนึ่งในชื่อไฟล์สำรอง';
$string['badwordsconfig'] = 'ใส่คำไม่สุภาพเอาไว้ที่นี่ แยกแต่ละคำด้วยเครื่องหมายจุลภาค (คอมม่า ,)';
$string['badwordsdefault'] = 'หากปล่อยค่าว่างไว้ระบบจะใช้ค่าที่ระบบตั้งไว้ในไฟล์ภาษาแทนที่';
$string['badwordslist'] = 'รายการของคำไม่สุภาพ';
$string['blockediplist'] = 'รายการไอพีที่ถูกบล็อค';
$string['blockinstances'] = 'อัน';
$string['blockmultiple'] = 'หลายส่วน';
$string['blockprotect'] = 'ป้องกัน Instances';
$string['blockprotect_help'] = 'ถ้าหากท่านล็อคบล็อคบางประเภทเอาไว้ จะไม่มีใครสามารถเพิ่มหรือลบ Instances ได้ ( นอกจากท่านจะทำการปลอดล็อคในกรณีที่ต้องการแก้ไข instances นั้น)  จุดประสงค์เพื่อทำการป้องกันบล็อคเช่น  navigation และ การแก้ไข ซึ่งเมื่อลบไปแล้วจะนำมากลับมายากมาก';
$string['blocksettings'] = 'จัดการบล็อค';
$string['blockunprotect'] = 'ไม่ป้องกัน';
$string['bloglevel'] = 'การแสดงบล็อก';
$string['bookmarkadded'] = 'เพิ่มในรายการโปรดเรียบร้อยแล้ว';
$string['bookmarkalreadyexists'] = 'หน้านี้อยู่ในรายการโปรดของคุณแล้ว';
$string['bookmarkdeleted'] = 'ลบรายการโปรดแล้ว';
$string['bookmarkthispage'] = 'เพิ่มหน้านี้ในรายการโปรด';
$string['cacheapplication'] = 'ความจำสำรองสำหรับแอพลิเคชั่น';
$string['cacheapplicationhelp'] = 'ความจำสำรองจะมีการแชร์ในกลุ่มสมาชิกและหมดอายุตามเวลาที่ตั้งไว้';
$string['cachejs'] = 'ความจำสำรองของจาวาสคริปต์';
$string['cachejs_help'] = 'การสร้างความจำสำรองสำหรับจาวาสคริปต์ช่วยให้เว็บโหลดได้เร็วขึ้น แนะนำให้เว็บที่ใช้งานอยู่เปิดการใช้งาน แต่สำหรับเว็บที่กำลังพัฒนาอาจต้องการปิดการใช้งานฟังก์ชันนี้ไว้';
$string['cacherequest'] = 'การเรียกใช้ความจำสำรอง';
$string['cacherequesthelp'] = 'ความจำเฉพาะสำหรับสมาชิกหมดอายุเมื่อการเรียกใช้เสร็จสิ้นแล้ว ออกแบบเพื่อเข้าไปแทนพื้นที่ที่เก็บเนื้อหาแบบตายตัว';
$string['cachesession'] = 'ความจำสำรองเซสชั่น';
$string['cachesessionhelp'] = 'ความจำเฉพาะสำหรับสมาชิกหมดอายุเมื่อผู้ใช้เสร็จการทำงาน ออกแบบเพื่อลดการใช้เซสชั่นเป็นเวลานาน';
$string['cachesettings'] = 'การตั้งค่าความจำสำรอง';
$string['caching'] = 'เก็บไว้ในความจำสำรอง';
$string['calendarexportsalt'] = 'ส่งออกปฏิทิน';
$string['calendarsettings'] = 'ปฏิทิน';
$string['calendartype'] = 'ประเภทปฏิทิน';
$string['calendartype_desc'] = 'เลือกประเภทปฏิทินที่ตั้งไว้สำหรับเว็บไซตื  ค่านี้เป็นการเขียนทับค่าที่ตั้งไว้สำหรับรายวิชาหรือค่าที่สมาชิกตั้งไว้';
$string['calendar_weekend'] = 'วันหยุดสุดสัปดาห์';
$string['cannotdeletemodfilter'] = 'ไม่สามารถยกเลิกการติดตั้งฟิลเตอร์  \'{$a->filter}\' เพราะเป็นส่วนหนึ่งของโมดูล\'{$a->module}\'';
$string['cannotuninstall'] = 'ไม่สามารถยกเลิกการติดตั้ง {$a}';
$string['cfgwwwrootslashwarning'] = 'การตั้งค่า $CFG->wwwroot  ในไฟล์ config.php ไม่ถูกต้อง มีการเพิ่มอักขระ \'/\' ในตอนท้ายให้ทำการลบทิ้งก่อนค่ะ เพราะจะทำให้เกิดปัญหาเช่น <a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a>';
$string['cfgwwwrootwarning'] = 'การตั้งค่า $CFG->wwwroot  ในไฟล์ config.php ไม่ถูกต้อง ค่า URL ที่ใช้งานไม่ตรงกับที่เข้ามายังหน้านี้ให้ทำการแก้ไข เพราะจะทำให้เกิดปัญหาเช่น <a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a>';
$string['change'] = 'เปลี่ยนแปลง';
$string['checkboxno'] = 'ไม่';
$string['checkboxyes'] = 'ใช่';
$string['choosefiletoedit'] = 'เลือกไฟล์ที่ต้องการแก้ไข';
$string['cleanup'] = 'โหมดเก็บกวาด';
$string['clianswerno'] = 'n';
$string['cliansweryes'] = 'y';
$string['cliincorrectvalueerror'] = 'ผิดพลาด, ค่าต่อไปนี้ไม่ถูกต้อง "{$a->value}" สำหรับ "{$a->option}"';
$string['cliincorrectvalueretry'] = 'ค่าไม่ถูกต้องกรุณาลองใหม่อีกครั้ง';
$string['clistatusdisabled'] = 'สถานะ : ปิดการใช้งาน';
$string['clistatusenabled'] = 'สถานะ : เปิดการใช้งาน';
$string['clistatusenabledlater'] = 'สถานะ :  โหมดบำรุงรักษา CLI จะเปิดการใช้งานที่ {$a}';
$string['clitypevalue'] = 'ประเภทของค่า';
$string['clitypevaluedefault'] = 'ประเภทของค่า กด Enter หากต้องการใช้ค่าที่ตั้งไว้ ({$a})';
$string['cliunknowoption'] = 'ตัวเลือกที่ไม่สามารถระบุได้ : {$a}';
$string['cliupgradefinished'] = 'เสร็จสิ้นการอัพเกรด command line โดยสมบูรณ์';
$string['cliupgradenoneed'] = 'ไม่จำเป็นต้องอัพเกรดสำหรับเวอร์ชัน {$a} ขอบคุณที่เข้ามาอีกครั้ง';
$string['cliyesnoprompt'] = 'พิมพ์ y (สำหรับ ใช่) หรือ n (สำหรับ ไม่)';
$string['commentsperpage'] = 'จำนวนความเห็นต่อหน้า';
$string['commonactivitysettings'] = 'การตั้งค่าทั่วไป';
$string['commonfiltersettings'] = 'ค่าทั่วไปสำหรับฟิลเตอร์';
$string['commonsettings'] = 'การตั้งค่าทั่วไป';
$string['componentinstalled'] = 'คอมโพเนนท์ที่ติดตั้งแล้ว';
$string['computedfromlogs'] = 'คำนวณจากบันทึกการใช้งานตั้งแต่ {$a}';
$string['condifmodeditdefaults'] = 'เมื่อมีการเพิ่มกิจกรรมใหม่ระบบจะนำค่าเบื้องต้นที่ตั้งไว้ในหน้านี้ไปใช้งาน ท่านสามารถทำการตั้งค่ากิจกรรมที่สมควรตั้งค่าการใช้งานในระดับสูง';
$string['confeditorhidebuttons'] = 'เลือกปุ่มที่ไม่ต้องการแสดงใน HTML editor';
$string['configallcountrycodes'] = 'รายชื่อประเทศที่สามารถเลือกได้ เช่น ในประวัติส่วนตัว ถ้าหากปล่อยว่างไว้ ระบบจะเลือกใช้ ภาษาอังกฤษ ISO 3166-1 หากไม่ท่านสามารถระบุโค้ดที่ต้องการ โดยแบ่งด้วยเครื่องหมายจุลภาค (,)  เช่น \' GB,FR,ES\'  ถ้าท่านเพิ่มโค้ดใหม่ที่ไม่ได้ระบุเอาไว้ ท่านต้องเพิ่มชื่อดังกล่าวในไฟล์ contries.php ในไฟล์  en ของท่านด้วย';
$string['configallowassign'] = 'กำหนดให้บทบาทในคอลัมน์ซ้ายมือสุดสามารถให้สิทธิใดแก่บุคคลอื่นบ้าง';
$string['configallowblockstodock'] = 'หากเปิดการใช้งานและสนับสนุนโดยรูปแบบเว็บไซต์ ผู้ใช้สามารถเลือกที่จะย้ายบล็อคไปยังที่วางพิเศษได้';
$string['configallowcategorythemes'] = 'หากเปิดการใช้งาน ระบบจะสามารถตั้งค่ารูปแบบเว็บสำหรับแต่ละประเภท ซึ่งจะมีผลทำให้ทุกหลักสูตรในประเภทนั้น ๆ รวมทั้งประเภทย่อย เปลี่ยนรูปแบบเว็บไปทั้งหมด เว้นแต่ว่าหลักสูตรดังกล่าวจะกำหนดรูปแบบเว็บของตนเอาไว้

คำเตือน : การเปิดการใช้งานรูปแบบเว็บในระดับประเภทอาจมีผลต่อการทำงานของเว็บไซต์';
$string['configallowcoursethemes'] = 'หากเปิดการใช้งานส่วนนี้  แต่ละหลักสูตรสามารถสามารถมีรูปแบบเว็บเป็นของตนเอง  ค่าของรูปแบบของหลักสูตรจะเขียนทับค่าตัวเลือกของรูปแบบทั้งเว็บไซต์ รูปแบบที่สมาชิกเลือก หรือแม้กระทั่งรูปแบบของเซสชัน';
$string['configallowemailaddresses'] = 'หากต้องการบล็อคอีเมลจากบางโดเมนให้ใส่รายชื่อไว้ที่นี่โดยเขียนแต่ละตัวแยกกันด้วยช่องว่าง เช่น <strong>ourcollege.edu.au .gov.au</strong>';
$string['configallowguestmymoodle'] = 'หากเปิดใช้งาน บุคคลทั่วไปจะสามารถเข้าใช้งานแผงควบคุมได้  หากปิดไว้ บุคคลทั่วไปจะถูกพาไปยังหน้าแรกของเว็บ';
$string['configallowobjectembed'] = 'ระบบตั้งค่าไว้ว่า สมาชิกทั่วไปจะไม่สามารถแทรกไฟล์มัลติมิเดีย เช่น แฟลช ภายในบทความโดยใช้ EMBED และ OBJECT ได้ ( แต่ก็สามารถทำได้อย่างปลอดภัยโดยเปิดใช้งานมีเดียปลั้กอินฟิลเตอร์)  หากต้องการให้สมาชิกทั่วไปสามารถแทรกแท็กเหล่านี้ได้ให้เปิดการใช้งานส่วนนี้';
$string['configallowoverride'] = 'อนุญาตให้บทบาทในคอลัมน์ซ้ายสุดสามารถกำหนดบทบาทของตนเองด้วยบทบาทใดได้บ้าง';
$string['configallowoverride2'] = 'เลือกว่าบทบาทใดต่อไปนี้ที่สามารถแทนที่ได้ด้วยบทบาทที่อยู่ในคอลัมน์ซ้ายสุด
<br /> หมายเหตุ : การตั้งค่านี้จะมีผลเฉพาะกับสมาชิกที่ได้รับอนุมัติสิทธิ  moodle/role:override หรือ moodle/role:safeoverride';
$string['configallowswitch'] = 'เลือกว่าผู้ใช้จะเปลี่ยนบทบาทของตนเป็นอะไรได้บ้างจากบทบาทที่มีอยู่  ต้องมีการตั้งค่า moodle/role:switchroles capability  เป็น สามารถเปลี่ยนบทบาทได้  <br /> ข้อควรรู้ บทบาทที่จะเปลี่ยนไปใช้งานได้นั้นจะต้องเปิดการใช้งาน moodle/course:view capability  และปิดการใช้งาน moodle/site:doanything capability ทำให้บางคอลัมน์ในตารางนี้ถูกปิดการใช้งาน';
$string['configallowthemechangeonurl'] = 'ถ้าเปิดการใช้งานค่านี้ ผู้ใช้จะสามารถเปลี่ยนรูปแบบเว็บได้ โดยการเพิ่ม  theme={themename}&amp;sesskey={sesskey}  สำหรับ URL ทุกอัน';
$string['configallowuserblockhiding'] = 'ต้องการให้นักเรียนมีสิทธิ์ ซ่อน/แสดง บล็อคภายในเว็บไซต์นี้หรือไม่ ฟังก์ชันนี้นำเอาจาวาสคริปต์และคุ้กกี้มาใช้เพื่อให้จำสถานะของแต่ละบล็อค และจะมีผลเฉพาะสมาชิกนั้น ๆ เท่านั้น';
$string['configallowusermailcharset'] = 'เปิดการใช้งานส่วนนี้ จะทำให้สมาชิกสามารถเลือกชุดอักขระสำหรับอีเมลการรับส่งอีเมลได้';
$string['configallowuserswitchrolestheycantassign'] = 'หากต้องการให้สมาชิกสามารถเปลี่ยนบทบาทได้ต้องมีการตั้งค่าเปิดการใช้งานใน moodle/role:assign จะปรากฎดรอปดาวน์เมนูที่มีรายการของบทบาทที่สมาชิกสามารถจะเปลี่ยนไปใช้งานได้ปรากฎอยู่ แนะนำให้ใช้ค่าที่ระบบตั้งไว้สำหรับหัวข้อ "Allow role assignments" โดยไม่เปลี่ยนแปลงหรือเพิ่มสิทธิอื่นใดให้กับบทบาทนั้น ๆ อีก';
$string['configallowuserthemes'] = 'หากเปิดใช้งานในส่วนนี้  สมาชิกจะสามารถเลือกรูปแบบเว็บไซต์ที่ตนเองชอบได้ โดยรูปแบบดังกล่าวจะทับค่ารูปแบบเว็บไซต์หลักอัตโนมัติแต่ไม่สามารถเปลี่ยนในหน้ารูปแบบรายวิชาได้';
$string['configallusersaresitestudents'] = 'จะถือว่าสมาชิกทุกคนเป็นนักเรียนในหน้าแรกของเว็บไซต์หรือไม่ หากเลือก "ใช่" สมาชิกที่ทำการยืนยันบัญชีผู้ใช้ของตนเองแล้วสามารถทำกิจกรรมต่างๆ ในหน้าเว็บไซต์นี้ได้ หากเลือก "ไม่" เฉพาะสมาชิกที่เป็นนักเรียนของหลักสูตรใดหลักสูตรหนึ่งเท่านั้นที่จะสามารถทำกิจกรรมในหน้าแรกได้ เฉพาะผู้ดูแลระบบและผู้สร้างหลักสูครเท่านั้นที่จะทำหน้าที่เป็นอาจารย์สำหรับหน้าแรกของเว็บ จะถือว่าสมาชิกทุกคนเป็นนักเรียนในหน้าแรกของเว็บไซต์หรือไม่ หากเลือก "ใช่" สมาชิกที่ทำการยืนยันบัญชีผู้ใช้ของตนเองแล้วสามารถทำกิจกรรมต่าง ๆ ในหน้าเว็บไซต์นี้ได้ หากเลือก "ไม่" เฉพาะสมาชิกที่เป็นนักเรียนของหลักสูตรใดหลักสูตรหนึ่งเท่านั้นที่จะสามารถทำกิจกรรมในหน้าแรกได้ เฉพาะผู้ดูแลระบบและผู้สร้างหลักสูตรเท่านั้นที่จะทำหน้าที่เป็นอาจารย์สำหรับหน้าแรกของเว็บ';
$string['configauthenticationplugins'] = 'เลือกปลั๊กอินการอนุมัติที่ต้องการใช้งานโดยเรียงลำดับตามลำดับก่อนหลัง  ระบบจะเลือกปลั๊กอินดังกล่าวเพื่อใช้ในการลงทะเบียนด้วยตนเอง';
$string['configautolang'] = 'ค้นหาภาษาที่ต้องการใช้จากการตั้งค่าของเว็บบราวเซอร์ หากปิดใช้งานจะใช้ค่าที่ตั้งไว้ในระบบ';
$string['configautologinguests'] = 'ต้องการให้ผู้ที่เข้ามาเยี่ยมเว็บไซต์เข้าสู่ระบบอัตโนมัติในฐานะบุคคลทั่วไปหรือไม่เมื่อเข้ามายังรายวิชา';
$string['configbloglevel'] = 'ค่านี้เป็นช่วยให้ท่านสามารถกำหนดระดับการแสดงบล็อกของสมาชิกว่าต้องการให้แสดงหรือไม่ เป็นตัวกำหนดเนื้อหาสูงสุดของผู้อ่านไม่ใช่ของผู้เขียน หรือ ประเภทของข้อความในบล็อก ท่านสามารถปิดการใช้งานบล็อกในกรณีที่ไม่ต้องการใช้งาน';
$string['configcalendarcustomexport'] = 'เปิดการใช้งาน การส่งออกปฏิทินตามวันที่ที่ต้องการ';
$string['configcalendarexportsalt'] = 'ระบบจะแสดงข้อความแบบสุ่มให้เติมเพื่อความปลอดภัยในการส่งออกปฏิทิน หากมีการเปลี่ยนค่านี้ระบบบัตรผ่านจะไม่สามารถใช้งานได้';
$string['configcookiehttponly'] = 'เปิดการใช้งานคุณสมบัติใหม่ของ PHP 5.2.0 บราวเซอร์จะมีการส่งคุ้กกี้ด้วย http requests ที่แท้จริงเท่านั้น จะไม่สามารถเข้าถึงได้ด้วยสคริปต์ใด ๆ ฟังก์ชันนี้ยังไม่มีการสนับสนุนให้ใช้งานบนเว็บบราวเซอร์ทุกชนิดและอาจจะไม่เข้ากับโค้ดปัจจุบัน เป็นการช่วยในการป้องกันการโจมตีของ XSS บางประเภท';
$string['configcookiesecure'] = 'ในกรณีที่เซิร์ฟเวอร์รับเฉพาะการติดต่อแบบ https แนะนำว่าให้เปิดการใช้งานการส่ง secure cookies  ข้อแนะนำเมื่อมีการเปิดใช้งานคือตรวจสอบให้แน่ใจว่าเว็บเซอร์เวอร์ไม่รับค่า http:// หรือมีการตั้งค่าให้ส่งต่อไปยังหน้า https:// อย่างถาวร เมื่อที่อยู่ <em>wwwroot</em> ไม่เริ่มต้นด้วย https:// ค่านี้จะถูกปิดโดยอัตโนมัติ';
$string['configcountry'] = 'ถ้าหากมีการระบุประเทศในส่วนนี้ ระบบจะใช้ประเทศนี้เป็นค่าเริ่มต้นสำหรับสมาชิกทุกคน หากต้องการบังคับให้สมาชิกเลือกประเทศของตนเองได้ ให้ปล่อยช่องนี้ว่างไว้';
$string['configcourseoverviewfilesext'] = 'รายการบทคัดย่อของรายวิชาแยกด้วยเครื่องหมายจุลภาค';
$string['configcourseoverviewfileslimit'] = 'จำนวนไฟล์สูงสุดที่สามารถแนบไปกับบทคัดย่อรายวิชา';
$string['configcourserequestnotify'] = 'พิมพ์ชื่อผู้ใช้ที่ต้องการแจ้งให้ทราบเมื่อมีการเพิ่มรายวิชาใหม่';
$string['configcourserequestnotify2'] = 'สมาชิกที่จะได้รับแจ้งเมื่อมีการขอเปิดรายวิชาใหม่ ระบบแสดงเฉพาะรายชื่อสมาชิกที่มีสิทธิในการอนุมัติการขอเปิดรายวิชาเท่านั้น';
$string['configcoursesperpage'] = 'จำนวนรายวิชาที่ต้องการแสดง/หน้า';
$string['configcourseswithsummarieslimit'] = 'จำนวนสูงสุดของรายวิชาที่ต้องการแสดงในหน้ารวมรายวิชารวมถึงบทคัดย่อก่อนที่จะแสดงผลในรูปแบบรายการแบบธรรมดา';
$string['configcronclionly'] = 'หากตั้งค่านี้ ครอนสคริปต์จะทำงานผ่าน commandline เท่านั้น ไม่สามารถสั่งผ่านเว็บได้ ระบบจะใช้ค่านี้แทนการตั้งค่ารหัสผ่านด้านล่าง';
$string['configcronremotepassword'] = 'ในการเรียกให้ครอนสคริปต์ทำงานผ่านเว็บบราวเซอร์จำเป็นต้องใส่รหัสผ่านลงไปในรูปแบบของ URL:<pre>
http://site.example.com/admin/cron.php?password=opensesame
</pre>  ในกรณีที่ไม่ใส่รหัสผ่านลงไป ระบบจะไม่ถามหารหัสผ่าน';
$string['configcurlcache'] = 'เวลาสำหรับ cURL ในความจำสำรองเป็นวินาที';
$string['configcustommenuitems'] = 'ท่านสามารถตั้งค่าเมนูที่ต้องการได้ที่นี่ แต่ละบรรทัดประกอบไปด้วยข้อความสำหรับแต่ละตัวเลือก และ ลิงก์ (ใส่หรือไม่ก็ได้) ,หัวข้อ และโค้ดภาษาหรือใช้ จุลภาค (,) แยกโค้ดแต่ละหัวข้อ (ใส่หรือไม่ก็ได้ เพื่อแสดงบรรทัดนั้นสำหรับสมาชิกที่ใช้ภาษาบางภาษา เท่านั้น), แยกแต่ละเมนูโดยอักขระ ท่านสามารถกำหนดรูปแบบโดยใช้เครื่องหมายขีดกลาง (-)  และเครื่องหมายแบ่ง (|) โดยเพิ่มเมนูแต่ละบรรทัดหรือมากกว่านั้น หรือ ใช้ # สำหรับตัวอักษรเพิ่มเติม ตัวอย่างเช่น:
<pre>
 Moodle|https://moodle.org
-Moodle free support|https://moodle.org/support
-###
-Moodle development|https://moodle.org/development
--Moodle Docs|http://docs.moodle.org|Moodle Docs
--German Moodle Docs|http://docs.moodle.org/de|Documentation in German|de
#####
Moodle.com|http://moodle.com/
</pre>';
$string['configcustomusermenuitems'] = 'ท่านสามารถตั้งค่าเนื้อหาของแต่ละเมนูผู้ใช้ ( ยกเว้นลิงก์ออกจากระบบ ซึ่งจะเพิ่มโดยอัตโนมัติอยู่แล้ว ) แต่ละบรรทัดแบ่งด้วยเครื่องหมาย | และประกอบไปด้วย
1) ตัวหนังสือในรูปแบบของ  "langstringname, componentname"  หรือ ตัวหนังสือธรรมดา
2) URL
3) ไอคอนไม่ว่าจะเป็น pix icon หรือ URL
ใช้ตัวแบ่ง | เพื่อเพิ่มบรรทัดหนึ่งบรรทัด หรือ  #  สำหรับตัวอักษรเพิ่มเติม';
$string['configdbsessions'] = 'หากเปิดใช้งานค่านี้ ระบบจะใช้ฐานข้อมูลในการจัดเก็บข้อมูลเกี่ยวกับการใช้งานเซสชันปัจจุบันมีประโยชน์สำหรับเว็บไซต์ที่มีขนาดใหญ่หรือมีการใช้งานมาก หรือเว็บที่อยู่บนโฮสต์ที่มีจำนวนเว็บมากๆ สำหรับเว็บไซต์ทั่วไปค่านี้ควรปิดการใช้งานเอาไว้และใช้พื้นที่บนฮาร์ดไดร์ฟแทน การเปลี่ยนแปลงค่านี้ระบบจะทำการนำสมาชิกที่กำลังอยู่ในระบบออกจากระบบรวมทั้งคุณด้วยในทันที';
$string['configdebug'] = 'หากเปิดการใช้งานส่วนนี้  จะทำให้มีการส่งรายงานข้อผิดพลาด error_report  แสดงผลบนหน้าจอมากขึ้นเหมาะสำหรับผู้พัฒนาโค้ดเท่านั้น';
$string['configdebugdisplay'] = 'เปิดการใช้งานในส่วนนี้  เมื่อมีข้อผิดพลาดเกิดขึ้นระบบจะนำท่านไปยังหน้า html ที่ระบุเอาไว้ เหมาะที่จะนำไปใช้งานแต่จะเป็นการแยก xhtml,js, cookies, http header </br>

ปิดการใช้งานส่วนนี้  ระบบจะส่งผลลัพธ์ที่ได้ไปเก็บไว้ในบันทึกการใช้งานของเซิร์ฟเวอร์ เพื่อให้การ debug ทำงานอย่างมีประสิทธิภาพมากขึ้น และสามารถระบุได้ว่าจะเก็บไว้ในบันทึการใช้งานใด ให้ตั้งค่าจาก PHP  error_log';
$string['configdebugpageinfo'] = 'เปิดการใช้งานหากต้องการให้มีการแสดงข้อมูลของด้านนี้ที่ด้านล่างของหน้า';
$string['configdebugsmtp'] = 'เปิดการใช้งการแสดงผลรรายละเอียดของการ debug และให้ทำการส่งอีเมลไปยังเซิร์ฟเวอร์ smtp';
$string['configdebugvalidators'] = 'หากต้องการแสดงลิงก์ไปยัง validator เซิร์ฟเวอร์ภายนอก ในส่วนท้ายของหน้า จำเป็นต้องสร้างสมาชิกใหม่พร้อมชื่อผู้ใช้ <em>w3cvalidator</em> จากนั้นให้เปิดการใช้งานแก่บุคคลภายนอก ซึ่งการเปิดการใช้งานดังกล่าวไม่ควรจะทำในกรณีที่เป็นเว็บไซต์ที่ใช้งานอยู่จริง เพราะจะเป็นการเปิดช่องว่างให้กับบุคคลที่ไม่พึงประสงค์เข้ามายังเซิร์ฟเวอร์';
$string['configdefaulthomepage'] = 'หน้าแรกสำหรับสมาชิกที่เข้าสู่ระบบ';
$string['configdefaultrequestcategory'] = 'รายวิชาที่มีผู้ขอสร้างระบบจะนำมาไว้ในประเภทนี้อัตโนมัติ';
$string['configdefaultrequestedcategory'] = 'ชื่อประเภทที่ต้องการเก็บ รายวิชาที่มีการขอสร้างขึ้นเมื่อได้รับการอนุมัติแล้ว';
$string['configdefaultuserroleid'] = 'สมาชิกทุกคนจะได้รับบทบาทที่ท่านระบุไว้นี้ในระดับเว็บไซต์ (หน้าแรก) นอกเหนือไปจากบทบาทอื่นที่ได้รับการแต่งตั้ง ค่าที่ระบบตั้งไว้คือบทบาทสมาชิกที่ผ่านการอนุมัติแล้ว ( หรือ บุคคลทั่วไปในเวอร์ชันเดิม)  บทบาทนี้จะไม่ขัดแย้งกับบทบาทอื่นที่ได้รับการแต่งตั้ง แต่เป็นการให้สิทธิที่นอกเหนือไปจากสิทธิที่ได้ในแต่ละคอร์ส   ( เช่น เขียนบล็อก จัดการปฏิทิน)';
$string['configdeleteincompleteusers'] = 'หลังจากเวลาดังกล่าว บัญชีผู้ใช้เก่าและบัญชีที่ไม่สมบูรณ์จะถูกลบทิ้งไป';
$string['configdeleteunconfirmed'] = 'ถ้าหากเลือกใช้การอนุมัติผ่านอีเมล์ จะให้ระยะเวลาในการยืนยันบัญชีจากอีเมลเป็นเวลาเท่าใดถ้าหลังจากเวลานี้แล้วผู้ที่ยังไม่ทำการยืนยันอีเมลจะถูกลบทิ้ง';
$string['configdenyemailaddresses'] = 'หากไม่ต้องการรับอีเมล์จากโดเมนใด ให้ทำการระบุชื่อโดเมนไว้ในส่วนนี้ เช่น <strong>hotmail.com yahoo.co.uk</strong>';
$string['configdisableuserimages'] = 'ปิดการใช้งาน  : สมาชิกไม่สามารถเปลี่ยนรูปภาพประจำตัวได้';
$string['configdisplayloginfailures'] = 'ค่านี้เป็นการเลือกแสดงผลข้อมูลการเข้าสู่ระบบไม่สำเร็จของสมาชิกที่เลือก';
$string['configdndallowtextandlinks'] = 'เปิดการใช้งานหรือปิดการใช้งาน  การลากและวางข้อความ และ ลิงก์ ในหน้ารายวิชา รวมถึงการลากและวางไฟล์  ควรจำไว้ว่าการลากและวางไฟล์ใน Firefox  หรือบราวเซอร์ที่ต่างไปอาจทำไม่ได้ หรือทำให้ข้อมูลอัพโหลดไม่ได้หรือมีข้อผิดพลาดในการอัพโหลด';
$string['configdoclang'] = 'ระบบจะใช้ภาษานี้ในลิงก์สำหรับหน้าคู่มือการใช้งาน';
$string['configdocroot'] = 'ระบุ path ชี้ไปยังเอกสารคู่มือการใช้งานมูเดิ้ล ท่านสามารถเปลี่ยนแปลงและชี้ไปยังเอกสารคู่มือออนไลน์ที่ท่านมีอยู่ ซึ่งเอกสารดังกล่าวควรจะสอดคล้องกับที่ http://docs.moodle.org';
$string['configdoctonewwindow'] = 'ถ้าหากเปิดการใช้งาน เอกสารคู่มือจะแสดงในหน้าต่างใหม่';
$string['configeditordictionary'] = 'ค่านี้จะนำมาใช้หากเซิร์ฟเวอร์ไม่มีพจนานุกลมในภาษาที่สมาชิกใช้งาน';
$string['configeditorfontlist'] = 'เลือกตัวหนังสือที่ต้องการแสดงในดรอปดาวน์เมนู';
$string['configemailchangeconfirmation'] = 'ต้องมีการคอนเฟิร์มอีเมลก่อน เมื่อสมาชิกทำการเปลี่ยนอีเมลในหน้าประวัติส่วนตัว';
$string['configenableblogs'] = 'เปิดการใช้งานนี้จะทำให้สมาชิกทุกคนมีบล็อกส่วนตัว';
$string['configenablecalendarexport'] = 'เปิดการใช้งานการส่งออกหรือการติดตามปฏิทิน';
$string['configenablecomments'] = 'เปิดการให้แสดงความคิดเห็น';
$string['configenablecourserequests'] = 'เลือกค่านี้หากต้องการให้สมาชิกสามารถขอสร้างรายวิชาขึ้น';
$string['configenabledevicedetection'] = 'เปิดการใช้ การค้นหามือถือ สมาร์ทโฟน แท็บเบล็ต หรือ เครื่องมือที่ผู้ใช้กำลังใช้งาน เช่น คอมพิวเตอร์ตั้งโต๊ะ  คอมพิวเตอร์พกพา เป็นต้น สำหรับแต่ละรูปแบบเว็บและฟังก์ชันที่เกี่ยวข้อง';
$string['configenablemobilewebservice'] = 'เปิดการใช้งาน mobile service สำหรับ แอพ Moodle แบบเป็นทางการหรือแอพอื่นที่เรียกใช้งาน  ข้อมูลเพิ่มเติมอ่านได้ที่ {$a}';
$string['configenablerssfeeds'] = 'ฟังก์ชันนี้เป็นการเปิดการใช้งานการเปิดใช้การป้อนข้อมูลข่าวสารและการดึงข้อมูลข่าวสาร (RSS feeds) จากทั้งเว็บไซต์ หากต้องการให้เห็นภาพพจน์มากขึ้นต้องเปิดการใช้งาน RSS feeds สำหรับแต่ละโมดูลด้วย โดยไปที่การตั้งค่าโมดูลภายใต้การจัดการระบบ';
$string['configenablerssfeedsdisabled'] = 'ไม่เปิดการใช้งานในส่วนนี้เพราะมีการปิดการใช้งาน RSS Feeds สำหรับทั้งเว็บไซต์หากต้องการเปิดการใช้งานไปยังการตั้งค่าตัวแปรภายใต้หัวข้อการจัดการระบบ';
$string['configenablerssfeedsdisabled2'] = 'เซิร์ฟเวอร์ปิดการใช้งานการป้อนข่าวสาร RSS จำเป็นต้องเปิดการใช้งานก่อนใน Server/RSS';
$string['configenablesafebrowserintegration'] = 'เพิ่มตัวเลือก \'ต้องใช้บราวเซอร์ที่ปลอดภัยในการสอบ\' ในช่อง  \'ความปลอดภัยของบราวเซอร์\' ที่อยู่ในหน้าการตั้งค่าแบบทดสอบ ดูรายละเอียดที่  http://www.safeexambrowser.org/ for more information.';
$string['configenablestats'] = 'ถ้าหากเลือก " ใช่"   Cron จะทำการการจัดเก็บสถิติจากบันทึกการใช้งานเว็บไว้ ถ้าหากมีการใช้เว็บมากระยะเวลาในการเก็บสถิติก็จะนานขึ้นตามลำดับ หากเปิดการใช้งานคุณจะได้รับข้อมูลที่น่าสนใจเกี่ยวกับแต่ละคอรืสภายในเว็บไซต์';
$string['configenabletrusttext'] = 'ปกติแล้ว Moodle จะทำการกรองข้อความต่าง ๆ ที่สมาชิกใส่เข้ามาในระบบและทำการลบสคริปต์ต่าง ๆ ที่เป็นอันตราย หรือการแสดงผลมีเดีย ต่าง ๆ ซึ่งเสี่ยงต่อความปลอดภัยของเว็บ  ระบบคัดกรองเนื้อหานี้จะให้สิทธิกับสมาชิกบางคนที่น่าเชื่อถือเท่านั้นที่จะสามารถเพิ่มลูกเล่นชั้นสูงให้กับเนื้อหาของตน  หากต้องการเปิดใช้งานให้ทำการเปิดค่านี้ จากนั้นให้สิทธิการโพสต์เนื้อหาที่น่าเชื่อถือแก่สมาชิกในกลุ่มที่ต้องการ  ระบบจะไม่ทำความสะอาดข้อความจากสมาชิกในกลุ่มดังกล่าวจะนำไปแสดงผลทันที';
$string['configenablewebservices'] = 'เว็บเซอร์วิสจะช่วยให้ระบบอื่น ๆ สามารถเข้าถึง moodle และจัดการกิจกรรมต่าง ๆ ได้ เพื่อความปลอดภัยควรปิดการใช้งานฟังก์ชันนี้ไว้นอกจากว่ามีความจำเป็นต้องใช้งานจริง ๆ';
$string['configenablewsdocumentation'] = 'เปิดการใช้งาน เอกสารคู่มืออัตโนมัติ สมาชิกสามารถเข้าถึงคู่มือของตัวเองได้โดยใช้หน้าความปลอดภัยของตน {$a} ระบบจะแสดงคู่มือบนโปรโตคอลที่เปิดใช้งานเท่านั้น';
$string['configerrorlevel'] = 'เลือกจำนวนของคำเตือน PHP ที่คุณต้องการแสดง "ปกติ" เป็นตัวเลือกที่ดีที่สุด';
$string['configexportlookahead'] = 'จำนวนวันล่วงหน้าที่ควรตรวจสอบระหว่างการส่งออก';
$string['configexportlookback'] = 'จำนวนวันที่ผ่านมาที่ควรตรวจสอบระหว่างส่งออก';
$string['configextendedusernamechars'] = 'เปิดการใช้งานส่วนนี้ นักเรียนจะสามารถเลือกใช้ชื่อผู้ใช้ด้วยอักษรต่าง ๆ ไม่จำเป็นว่าต้องเป็นภาษาอังกฤษและตัวเลขเท่านั้น  ค่าที่ตั้งไว้คือ "ไม่"  คือนักเรียนเลือกได้เฉพาะตัวอักษรภาษาอังกฤษและตัวเลขเท่านั้นจะใช้อักขระพิเศษใด ๆไม่ได้';
$string['configextramemorylimit'] = 'สคริปต์บางตัวอาทิ การค้นหา การสำรองข้อมูล และการกู้คืน จำเป็นต้องใช้ความจำขนาดใหญ่ ควรตั้งค่าให้สูงขึ้นสำหรับเว็บไซต์ขนาดใหญ่';
$string['configfilterall'] = 'ฟิลเตอร์ตัวหนังสือทั้งหมดรวมทั้ง ส่วนหัว หัวข้อ แถบนาวิเกชัน และอื่นๆ มีประโยชน์สำหรับการใช้ฟิลเตอร์หลายภาษา หากไม่ได้ใช้งานหลายภาษาก็ไม่ควรเปิดใช้เพราะจะเพิ่มโหลดการทำงานให้กับเว็บไซต์';
$string['configfiltermatchoneperpage'] = 'การสร้างลิงก์อัตโนมัติจะทำการสร้างลิงก์เพียงครั้งเดียว คือในครั้งแรกที่เจอเท่านั้นและจะไม่สนใจคำอื่นที่เหลือ';
$string['configfiltermatchonepertext'] = 'การสร้างลิงก์อัตโนมัติจะทำการสร้างลิงก์ให้กับสิ่งที่ต้องการค้นหาเพียงครั้งแรกครั้งเดียว เช่น ในแหล่งข้อมูล บล็อค ในหน้าดังกล่าว และจะไม่สนใจส่วนที่เหลืออยู่  ระบบจะไม่สนใจค่านี้หากมีการตั้งค่า " หนึ่งลิงก์ต่อหน้า  เป็น  "ใช่" "';
$string['configfilteruploadedfiles'] = 'เปิดการใช้งานในส่วนนี้ส่งผลให้ Moodle ทำการโพรเซสไฟล์ html และไฟล์ text อื่น ๆ ที่ทำการอัพโหลดก่อนที่จะแสดงผล';
$string['configforcelogin'] = 'ปกติแล้วบุคคลทั่วไปสามารถเข้าไปยังหน้าแรกของเว็บไซต์และหน้ารวมรายวิชา โดยไม่จำเป็นต้องล็อกอินเข้าสู่ระบบแต่ถ้าหากต้องการบังคับให้สมาชิกล็อกอินก่อนก็ให้เลือกตัวเลือกนี้';
$string['configforceloginforprofiles'] = 'การเลือกค่านี้เป็นค่าบังคับให้สมาชิก ล็อกอินเข้าสู่ระบบด้วย account จริง ๆ ก่อนที่จะเข้าไปดูหน้าประวัติส่วนตัวของสมาชิกคนอื่นได้ ค่าที่ตั้งไว้เบื้องต้นคือ"ไม่ (false)" เพื่อให้นักเรียนสามารถดูรายละเอียดของผู้สอนได้ ซึ่งก็หมายความว่า เว็บที่ใช้ในการค้นหาก็สามารถแสดงรายละเอียดดังกล่าวนี้ได้เช่นกัน';
$string['configfrontpage'] = 'ระบบจะแสดงรายการที่เลือกในหน้าแรกของเว็บ';
$string['configfrontpagecourselimit'] = 'จำนวนรายวิชาสูงสุด';
$string['configfrontpagecourselimithelp'] = 'จำนวนรายวิชาสูงสุดที่แสดงในหน้าแรกของหน้ารวมรายวิชา';
$string['configfrontpageloggedin'] = 'ระบบจะแสดงรายการที่เลือกในหน้าแรกของเว็บ เมื่อสมาชิกเข้าสู่ระบบ';
$string['configfullnamedisplay'] = 'ตัวเลือกนี้จะเป็นการแสดงชื่อของสมาชิกว่าต้องการให้แสดงผลอย่างไร ค่าที่ตั้งไว้คือ ชื่อจริง และ นามสกุล แต่คุณสามารถเลือกที่จะซ่อนนามสกุล หรือว่าทิ้งไว้ให้ระบบเลือกให้เองอัตโนมัติขึ้นอยู่กับภาษาที่ใช้';
$string['configgeoipfile'] = 'ที่ตั้งของไฟล์ข้อมูลชื่อเมืองใน GeoIP  ไม่ได้เป็นส่วนหนึ่งของ Moodle สามารถดาวน์โหลดได้จาก <a href="http://www.maxmind.com/">MaxMind</a>หรือสามารถหาซื้อได้ หรือ <br />ดาวน์โหลดฟรี <a href="http://www.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz" >http://www.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz</a> จากนั้นให้ทำการแตกไฟล์ออกแล้วแล้วเก็บไว้ในไดเรกทอรี "{$a}" บนเซิร์ฟเวอร์';
$string['configgetremoteaddrconf'] = 'หากเซิร์ฟเวอร์ของคุณใช้งาน reverse proxy สามารถระบะว่าต้องการใช้งาน http headers ที่คุณเชื่อถือ เพื่อเก็บที่อยู่ หมายเลขไอพี  ระบบจะอ่านค่า headers เรียงตามลำดับโดยจะใช้อันแรกที่สามารถใช้งานได้';
$string['configgradebookroles'] = 'การตั้งค่านี้เป็นการควบคุมการแสดงผลของสมุดคะแนน สมาชิกต้องมีอย่างน้อยหนึ่งบทบาทเพื่อที่จะแสดงสมุดตะแนนของรายวิชาดังกล่าว';
$string['configgradeexport'] = 'ตั้งค่าการส่งออกคะแนน';
$string['confighiddenuserfields'] = 'เลือกว่าต้องการแสดงข้อมูลใดของสมาชิกบ้างและต้องการซ่อนข้อมูลใดเอาไว้ โดยข้อมูลที่ซ่อนไว้จะมีเฉพาะอาจารย์และผู้ดูแลระบบเท่านั้นที่จะเห็น เป็นการเพิ่มความเป็นส่วนตัวให้กับนักเรียน กดปุ่ม CTRL ค้างเอาไว้หากต้องการเลือกหลายค่า';
$string['configidnumber'] = 'ระบุตัวเลือกนี้ a.ไม่มีการถามหมายเลข ID b.ถาม ID จากสมาชิกแต่จะเติมหรือไม่ก็ได้ c.ถาม ID จากสมาชิกและจำเป็นต้องเติม ในกรณีที่เลือกให้แสดงเลขประจำตัวในหน้าข้อมูลส่วนตัว';
$string['configintro'] = 'คุณสามารถระบุตัวเลขของตัวแปรต่างๆ เพื่อให้ Moodle ทำงานบนเซิร์ฟเวอร์ของคุณโดยไม่มีปัญหา โดยทั่วไปแล้วค่าที่ตั้งไว้ของโปรแกรมก็สามารถทำงานได้โดยไม่มีปํญหา คุณสามารถกลับมาแก้ไขหน้านี้ภายหลังได้';
$string['configintroadmin'] = 'ในหน้านี้คุณควรระบุผู้ดูแลระบบที่มีสิทธิในการจัดการเว็บไซต์  ทั้งนี้คุณสามารถเพิ่มเติมผู้ดูแลรายอื่นได้ในภายหลัง';
$string['configintrosite'] = 'ในหน้านี้คุณสามารถกำหนดรูปแบบและชื่อของเว็บไซต์ได้ และสามารถเปลี่ยนแปลงในภายหลังได้';
$string['configiplookup'] = 'เมื่อคลิกที่หมายเลขไอพี เช่น  34.12.222.93 ที่อยู่ในบันทึการใช้งานเว็บไซต์ ระบบจะแสดงแผนที่ว่าไอพีนั้นมาจากที่ใด มีปลั๊กอินอยู่หลานตัวด้วยกันให้เลือกใช้โดยแต่ละตัวจะมีข้อดีและข้อเสียต่างกันไป';
$string['configkeeptagnamecase'] = 'ตรวจสอบว่าคุณต้องการเก็บชื่อแท็กเอาไว้เหมือนเดิมตามที่สมาชิกเพิ่มมาโดยไม่ทำการเปลี่ยนตัวพิมพ์ใหญ่ พิมพ์เล็ก';
$string['configlang'] = 'เลือกภาษาหลักสำหรับเว็บไซต์  คุณสามารถเลือกเปลี่ยนเป็นภาษาอื่นได้ในภายหลัง';
$string['configlanglist'] = 'ไม่เติมก็ได้ ถ้าคุณต้องการให้สมาชิกเลือกภาษาทั้งหมดที่คุณติดตั้ง อย่างไรก็ตามคุณสามารถให้เลือกได้เฉพาะบางภาษาได้ ตัวอย่างเช่น th,en,de';
$string['configlangmenu'] = 'เลือกที่จะแสดงและไม่แสดงเมนูในภาษาอื่น ๆ';
$string['configlangstringcache'] = 'เก็บภาษาทั้งหมดไว้ในความจำสำรองในลักษณะของไฟล์ในไดเรกทอรี data   ถ้าหากท่านแปลภาษาใน Moodle หรือเปลี่ยนข้อความใน โค้ดของ  Moodle  ท่านควรปิดการใช้งานส่วนนี้ไว้   หรือเปิดการใช้งานเพื่อให้ระบบทำงานได้เร็วขึ้น';
$string['configlatinexcelexport'] = 'เลือก encoding สำหรับการส่งออกไฟล์ excel';
$string['configlocale'] = 'เลือก locale เช่นลักษณะ ของแป้นพิมพ์ ตัวอักษร ภาษา วันที่ คุณต้องมี Locale นี้ติดตั้งในเครื่องของคุณ ถ้าหากไม่ทราบว่าจะเลือกอะไรให้ปล่อยว่างไว้ สำหรับภาษาไทยให้ใส่ th_TH.UTF-8';
$string['configloginhttps'] = 'หากเลือกข้อนี้ Moodle จะใช้วิธีการติดต่อกับเซิร์ฟเวอร์โดยผ่าน secure https ในการล็อกอินเข้าสู่ระบบแต่ละครั้ง จากนั้นจะทำการเปลี่ยนมาใช้ http ธรรมดาเพื่อช่วยให้การใช้งานเร็วขึ้น คำเตือน: เว็บเซิร์ฟเวอร์จำเป็นต้องอนุญาตให้ใช้ https ได้จึงจะสามารถตั้งค่านี้ได้ ถ้าหากค่าดังกล่าวไม่ได้รับการติดตั้งไว้ก่อนจะทำให้คุณถูกทำให้ออกจากระบบได้';
$string['configloglifetime'] = 'กำหนดช่วงเวลาเก็บบันทึกการใช้งานเว็บไซต์ของสมาชิก กำหนดให้นานเท่าที่คุณต้องการ แต่ทั้งนี้ก็จะทำให้มีการใช้ทรัพยากรระบบมากขึ้นตามไปด้วย สำหรับเว็บไซต์ที่มีสมาชิกจำนวนมากควรตั้งค่านี้ให้น้อยลง';
$string['configlookahead'] = 'จำนวนวันที่ต้องการแสดงล่วงหน้า';
$string['configmailnewline'] = 'ใช้อักขระการขึ้นบรรทัดใหม่ในอีเมล จำเป็นต้องใช้ CRLF ตามกำหนดของ RFC 822bis  เมลเซิร์ฟเวอร์บางเครื่องจะทำการเปลี่ยน จาก LF เป็น CRLF โดยอัตโนมัติ แต่บางเซิร์ฟเวอร์ไม่สามารถเปลี่ยนจาก CRLF เป็น CRCRLF ได้ถูกต้อง  และเซิร์ฟเวอร์อีกจำนวนหนึ่งที่ไม่ยอมรับค่า  LF  อาทิ ใน qmail ให้ลองเปลี่ยนการตั้งค่านี้หากมีปัญหาในการส่งอีเมลที่มี ข้อความเป็นการขึ้นบรรทัดใหม่สองบรรทัด';
$string['configmaxbytes'] = 'ระบุขนาดไฟล์ที่ใหญ่ที่สุดที่สามารถจะอัพโหลดขึ้นบนเว็บไซต์ได้ ค่านี้จะถูกกำหนดไว้แล้วโดยเซิร์ฟเวอร์ เป็นการตั้งค่าของ PHP upload_max_filesize และ Apache LimitRequestBody แต่คุณก็สามารถจะระบุขนาดไฟล์ได้ตราบใดที่ไม่เกินค่าที่ตั้งไว้ก่อนแล้ว';
$string['configmaxconsecutiveidentchars'] = 'รหัสผ่านต้องจำนวนตัวอักษรซ้ำกันติดกันไม่เกินกี่ตัว หากต้องการปิดการใช้งานให้ใส่ ០';
$string['configmaxeditingtime'] = 'ในส่วนนี้เป็นการระบุเวลาที่ให้สมาชิกแก้ไขโพสต์ของตน การแสดงความคิดเห็น อธิภธานศัพท์ ส่วนใหญ่แล้วประมาณ 30 นาทีกำลังพอดี';
$string['configmaxevents'] = 'จำนวนกิจกรรมที่ต้องการแสดงล่วงหน้า';
$string['configmaxusersperpage'] = 'จำนวนสมาชิกสูงสุดที่แสดงในหน้าการเลือกสมาชิกใน รายวิชา ,กลุ่ม, รุ่น, เว็บเซอร์วิส เป็นต้น';
$string['configmessaging'] = 'ต้องการเปิดใช้งานระบบข้อความระหว่างสมาชิกหรือไม่';
$string['configmessagingallowemailoverride'] = 'เปิดการใช้งานให้สมาชิกสามารถรับการแจ้งเตือนส่งไปยังอีเมลอื่นนอกเหนือจากที่อยู่ในประวัติส่วนตัว';
$string['configmessagingdeletereadnotificationsdelay'] = 'การแจ้งเตือนแล้วสามารถลบออกได้เลยเพื่อประหยัดพื้นที่ ท่านต้องการลบการแจ้งเตือนนานเท่าไหร่หลังจากที่อ่านแล้ว';
$string['configmessaginghidereadnotifications'] = 'ซ่อนการแจ้งเตือนเหตุการณ์เช่น โพสต์จากกระดานเสวนา หรือ เมื่อดูประวัติการส่งข้อความ';
$string['configminpassworddigits'] = 'รหัสผ่านต้องมีความยาวอย่างน้อยกี่ตัว';
$string['configminpasswordlength'] = 'รหัสผ่านต้องมีความยาวอย่างน้อยกี่ตัวอักษร';
$string['configminpasswordlower'] = 'รหัสผ่านต้องมีจำนวนตัวพิมพ์เล็กอย่างน้อยกี่ตัว';
$string['configminpasswordnonalphanum'] = 'รหัสผ่านต้องมีอักขระอื่นนอกเหนือจากตัวหนังสืออย่างน้อยกี่ตัว';
$string['configminpasswordupper'] = 'รหัสผ่านต้องมีตัวพิมพ์ใหญ่อย่างน้อยกี่ตัว';
$string['configmodchooserdefault'] = 'ต้องการตั้งค่าให้ระบบแสดงตัวเลือกกิจกรรมแก่สมาชิกหรือไม่';
$string['configmycoursesperpage'] = 'จำนวนรายวิชาสูงสุดที่ต้องการแสดงในหน้ารายวิชาของฉัน';
$string['configmymoodleredirect'] = 'ค่านี้เป็นการบังคับให้แสดงผลตามค่า My Moodle ของสมาชิกแต่ละคนที่ตั้งเอาไว้';
$string['configmypagelocked'] = 'การตั้งค่านี้เพื่อป้องกันไม่ให้บุคคลที่ไม่ใช่ผู้ดูแลระบบแก้ไขหน้าที่ตั้งไว้';
$string['confignavcourselimit'] = 'จำกัดจำนวนรายวิชาที่ต้องการแสดงแก่สมาชิกยังไม่ได้เข้าสู่ระบบหรือยังไม่ได้สมัครเข้าเรียนในรายวิชา';
$string['confignavshowallcourses'] = 'ตั้งค่านี้เพื่อให้สมาชิกที่สมัครเข้าเรียนในรายวิชามองเห็นรายวิชาทั้งหมดในหน้าการนำทาง นอกเหนือจากหน้า "รายวิชาของฉัน" ( รายชื่อวิชาที่สมัครเข้าเรียน)';
$string['confignavshowcategories'] = 'แสดงประเภทของรายวิชาในแถบนำทางและบล็อคนำทาง การแสดงนี้จะไม่แสดงในรายวิชาที่สมาชิกสมัครเรียนไปแล้ว แต่จะยังปรากฎอยู่ในหน้า รายวิชาของฉันโดยไม่แสดงประเภท';
$string['confignoreplyaddress'] = 'ในบางครั้งระบบจะทำการส่งอีเมลในฐานะของสมาชิก เช่น ในกรณีโพสต์ในกระดานเสวนา อีเมลที่คุณระบุไว้ในหน้าประวัติส่วนตัวจะนำมาใช้ในช่อง "From" แต่ถ้าสมาชิกไม่ต้องการให้ใครเห็นอีเมลให้ตั้งค่าไม่แสดงอีเมล ผู้รับจะไม่สามารถตอบเมล์ถึงสมาชิกได้โดยตรง';
$string['confignotifyloginfailures'] = 'ถ้าหากมีการบันทึกการล็อกอินเข้าสู่ระบบที่ไม่สำเร็จ ให้ระบบทำการส่งอีเมลออกไปถึงใครบ้าง';
$string['confignotifyloginthreshold'] = 'ถ้าเลือกที่จะแจ้งให้สมาชิกทราบเมื่อมีการล็อกอินไม่สำเร็จเกิดขึ้น ต้องการให้สมาชิกล็อกอินได้กี่ครั้งต่อหนึ่งสมาชิกต่อหนึ่ง IP';
$string['confignotloggedinroleid'] = 'สำหรับสมาชิกที่ไม่ได้ล็อกอินเข้าสู่ระบบ ระบบจะให้สิทธิเทียบเท่ากับระดับเว็บไซต์ ซึ่งปกติแล้วคือ "บุคคลทั่วไป" แต่ท่านสามารถที่จะสร้างบทบาทใหม่ข้นมาโดยให้สิทธิมากหรือน้อยกว่านี้ก็ได้';
$string['configopentogoogle'] = 'ถ้าหากเลือกใช้ตัวเลือกนี้ Google จะสามารถเข้ามายังเว็บไซต์ของคุณในฐานะบุคคลทั่วไป ผู้ที่เข้ามาเว็บไซต์ของคุณผ่านทาง Google ก็จะมีการล็อกอินในฐานะบุคคลทั่วไปโดยอัตโนมัติ';
$string['configoverride'] = 'กำหนดค่าใน config.php';
$string['configpasswordpolicy'] = 'เปิดการใช้งานในส่วนนี้ ระบบจะทำการตรวจสอบรหัสผ่านที่สมาชิกเลือกใช้กับวิธีการเลือกรหัสผ่านของระบบ ท่านสามารถตั้งค่าวิธีการเลือกรหัสผ่านได้จากด้านล่างนี้  (หากเลือกค่านี้เป็น "ไม่" ระบบจะไม่ตรวจสอบรหัสผ่าน)';
$string['configpathtodu'] = 'Path ของ du โดยทั่วไปแล้วจะเป็น usr/bin/du ถ้าหากคุณใส่ค่านี้ หน้าที่แสดงเนื้อหาในไดเรกทอรีจะเปิดได้เร็วขึ้นในกรณีที่เป็นไดเรกทอรีที่มีไฟล์จำนวนมาก';
$string['configperfdebug'] = 'ถ้าหากเปิดค่านี้ ระบบจะแสดงผลการทำงานใน footer ของรูปแบบเว็บแบบปกติ';
$string['configprofilesforenrolledusersonly'] = 'เพื่อป้องกันสแปมเมอร์ รายละเอียดของสมาชิกแต่ละคนที่ยังไม่ทำการสมัครเข้าเรียนในรายวิชาใด ๆ จะมีการซ่อนเอาไว้ สมาชิกใหม่จำเป็นต้องสมัครเข้าเรียนอย่างน้อยหนึ่งวิชาก่อนจึงจะสามารถเพิ่มรายละเอียดลงในหน้าประวัติสมาชิกได้';
$string['configprotectusernames'] = 'ตามค่าทั้งตั้งไว้ใน forget_password.php จะไม่มีการแสดงคำใบ้เพื่อให้สมาชิกเดา "ชื่อผู้ใช้" หรือ "อีเมล"';
$string['configproxybypass'] = 'รายชื่อของ โฮสต์  หรือ หมายเลขไอพีที่ควรทำการ บายพาสพร็อกซี่ แยกกันด้วยคอมม่า (เช่น, 192.168., .mydomain.com)';
$string['configproxyhost'] = 'ถ้า <B>server</B> จำเป็นต้องใช้ PROXY ในการเข้าอินเทอร์เน็ต ให้ระบุ proxy host และ port ในส่วนนี้';
$string['configproxypassword'] = 'รหัสผ่าน สำหรับการใช้งานพร็อกซี่ ปล่อยว่างไว้หากไม่จำเป็นต้องใช้งาน (จำเป็นต้องเปิดการใช้งาน PHP cURL extension )';
$string['configproxyport'] = 'หากเซิร์ฟเวอร์นี้จำเป็นต้องใช้พร็อกซี่คอมพิวเตอร์ให้ระบุพอร์ตพร็อกซี่ที่นี่';
$string['configproxytype'] = 'ประเภทของเว็บพร็อกซี่  (PHP5 and cURL extension จำเป็นสำหรับการใช้งาน SOCKS5 )';
$string['configproxyuser'] = 'ชื่อผู้ใช้สำหรับการใช้ใช้งานพร็อกซี่ ปล่อยว่างไว้หากไม่จำเป็นต้องใช้งาน (จำเป็นต้องเปิดการใช้งาน PHP cURL extension )';
$string['configrecaptchaprivatekey'] = 'อักขระที่ใช้งานสำหรับการติดต่อระหว่าง moodle กับ เซิร์ฟเวอร์ recaptcha.net หาได้จากเว็บไซต์ http://recaptcha.net';
$string['configrecaptchapublickey'] = 'อักขระที่ใช้สำหรับการแสดงผล ส่วนประกอบของ reCAPTCHA ในแบบฟอร์มการสมัคร สร้างโดย http://recaptcha.net';
$string['configrequestedstudentname'] = 'คำขอสำหรับนักเรียนในการขอให้เปิดรายวิชา';
$string['configrequestedstudentsname'] = 'คำขอสำหรับนักเรียนในการขอให้เปิดรายวิชา';
$string['configrequestedteachername'] = 'คำขอสำหรับอาจารย์ในการขอเปิดรายวิชา';
$string['configrequestedteachersname'] = 'คำขอสำหรับอาจารย์ในการขอเปิดรายวิชา';
$string['configsectioninterface'] = 'การแสดงผล';
$string['configsectionmail'] = 'อีเมล';
$string['configsectionmaintenance'] = 'การบำรุงรักษา';
$string['configsectionmisc'] = 'เบ็ดเตล็ด';
$string['configsectionoperatingsystem'] = 'ระบบปฏิบัติการ';
$string['configsectionpermissions'] = 'กำหนดสิทธิ';
$string['configsectionrequestedcourse'] = 'คำขอเปิดรายวิชา';
$string['configsectionsecurity'] = 'ความปลอดภัย';
$string['configsectionstats'] = 'สถิติ';
$string['configsectionuser'] = 'สมาชิก';
$string['configsecureforms'] = 'การกำหนดระดับการรักษาความปลอดภัยในการรับข้อมูลจากสมาชิก ทั้งนี้อาจก่อให้สมาชิกบางคนที่ติดตั้งระบบไฟร์วอลไม่สามารถใช้งานได้';
$string['configsessioncookie'] = 'ตั้งชื่อของ cookies ที่ใช้ในแต่ละครั้งซึ่งไม่จำเป็นต้องระบุ การตั้งชื่อนี้จะมีประโยชน์ในกรณีที่คุณมี moodle ติดตั้งมากกว่าหนึ่งบนเซิร์ฟเวอร์';
$string['configsessioncookiedomain'] = 'คุณสามารถเปลี่ยนค่าโดเมนที่นำ moodle cookies มาใช้งานได้ มีประโยชน์สำหรับการปรับแต่ง moodle ที่ต้องการใช้งานข้อมูล moodle session ร่วมกับเว็บแอพลิเคชั่นบนซับโดเมนอื่น เช่น การอนุมัติ หรือ ปลั๊กอินในการสมัครเข้าเรียน  <strong>คำเตือน: แนะนำให้ปล่อยค่านี้ว่างไว้ - หากใส่ค่าผิดจะทำให้ไม่สามารถเข้าสู่ระบบได้</strong>';
$string['configsessioncookiepath'] = 'ถ้าต้องการเปลี่ยนค่าที่บราวเซอร์ส่งคุกกี้ ไปเก็บไว้ท่านสามารถระบุไดเรกทอรีของเว็บไซต์ลงไปได้ หากไม่ระบุให้ใส่ค่าที่ตั้งไว้เป็น / ซึ่งก็จำทำงานได้เป็นปกติ';
$string['configsessiontimeout'] = 'ถ้าหากสมาชิกใช้ล็อกอินเป็นเวลานานโดยที่ไม่ได้เปิดดูหน้าใดๆ เลย ระบบจะทำการล็อกเอาท์ให้อัตโนมัติ ภายในเวลาที่คุณระบุนี้';
$string['configshowsiteparticipantslist'] = 'รายชื่อของนักเรียนและอาจารย์ทั้งหมดบนเว็บนี้จะมีการแสดงไว้บนเว็บ กรุณาเลือกผู้ที่คุณอนุญาตให้มองเห็นรายการดังกล่าว';
$string['configsitemailcharset'] = 'อีเมลทุกฉบับที่ส่งออกจากเว็บไซต์นี้จะเป็นอักขระที่ท่านระบุไว้ที่นี่ แต่ท่านสามารถเลือกให้สมาชิก ปรับค่าดังกล่าวโดยการเปิดให้ใช้งานในส่วนนี้';
$string['configsitemaxcategorydepth'] = 'จำนวนจำนวนประเภทหลักสูงสุด';
$string['configsitemaxcategorydepthhelp'] = 'ระบุจำนวนประเภทรองสูงสุด';
$string['configslasharguments'] = 'ไฟล์ เช่น ภาพ อัพโหลด จะถูกส่งผ่านสคริปต์ โดยใช้ \'slash arguments\' (ตัวเลือกที่สอง) วิธีนี้ทำให้ ง่ายต่อการเก็บไฟล์ไว้ในระบบความจำชั่วคราวบนเว็บเบราเซอร์ หรือ พร็อกซี่เซิร์ฟเวอร์ แต่กระนั้น สำหรับ php เซริฟ์เวอร์ บางประเภท ไม่สามารถจะใช้วิธีนี้ได้ จึงทำให้เกิดปัญหาในการดูไฟล์ที่อัพโหลดขึ้นไป หรือ การดูภาพ ให้แก้ ปัญหาโดยการเลือกตัวแปรนี้เป็น ตัวเลือกที่หนึ่ง';
$string['configsmartpix'] = 'หากเปิดการใช้งาน ระบบจะเลือกใช้ไอคอนผ่านการค้นหาด้วย PHP สคริปต์ที่ค้นรูปแบบเว็บที่ใช้งานปัจจุบัน จากนั้นรูปแบบเว็บหลัก จากนั้นค้นหาในโฟลเดอร์ Moodle/pix ทำให้ลดการซ้ำซ้อนของรูปภาพภายในรูปแบบเว็บด้วยกัน แต่จะทำให้เว็บทำงานได้ช้าลงเล็กน้อย';
$string['configsmtphosts'] = 'ใส่ชื่อเต็มของ SMTP เซิร์ฟเวอร์ ที่โปรแกรม Moodle จะใช้สำหรับส่งเมล์ (เช่น mail.a.acom หรือ mail.b.com หรือ mail.c.com) ถ้าหากคุณทิ้งว่างไว้ Moodle จะเลือกใช้ ค่าที่ตั้งไว้แล้ว ในการส่งเมล';
$string['configsmtpmaxbulk'] = 'จำนวนข้อความสูงสุดที่ส่งได้ในหนึ่ง smtp เซสชั่น การรวมข้อความสามารถที่จะเพิ่มความเร็วในการส่งอีเมล ค่าที่ต่ำกว่า 2 จะบังคับให้มีการสร้าง smtp เซสชั่นใหม่ทุกครั้งสำหรับการอีเมลแต่ละครั้ง';
$string['configsmtpuser'] = 'หากต้องการระบุ SMTP เซิร์ฟเวอร์ข้างต้น และ เซิร์ฟเวอร์ต้องการรหัสผ่านให้ทำการ ใส่ "ชื่อผู้ใช้" และ "รหัสผ่าน"';
$string['configstartwday'] = 'วันแรกของสัปดาห์';
$string['configstatsfirstrun'] = 'ระบุว่าต้องการให้แสดงสถิตินับตั้งแต่เมื่อไร สำหรับการเปิดใช้งานในครั้งแรก cron จะได้เลือกทำงานในการรวบรวมข้อมูลสถิติ ถ้าหากเว็บไซต์ของคุณมีผู้ใช้งานจำนวนมากและอยู่ใช้บริการ hosting ร่วมกับบุคคลอื่นบนเซิร์ฟเวอร์ ไม่ควรจะเลือกเวลาที่นานเกินไปเพราะจะทำให้ใช้เวลานานและใช้ทรัพยากรของเครื่องเซิร์ฟเวอร์เป็นจำนวนมาก (ข้อควรรู้ สำหรับการตั้งค่านี้ 1= 28 วัน ในกราฟและรายงานจะแสดง 1 เดือน = 1 เดือนในปฏิทิน)';
$string['configstatsmaxruntime'] = 'การประมวลผลสถิติกินเวลาค่อนข้างนาน ให้เลือกใช้ฟิลด์ต่อไปนี้ในการเลือกว่าต้องการให้ทำงานเมื่อไรและเป็นเวลาเท่าไร';
$string['configstatsmaxruntime2'] = 'การประมวลผลของสถิติอาจใช้เวลานานและทำให้เซิร์ฟเวอร์ทำงานหนัก กำหนดระยะเวลาสูงสุดที่ใช้ในการรวบรวมสถิติในหนึ่งวัน จำนวนวันสูงสุดที่ cron จะทำงานคือ 31 วัน';
$string['configstatsmaxruntime3'] = 'ระบุระยะเวลาสูงสุดที่ต้องการคำนวนสถิติสำหรับหนึ่งวัน ควรจำไว้ว่าการประมวลผลนี้จะทำให้เซิร์ฟเวอร์ทำงานหนัก ระบุจำนวนวันสูงสุดสำหรับ cron ด้านล่างนี้';
$string['configstatsruntimedays'] = 'ระบุจำนวนวันสูงสุดสำหรับการประมวลผลสำหรับการเก็บสถิติแต่ละครั้ง เมื่อสถิติเป็นปัจจุบันอยู่แล้วระบบจะสามารถประมวลผลได้เพียงหนึ่งวันเท่านั้น การปรับค่านี้ขึ้นอยู่กับโหลดของเซิร์ฟเวอร์ ลดจำนวน ปากต้องการให้ cron ทำงานใช้เวลาสั้นลง';
$string['configstatsruntimestart'] = 'เวลาที่ต้องการให้ cronjob สำหรับการรวบรวมสถิติ';
$string['configstatsuserthreshold'] = 'ถ้าหากเติมค่าที่ไม่ใช่ 0 และไม่เป็นตัวเลข ในการจัดลำดับรายวิชา ระบบจะไม่สนใจวิชาที่น้อยกว่าค่านี้สำหรับการเข้าเป็นสมาชิกทั้งอาจารย์และนักเรียน';
$string['configstripalltitletags'] = 'ยกเลิกการเลือกใช้งานค่านี้หากต้องการใช้งาน แท็ก html ในชื่อกิจกรรมและแหล่งข้อมูล';
$string['configsupportemail'] = 'ระบบจะแสดงอีเมลนี้แก่สมาชิกเมื่อสมาชิกต้องการความช่วยเหลือ เช่น เรื่องการสร้างบัญชีผู้ใช้ใหม่';
$string['configsupportname'] = 'ชื่อของผู้ที่จะทำการช่วยเหลือสมาชิกผ่านอีเมลหรือเว็บ';
$string['configsupportpage'] = 'ชื่อเว็บนี้จะเผยแพร่ให้สมาชิกทราบหากต้องการข้อมูลเพิ่มเติม';
$string['configthemelist'] = 'หากปล่อยทิ้งไว้ระบบจะแสดงรูปแบบเว็บทั้งหมดที่มีอยู่ หากต้องการลดจำนวนเมนูของรูปแบบเว็บสามารถทำการระบุชื่อรูปแบบเว็บที่จะอนุญาตให้ใช้โดยแยกกันด้วยเครื่องหมายจุลภาค (คอมม่า) เช่น standard,orangewhite';
$string['configtimezone'] = 'คุณสามารถตั้งโซนเวลาที่คุณอยู่ได้ โดยโซนเวลาที่คุณอยู่อาจไม่ตรงกับเวลาของเซิร์ฟเวอร์ ซึ่งเวลาดังกล่าวจะใช้ตลอดทั้งเว็บไซต์  สมาชิกสามารถที่จะเปลี่ยนโซนเวลาดังกล่าวให้ตรงกับที่ตนเองอยู่ได้';
$string['configuseblogassociations'] = 'สมาชิกสามารถที่จะจัดการบล็อกโดยให้แต่ละเนื้อหาที่เขียนเกี่ยวโยงกับรายวิชาหรือกิจกรรมในรายวิชาหรือไม่ ?';
$string['configuseexternalyui'] = 'แทนที่จะใช้ไฟล์จากในเครื่อง ให้ใช้ออนไลน์ไฟล์แทนจาก เวิร์ฟเวอร์ของยาฮู คำเตือน : จำเป็นต้องมีการเชื่อมต่อกับอินเทอร์เน็ต และ AJAX จะไม่ทำงานบนเว็บไซต์ของคุณ';
$string['configusetags'] = 'เปิดการใช้งานแท็กฟังก์ชั่นตลอดทั้งเว็บไซต์หรือไม่ ?';
$string['configvariables'] = 'แก้ไขตัวแปร';
$string['configverifychangedemail'] = 'เปิดการใช้งานการตรวจสอบอีเมลทุกครั้งที่มีการเปลี่ยนอีเมล โดยใช้การกำหนดค่าโดเมนที่สามารถใช้งานได้ หากปิดการใช้งานค่านี้  การตั้งค่าโดเมนจะมีผลเฉพาะกับการสร้างบัญชีสมาชิกใหม่เท่านั้น';
$string['configvisiblecourses'] = 'แสดงรายวิชาในประเภทที่ซ่อนเอาไว้ตามปกติ';
$string['configwarning'] = 'ระวังในการเปลี่ยนแปลงค่าต่างๆ เหล่านี้ การตั้งค่าผิดพลาดจะทำให้เกิดปัญหาได้';
$string['confirmation'] = 'การยืนยัน';
$string['confirmed'] = 'ยืนยัน';
$string['cookiehttponly'] = 'http cookies เท่านั้น';
$string['cookiesecure'] = 'Secure cookies เท่านั้น';
$string['country'] = 'ประเทศที่ใช้งานเริ่มต้น';
$string['coursecontact'] = 'การจัดการหลักสูตร';
$string['coursecontact_desc'] = 'ค่านี้จะเป็นตัวกำหนดว่าใครจะปรากฎอยู่ในหน้ารายละเอียดของรายวิชาบ้าง โดยบุคคลดังกล่าวจะต้องมีบทบาทในรายวิชาอย่างน้อยที่สุด 1 บทบาท';
$string['coursemgmt'] = 'เพิ่ม/แก้ไข รายวิชา';
$string['courseoverview'] = 'ภาพรวมของรายวิชา';
$string['courserequestnotify'] = 'การแจ้งการขอเปิดรายวิชาใหม่';
$string['courserequestnotifyemail'] = 'สมาชิก {$a->user} ทำการขอเปิดรายวิชาใหม่ที่ {$a->link}';
$string['courserequests'] = 'คำขอเปิดรายวิชา';
$string['courserequestspending'] = 'คำขอรายวิชาที่กำลังอยู่ในขั้นพิจารณา';
$string['courses'] = 'รายวิชาทั้งหมด';
$string['coursesperpage'] = 'จำนวนรายวิชาต่อหน้า';
$string['creatornewroleid'] = 'บทบาทสำหรับผู้สร้างคอร์สในรายวิชาใหม่';
$string['cronclionly'] = 'ให้ครอนทำงานผ่าน commandline เท่านั้น';
$string['cronerrorclionly'] = 'ขออภัยค่ะ ผู้ดูแลระบบทำการปิดหน้านี้เองไว้';
$string['cronerrorpassword'] = 'ขออภัยค่ะ ท่านต้องระบุรหัสผ่านเพื่อเข้าถึงหน้านี้';
$string['cronremotepassword'] = 'รหัสผ่านสำหรับใช้งานครอน';
$string['cronwarning'] = 'ไฟล์<a href="cron.php"> cron.php  </a> ซึ่งทำหน้าที่ในการบำรุงรักษาไม่ได้ทำงานมาแล้วอย่างน้อย 24 ชั่วโมง <a href="../doc/?frame=install.html&sub=cron">เอกสารการติดตั้ง</a>  วิธีการเปิดการใช้งานอัตโนมัติ';
$string['ctyperequired'] = 'Moodle จำเป็นต้องใช้ ctype PHP extension สำหรับการใช้งานหลายภาษา';
$string['curlcache'] = 'cURL cache TTL';
$string['curlrequired'] = 'จำเป็นต้องใช้งาน cURL cache TTL ในการติดต่อกับคลังข้อมูลของ moodle';
$string['customcheck'] = 'การตรวจสอบอื่น ๆ';
$string['datarootsecurityerror'] = '<p><strong>คำเตือนความปลอดภัย!</strong></p><p>ไดเรกทอรีข้อมูลของคุณสามารถเข้าถึงผ่านเว็บได้ ทำให้บุคคลภายนอกสามารถเข้าถึงไฟล์ข้อมูลต่าง ๆ ได้ ซึ่งไม่ปลอดภัยเพราะอาจมีผู้ไม่ประสงค์ดีทำการลบหรือเปลี่ยนแปลงข้อมูลของคุณได้!</p>
<p>คุณ <em>ต้อง</em> ย้ายไดเรกทอรี({$a}) to ไปยังโฟลเดอร์ใหม่ที่ไม่สามารถเข้าถึงได้ผ่านเว็บ แล้วทำการเปลี่ยนค่า <code>$CFG->dataroot</code>ในไฟล์ config.php </p>';
$string['datarootsecuritywarning'] = 'การตั้งค่าของเว็บไซต์ของท่านอาจไม่ปลอดภัย ตรวจสอบให้แน่ใจว่าไดเรกทอรีข้อมูล  ({$a}) ไม่สามารถเข้าถึงได้โดยตรงผ่านเว็บ';
$string['dbsessions'] = 'ใช้ฐานข้อมูลสำหรับเก็บข้อมูลเซสชัน';
$string['debug'] = 'ข้อความแสดงข้อผิดพลาด';
$string['debugall'] = 'ทั้งหมด: แสดงข้อความจากโค้ด PHP ที่สมเหตุสมผล ที่ได้จากการ Debug ทั้งหมด';
$string['debugdeveloper'] = 'นักพัฒนา: แสดงข้อความของการ debug ทั้งหมด เพื่อทำการพัฒนาแก้ไขข้อผิดพลาด';
$string['debugdisplay'] = 'แสดงข้อความที่ได้จากการ debug';
$string['debugging'] = 'Debugging';
$string['debugminimal'] = 'ต่ำสุด: แสดงเฉพาะ fatal error';
$string['debugnone'] = 'ไม่แสดง: ไม่แสดงข้อผิดพลาดหรือคำเตือน';
$string['debugnormal'] = 'ปกติ: แสดงข้อผิดพลาด คำเตือน และประกาศ';
$string['debugpageinfo'] = 'แสดงข้อมูลของหน้านี้';
$string['debugsmtp'] = 'Debug การส่งอีเมล';
$string['debugstringids'] = 'แสดงภาษาเดิม';
$string['debugvalidators'] = 'แสดงลิงก์ที่ถูกต้อง';
$string['defaultrequestcategory'] = 'ประเภทสำหรับคำขอเปิดหลักสูตร';
$string['defaultsettinginfo'] = 'ค่าที่ตั้งไว้: {$a}';
$string['defaultuserroleid'] = 'บทบาทเริ่มต้นของผู้ใช้ทั้งหมด';
$string['deleteincompleteusers'] = 'ลบสมาชิกที่ไม่สมบูรณ์ภายหลัง';
$string['deleteunconfirmed'] = 'ลบสมาชิกที่ไม่ทำการยืนยันหลังจาก';
$string['deleteuser'] = 'ลบสมาชิก';
$string['density'] = 'ความหนาแน่น';
$string['denyemailaddresses'] = 'ไม่รับอีเมลจากโดเมนต่อไปนี้';
$string['development'] = 'การพัฒนา';
$string['disableuserimages'] = 'ปิดการใช้งานรูปภาพประจำตัว';
$string['displayerrorswarning'] = 'ไม่แนะนำให้เปิดการใช้งานค่า PHP <em>display_errors</em> สำหรับเว็บไซต์ที่ใช้งานจริงเพราะรายงานข้อผิดพลาดดังกล่าวอาจเปิดเผยจุดอ่อนของเซิร์ฟเวอร์แก่บุคคลไม่พึงประสงค์ได้';
$string['displayloginfailures'] = 'แสดงผลการเข้าสู่ระบบล้มเหลวแก่';
$string['docroot'] = 'ที่ตั้งของเอกสารคู่มือ Moodle';
$string['doctonewwindow'] = 'เปิดในหน้าต่างใหม่';
$string['download'] = 'ดาวน์โหลด';
$string['edithelpdocs'] = 'แก้ไขเอกสารช่วยเหลือ';
$string['editlang'] = '<b>แก้ไข</b>';
$string['editorbackgroundcolor'] = 'สีของพื้นหลัง';
$string['editordictionary'] = 'พจนานุกรม';
$string['editorfontfamily'] = 'ตระกูลตัวอักษร';
$string['editorfontlist'] = 'รายการตัวอักษร';
$string['editorfontsize'] = 'ขนาดตัวอักษร';
$string['editorhidebuttons'] = 'ปุ่มที่ต้องการซ่อน';
$string['editorkillword'] = 'ฟิลเตอร์รูปแบบเวิริ์ด';
$string['editorspelling'] = 'ตรวจสอบการสะกดคำ';
$string['editorspellinghelp'] = 'เปิดหรือปิดการใช้งาน การตรวจสอบการสะกดคำ เมื่อเปิดการใช้งาน ระบบต้องทำการติดตั้ง aspell';
$string['editstrings'] = 'เปรียบเทียบและแก้ไขภาษา';
$string['emailchangeconfirmation'] = 'ยืนยันการเปลี่ยนแปลงอีเมล';
$string['emoticons'] = 'ไอคอน';
$string['emptysettingvalue'] = 'ว่าง';
$string['enablecalendarexport'] = 'เปิดการใช้งานการส่งออกปฏิทิน';
$string['enablecomments'] = 'เปิดการใช้งานการแสดงความคิดเห็น';
$string['enablecourserequests'] = 'เปิดใช้งานการขอเปิดหลักสูตร';
$string['enablerecordcache'] = 'เปิดใช้งานความจำชั่วคราว';
$string['enablerssfeeds'] = 'เปิดใช้งานการป้อนข้อมูลข่าวสาร (RSS)';
$string['enablestats'] = 'เปิดใช้งานสถิติ';
$string['enabletrusttext'] = 'เปิดใช้งานเนื้อหาที่เชื่อถือได้ (Trusted Content)';
$string['enablewebservices'] = 'เปิดการใช้งานเว็บเซอร์วิส';
$string['enrolmultipleusers'] = 'สมัครสมาชิกเข้าเป็นนักเรียน';
$string['environment'] = 'ข้อมูลระบบ';
$string['environmenterrortodo'] = 'ท่านต้องแก้ไขปัญหาของระบบทั้งหมดที่ตรวจพบข้างต้นก่อนที่จะทำการติดตั้ง Moodle เวอร์ชันนี้';
$string['environmenterrorupgrade'] = 'คำเตือน : ควรทำการแก้ปัญหาข้อผิดพลาดต่าง ๆ ที่ระบบพบก่อนที่จะทำการอัพเกรด Moodle การอัพเกรดโดยไม่แก้ไขก่อนอาจทำให้ข้อมูลเสียหายหรืออาจหายไปได้ คุณยังต้องการที่จะทำการอัพเกรดต่อไปหรือไม่ ?';
$string['environmentmustfixsetting'] = 'ควรเปลี่ยนการตั้งค่า PHP';
$string['environmentok'] = 'เซิร์ฟเวอร์ต้องต้องมีคุณสมบัติอย่างน้อยดังนี้';
$string['environmentrecommendcustomcheck'] = 'ในกรณีที่การทดสอบล้มเหลว ต่อไปนี้คือปัญหาที่อาจประสบอยู่';
$string['environmentrecommendinstall'] = 'แนะนำสำหรับการติดตั้ง/เปิดใช้งาน';
$string['environmentrecommendversion'] = 'ระบบต้องการเวอร์ชัน {$a->needed} ขณะนี้ท่านกำลังใช้งานเวอร์ชัน {$a->current}';
$string['environmentrequirecustomcheck'] = 'การทดสอบนี้จะต้องผ่านความต้องการดังนี้';
$string['environmentrequireinstall'] = 'ต้องการเพื่อทำการติดตั้ง/เปิดใช้งาน';
$string['environmentrequireversion'] = 'ต้องการเวอร์ชัน {$a->needed} ขณะนี้ท่านกำลังใช้งานเวอร์ชัน {$a->current}';
$string['environmentsettingok'] = 'พบการตั้งค่าที่เหมาะสม';
$string['environmentshouldfixsetting'] = 'ควรเปลี่ยนการตั้งค่า PHP';
$string['environmentxmlerror'] = 'มีข้อผิดพลาดในการอ่านข้อมูล ({$a->error_code})';
$string['errordeletingconfig'] = 'มีข้อผิดพลาดในการระหว่าการลบข้อมูลสำหรับปลั๊กอิน \'{$a}\'';
$string['errorsetting'] = 'ไม่สามารถบันทึกได้:';
$string['errorwithsettings'] = 'ไม่สามารถเปลี่ยนการตั้งค่าบางตัวได้เนื่องจากมีข้อผิดพลาด :';
$string['everyonewhocan'] = 'ทุกคนที่สามารถ \'{$a}\'';
$string['exceptions'] = 'ยกเว้น';
$string['experimental'] = 'โหมดทดลอง';
$string['experimentalsettings'] = 'การตั้งค่าโหมดทดลอง';
$string['extendedusernamechars'] = 'สามารถใช้อักขระพิเศษในชื่อผู้ใช้';
$string['extramemorylimit'] = 'เพิ่มความจำใน PHP memory limit';
$string['fatalsessionautostart'] = '<p>พบการตั้งค่าผิดพลาดกรุณาแจ้งผู้ดูแลระบบ</p><p> เพื่อให้ Moodle ทำงานอย่างถูกต้อง ผู้ดูแลระบบต้องทำการแก้ไขการตั้งค่าดังนี้</p><p><code>session.auto_start</code> เปลี่ยนเป็น<code>off</code>.</p><p>การตั้งค่านี้ อยู่ในไฟล์ <code>php.ini</code>, การตั้งค่าของ Apache/IIS <br />หรือไฟล์<code>.htaccess</code> บนเซิร์ฟเวอร์</p>';
$string['filecreated'] = 'สร้างไฟล์ใหม่แล้ว';
$string['filestoredin'] = 'บันทึกไฟล์ไว้ในโฟลเดอร์';
$string['filestoredinhelp'] = 'จุดหมายที่ต้องการเก็บไฟล์ไว้';
$string['filterall'] = 'ฟิลเตอร์เนื้อหาทั้งหมด';
$string['filtermatchoneperpage'] = 'ฟิลเตอร์หนึ่งลิงก์ต่อหน้า';
$string['filtermatchonepertext'] = 'ฟิลเตอร์หนึ่งลิงก์ต่อข้อความ';
$string['filters'] = 'ฟิลเตอร์';
$string['filtersettings'] = 'ตั้งค่าฟิลเตอร์';
$string['filtersettingsgeneral'] = 'การตั้งค่าทั่วไปของฟิลเตอร์';
$string['filteruploadedfiles'] = 'ฟิลเตอร์ไฟล์อัพโหลด';
$string['forcelogin'] = 'บังคับให้สมาชิกล็อกอินเข้าสู่ระบบเสมอ';
$string['forceloginforprofiles'] = 'บังคับให้สมาชิกล็อกอินเข้าสู่ระบบในการดูประวัติส่วนตัว';
$string['forcetimezone'] = 'บังคับการใช้งานโซนเวลาเดียวกันสำหรับสมาชิก';
$string['frontpage'] = 'จัดการหน้าแรก';
$string['frontpagebackup'] = 'สำรองข้อมูล';
$string['frontpagedefaultrole'] = 'บทบาทที่ตั้งไว้สำหรับหน้าแรก';
$string['frontpagefilters'] = 'ฟิลเตอร์สำหรับหน้าแรก';
$string['frontpageloggedin'] = 'รายการที่จะแสดงในหน้าแรกเมื่อเข้าสู่ระบบ';
$string['frontpageoverrides'] = 'การให้สิทธิในการเขียนทับในหน้าแรก';
$string['frontpagequestions'] = 'คำถามสำหรับหน้าแรก';
$string['frontpagerestore'] = 'กู้คืน';
$string['frontpageroles'] = 'กำหนดสิทธิ/บทบาท';
$string['frontpagesettings'] = 'การตั้งค่า';
$string['fullnamedisplay'] = 'การแสดงชื่อ-สกุล';
$string['generalsettings'] = 'การตั้งค่าทั่วไป';
$string['geoipfile'] = 'ไฟล์ข้อมูล GeoIP';
$string['getremoteaddrconf'] = 'ข้อมูลของที่อยู่ IP';
$string['gotofirst'] = 'ไปยังตำแหน่งแรกที่หายไป';
$string['gradebook'] = 'สมุดรายงานคะแนน';
$string['gradebookroles'] = 'บทบาทสำหรับการเข้าถึงสมุดคะแนน';
$string['gradeexport'] = 'ส่งออกคะแนน';
$string['guestroleid'] = 'สิทธิสำหรับบุคคลทั่วไป';
$string['helpadminseesall'] = 'ผู้ดูแลระบบเห็นเหตุการณ์ในปฏิทินทั้งหมดหรือไม่หรือเฉพาะผู้ที่เกี่ยวข้องเท่านั้น';
$string['helpforcetimezone'] = 'คุณสามารถอนุญาตให้แสดงโซนเวลาของสมาชิกแต่ละคนหรือบังคับโซนเวลาสำหรับทุกคน';
$string['helpsitemaintenance'] = 'สำหรับอัพเกรดหรืองานอื่น';
$string['helpstartofweek'] = 'ต้องการใช้วันใดเป็นวันเริ่มต้นปฏิทิน';
$string['helpupcominglookahead'] = 'ต้องการให้ปฏิทินเลือกแสดงเหตุการณ์ที่จะเกิดขึ้นในอีกกี่วันข้างหน้า';
$string['helpupcomingmaxevents'] = 'ต้องการแสดงจำนวนเหตุการณ์ที่จะเกิดขึ้นมากที่สุดกี่เหตุการณ์';
$string['helpweekenddays'] = 'วันใดของสัปดาห์ที่ถือว่าเป็น "วันหยุด" และแสดงด้วยสีที่แตกต่างไป';
$string['hiddenuserfields'] = 'ซ่อนข้อมูลของสมาชิก';
$string['hidefromall'] = 'ซ่อนจากสมาชิกทั้งหมด';
$string['hidefromnone'] = 'ไม่ซ่อน';
$string['hidefromstudents'] = 'ซ่อนจากนักเรียน';
$string['htmleditor'] = 'HTML Editor';
$string['htmleditorsettings'] = 'การตั้งค่า HTML editor';
$string['htmlsettings'] = 'การตั้งค่า HTML';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'ความปลอดภัยของ HTTP';
$string['ignore'] = 'ข้าม';
$string['includemoduleuserdata'] = 'รวมโมดูลข้อมูลสมาชิก';
$string['incompatibleblocks'] = 'ไม่สามารถใช้งานบล็อคนี้ได้';
$string['installhijacked'] = 'การติดตั้งต้องทำให้เสร็จโดยใช้หมายเลขไอพีเดียว';
$string['installsessionerror'] = 'ไม่สามารถเชื่อมต่อกับ PHP เซสชั่น ตรวจสอบว่าบราวเซอร์สามารถใช้งานคุ้กกี้';
$string['invalidsection'] = 'ส่วนนี้ไม่ถูกต้อง';
$string['invaliduserchangeme'] = 'ชื่อผู้ใช้ "Changeme"  เป็นคำสงวนท่านไม่สามารถใช้ชื่อนี้ได้';
$string['ipblocked'] = 'เว็บไซต์นี้ยังไม่เปิดใช้งาน';
$string['ipblocker'] = 'บล็อกหมายเลขไอพี';
$string['iplookup'] = 'ตรวจสอบหมายเลขไอพี';
$string['iplookupinfo'] = 'ค่าที่ตั้งไว้ของระบบคือให้ใช้ข้อมูลฟรีจาก NetGeo เพื่อค้นหาตำแหน่งที่ตั้งจากหมายเลขไอพี แต่ฐานข้อมูลดังกล่าวไม่มีผู้ดูแลแล้ว และอาจส่งผลที่ไม่ถูกต้อง ขอแนะนำให้ทำการติดตั้ง ฐานข้อมูลเมือง GeoLite  จาก MaxMind หมายเลขไอพีจะแสดงตำแหน่งที่ตั้งบนแผนที่กูเกิ้ล คุณจำเป็นต้องมีคีย์ของกูเกิ้ลAPI ซึ่งสามารถขอได้ฟรีจากเว็บไซต์กูเกิ้ล';
$string['iplookupmaxmindnote'] = 'มีข้อมูล GeoLite สร้างโดย MaxMind ซึ่งสามารถหาซื้อได้จาก <a href="http://www.maxmind.com/">http://www.maxmind.com/</a>';
$string['keeptagnamecase'] = 'รักษาตัวพิมพ์ใหญ่พิมพ์เล็กของชื่อ tag';
$string['lang'] = 'ภาษาที่ตั้งไว้';
$string['langcache'] = 'เก็บภาษาที่อยู่ในเมนูไว้ในความจำชั่วคราว';
$string['langlist'] = 'ภาษาที่ต้องการแสดงในเมนู';
$string['langmenu'] = 'แสดงเมนูภาษา';
$string['langpackwillbeupdated'] = 'สำหรับนักพัฒนาภาษา ในระหว่างการอัพเกรด moodle จะทำการอัพเดทไฟล์ภาษาของคุณ การเปลี่ยนแปลงของคุณที่ไม่ได้เป็นภาษาที่คุณปรับแก้เองจะถูกเขียนทับทั้งหมด';
$string['languagesettings'] = 'ตั้งค่าภาษา';
$string['latinexcelexport'] = 'encoding ของเอ็กเซล';
$string['localetext'] = 'locale สำหรับทั้งเว็บไซต์';
$string['localstringcustomization'] = 'การปรับแก้ภาษาสำหรับใช้ส่วนตัว';
$string['location'] = 'ที่ตั้ง';
$string['locationsettings'] = 'ตั้งค่าที่ตั้ง';
$string['log'] = 'บันทึกการใช้งานเว็บไซต์';
$string['loginhttps'] = 'ใช้ HTTPS สำหรับการเข้าสู่ระบบ';
$string['loglifetime'] = 'เก็บบันทึกการใช้งานไว้เป็นเวลา';
$string['longtimewarning'] = '<b> ขั้นตอนนี้อาจใช้เวลาในการประมวลผลนาน </b>';
$string['mailnewline'] = 'ขึ้นบรรทัดใหม่ในเมล';
$string['maintenancemode'] = 'อยู่ในโหมดซ่อมบำรุง';
$string['maintfileopenerror'] = 'มีข้อผิดพลาดในการเปิดไฟล์';
$string['maintinprogress'] = 'กำลังทำการซ่อมบำรุง';
$string['managelang'] = '<b>การจัดการภาษา</b>';
$string['manageqtypes'] = 'จัดการประเภทคำถาม';
$string['maxbytes'] = 'ขนาดไฟล์สูงสุดของการอัพโหลด';
$string['maxconsecutiveidentchars'] = 'จำนวนอักขระที่เหมือนกันเขียนติดกัน';
$string['maxeditingtime'] = 'เวลาสูงสุดที่จะแก้ไขโพสต์';
$string['mbstringrecommended'] = 'แนะนำให้ติดตั้ง MBSTRING library เพื่อช่วยให้เว็บไซต์ทำงานได้ดีขึ้นสำหรับเว็บที่ไม่ใช้งานภาษาละติน';
$string['mediapluginavi'] = 'เปิดการใช้งานฟิลเตอร์ .avi';
$string['mediapluginflv'] = 'เปิดการใช้งานฟิลเตอร์ .flv';
$string['mediapluginimg'] = 'เปิดการใช้งานการลิงก์รูปภาพอัตโนมัติ';
$string['mediapluginmov'] = 'เปิดการใช้งานฟิลเตอร์ .mov';
$string['mediapluginmp3'] = 'เปิดการใช้งานฟิลเตอร์ .mp3';
$string['mediapluginmpg'] = 'เปิดการใช้งานฟิลเตอร์ .mpg';
$string['mediapluginram'] = 'เปิดการใช้งานฟิลเตอร์ .ram';
$string['mediapluginrm'] = 'เปิดการใช้งานฟิลเตอร์ .rm';
$string['mediapluginrpm'] = 'เปิดการใช้งานฟิลเตอร์ .rpm';
$string['mediapluginswf'] = 'เปิดการใช้งานฟิลเตอร์ .swf';
$string['mediapluginswfnote'] = 'เพื่อความปลอดภัยสำหรับการใช้งาน ผู้ใช้งานปกติไม่ควรเปิดให้มีการใช้งาน .swf ไฟล์แฟลช';
$string['mediapluginwmv'] = 'เปิดการใช้งานฟิลเตอร์ .wmv';
$string['mediapluginyoutube'] = 'เปิดการใช้งานฟิลเตอร์ลิงก์  Youtube';
$string['messaging'] = 'เปิดใช้งานระบบส่งข้อความ';
$string['minpassworddigits'] = 'จำนวนตัวเลข';
$string['minpasswordlength'] = 'ความยาวของรหัสผ่าน';
$string['minpasswordlower'] = 'จำนวนตัวพิมพ์เล็ก';
$string['minpasswordnonalphanum'] = 'จำนวนอักขระพิเศษ';
$string['minpasswordupper'] = 'จำนวนตัวพิมพ์ใหญ่';
$string['misc'] = 'ข้อมูลอื่นๆ';
$string['mnetrestore_extusers'] = '<strong>หมายเหตุ:</strong> ไฟล์สำรองข้อมูลประกอบไปด้วยข้อมูลของบัญชีผู้ใช้งาน Moodle ทั้งเน็ตเวิร์กซึ่งจะทำการกู้คืนเป็นส่วนหนึ่งของกระบวนการ';
$string['mnetrestore_extusers_admin'] = '<strong>หมายเหตุ:</strong> ไฟล์สำรองที่มีอยู่มาจากการติดตั้ง moodle คนละครั้งกันและมีบัญชีผู้ใช้ remote moodle network อยู่ด้วย การกู้คืนนี้จะทำการจับคู่ Moodle Network hosts สำหรับสมาชิกทั้งหมด ในกรณีที่ไม่สามารถจับคู่ได้ระบบจะทำการเปลี่ยนไปยังการอนุมัติแบบภายใน (แทนที่ mnet) ดูรายละเอียได้จากบันทึกการกู้คืน';
$string['mnetrestore_extusers_mismatch'] = '<strong>หมายเหตุ:</strong> ไฟล์สำรองข้อมูลนี้ได้มาจากการติดตั้ง Moodle ที่ต่างกันประกอบไปด้วยชื่อสมาชิกภายในเน็ตเวิร์กซึ่งอาจไม่สามารถกู้คืนมาได้ ระบบไม่ได้สนับสนุนกระบวนการดังกล่าว หากแน่ใจว่าข้อมูลนี้ถูกสร้างขึ้นจากการติดตั้งในคราวนี้ หรือ มั่นใจว่าเน็ตเวิร์กของโฮสต์มีการตั้งค่าอย่างถูกต้องแล้ว ก็สามารถทดลองกู้คืนได้';
$string['mnetrestore_extusers_noadmin'] = '<strong>หมายเหตุ:</strong> ไฟล์สำรองที่มีอยู่มาจากการติดตั้ง moodle คนละครั้งกันและมีบัญชีผู้ใช้ remote moodle network อยู่ด้วย คุณไม่สามารถที่จะทำการกู้คืนไฟล์ลักษณะนี้ได้ กรุณาติดต่อผู้ดูแลระบบหรือทำการกู้คืนโดยไม่ใช้ข้อมูลสมาชิก';
$string['mnetrestore_extusers_switchuserauth'] = 'สมาชิก Remote Moodle Network  {$a->username} (มาจาก {$a->mnethosturl}) เปลี่ยนสถานะเป็น สมาชิกที่ได้รับการอนุมัติ  {$a->auth}';
$string['modeditdefaults'] = 'ค่าที่ตั้งไว้สำหรับการตั้งค่ากิจกรรม';
$string['modsettings'] = 'จัดการกิจกรรม';
$string['modulesecurity'] = 'ความปลอดภัยของโมดูล';
$string['multilangforceold'] = 'บังคับการใช้งาน syntax สำหรับการใช้งานหลายภาษา &lt;span&gt; class="multilang" และ &lt;lang&gt;';
$string['mustenablestats'] = 'ยังไม่มีการเปิดใช้งานสถิติสำหรับเว็บไซต์';
$string['mycoursesperpage'] = 'จำนวนรายวิชา';
$string['mymoodle'] = 'My Moodle';
$string['mymoodleredirect'] = 'บังคับให้สมาชิกใช้งาน My Moodle';
$string['navigationupgrade'] = 'การอัพเกรดนี้มีการเพิ่มบล็อคนำทางขึ้นมาอีกสองอันซึ่งมาแทนที่บล็อคต่อไปนี้ : การจัดการระบบ, รายวิชา, กิจกรรมและนักเรียน หากมีการตั้งค่าการอนุมัติเป็นกรณีพิเศษสำหรับบล็อคดังกล่าว ควรทำการตรวจสอบว่า บล็อคดังกล่าวยังคงทำงานอยู่เป็นปกติ คุณควรทำการกด "Shift-Refresh" บนบราวเซอร์เพื่อให้โหลดสไตล์ใหม่ เพื่อให้บล็อคใหม่แสดงผลอย่างถูกต้อง';
$string['nobookmarksforuser'] = 'ยังไม่ได้เพิ่ม "รายการโปรด"';
$string['nodatabase'] = 'ไม่มีฐานข้อมูล';
$string['nomissingstrings'] = 'ไม่มีข้อความใดหายไป';
$string['nonewsettings'] = 'ไม่มีการตั้งค่าใหม่ใด ๆ ระหว่างการอัพเกรดนี้';
$string['nonexistentbookmark'] = 'ไม่มีรายการโปรดที่คุณต้องการ';
$string['noreplyaddress'] = 'ที่อยู่สำหรับ No-Reply';
$string['noresults'] = 'ไม่พบผลลัพธ์';
$string['noroles'] = 'ไม่มีบทบาท';
$string['notifications'] = 'การแจ้งเตือน';
$string['notifyloginfailures'] = 'อีเมลแจ้งการเข้าระบบล้มเหลวแก่';
$string['notifyloginthreshold'] = 'จำนวนครั้งสูงสุดก่อนทำการอีเมล';
$string['notloggedinroleid'] = 'สิทธิสำหรับผู้เยี่ยมชม';
$string['numberofmissingstrings'] = 'จำนวนของข้อความที่หายไป :  {$a} ข้อความ';
$string['numberofstrings'] = 'จำนวนข้อความทั้งหมด: {$a->strings}  ข้อความ<br />หายไป: {$a->missing}  ข้อความ  คิดเป็น({$a->missingpercent}&nbsp;%)';
$string['opensslrecommended'] = 'แนะนำให้ทำการติดตั้ง OpenSSL library เพื่อให้ Moodle ทำงานในระบบเน็ตเวิร์กได้ดีขึ้น';
$string['opentogoogle'] = 'เปิดให้ Google เข้ามาเก็บข้อมูลได้อย่างอิสระ';
$string['optionalmaintenancemessage'] = 'ข้อความสำหรับการบำรุงรักษา';
$string['order1'] = '1';
$string['order2'] = '2';
$string['order3'] = '3';
$string['order4'] = '4';
$string['passwordpolicy'] = 'ข้อตกลงในการเลือกรหัสผ่าน';
$string['pathtodu'] = 'Path ของ du';
$string['pathtopgdump'] = 'Path ไปยัง pg_dump';
$string['pathtopgdumpdesc'] = 'จำเป็นในกรณีที่ท่านมี pg_dump มากกว่าหนึ่งในระบบ (ยกตัวอย่างเช่นมีการติดตั้ง postgresql มากกว่าหนึ่งเวอร์ชัน)';
$string['pathtopgdumpinvalid'] = 'path ของ pg_dump ไม่ถูกต้องหรือไม่สามารถกระทำการใดได้';
$string['pathtopsql'] = 'path ของ psql';
$string['pathtopsqldesc'] = 'ถ้าหากท่านมี psql มากกว่าหนึ่งในเซิร์ฟเวอร์ (เช่น ติดตั้งไว้หลายเวอร์ชั่น ) จำเป็นที่ต้องเติมค่านี้';
$string['pathtopsqlinvalid'] = 'path ของ psql ไม่ถูกต้อง อาจเป็นเพราะ path ไม่ถูกต้องหรือไม่สามารถ execute ได้';
$string['perfdebug'] = 'ข้อมูลการทำงานของระบบ';
$string['performance'] = 'การทำงานของระบบ';
$string['pgcluster'] = 'PostgreSQL Cluster';
$string['pgclusterdescription'] = 'เวอร์ชันของ PostgreSQL และ ค่าตัวแปรคลัสเตอร์สำหรับการออกคำสั่ง ถ้าหากท่านมีฐานข้อมูล PostgreSQL เพียงอันเดียวในระบบ หรือไม่มั่นใจให้ละค่านี้ไว้';
$string['phpfloatproblem'] = 'พบปัญหาในการจัดการกับ float numbers ใน PHP ข {$a}';
$string['pleaserefreshregistration'] = 'เว็บไซต์ของคุณได้รับการลงทะเบียนกับ moodle.org เรียบร้อยแล้ว กรุณาอัพเทดข้อมูลหากมีการเปลี่ยนแปลงไปจากครั้งล่าสุด เมื่อ {$a}';
$string['plugins'] = 'จัดการโมดูล';
$string['profilecategory'] = 'ประเภท';
$string['profilecategoryname'] = 'ชื่อประเภท';
$string['profilecategorynamenotunique'] = 'มีการใช้งานชื่อนี้ก่อนหน้าแล้ว';
$string['profilecommonsettings'] = 'การตั้งค่าทั่วไป';
$string['profileconfirmcategorydeletion'] = 'มีจำนวนฟิลด์อยู่  {$a} ฟิล์ดในประเภทนี้ที่ต้องย้ายไปยังประเภทข้างบน (หรือข้างล่างหากประเภทดังกล่าวอยู่บนสุด)  ต้องการลบประเภทนี้หรือไม่ ?';
$string['profileconfirmfielddeletion'] = 'มีข้อมูลสมาชิกอยู่  {$a} รายการสำหรับฟิลด์นี้ที่ต้องถูกลบทิ้ง ท่านต้องการลบฟิลด์นี้หรือไม่ ?';
$string['profilecreatecategory'] = 'สร้างประเภทใหม่สำหรับประวัติส่วนตัว';
$string['profilecreatefield'] = 'สร้างฟิลด์ใหม่สำหรับประวัติส่วนตัว';
$string['profilecreatenewcategory'] = 'สร้างประเภทใหม่';
$string['profilecreatenewfield'] = 'สร้าง &quot;{$a}&quot; ใหม่สำหรับฟิลด์ประวัติส่วนตัว';
$string['profiledefaultcategory'] = 'ฟิลด์อื่น ๆ';
$string['profiledefaultchecked'] = 'ตรวจสอบตามค่าที่ตั้งไว้';
$string['profiledefaultdata'] = 'ค่าที่ตั้งไว้';
$string['profiledeletecategory'] = 'ลบประเภท';
$string['profiledeletefield'] = 'ลบประเภท';
$string['profiledescription'] = 'คำอธิบายของฟิลด์';
$string['profileeditcategory'] = 'แก้ไขประเภท: {$a}';
$string['profileeditfield'] = 'แก้ไขฟิลด์ : {$a}';
$string['profilefield'] = 'ฟิลด์ประวัติส่วนตัว';
$string['profilefieldcolumns'] = 'คอลัมน์';
$string['profilefieldispassword'] = 'ในฟิลด์รหัสผ่านหรือไม่ ?';
$string['profilefieldlink'] = 'ลิงก์';
$string['profilefieldlinktarget'] = 'ลิงก์ target';
$string['profilefieldmaxlength'] = 'ความยาวสูงสุด';
$string['profilefieldrows'] = 'แถว';
$string['profilefields'] = 'ฟิลด์ประวัติส่วนตัว';
$string['profilefieldsize'] = 'ขนาดที่ต้องการแสดง';
$string['profileforceunique'] = 'ควรให้ข้อมูลเป็นค่าเฉพาะหรือไม่ ?';
$string['profileinvaliddata'] = 'ค่าไม่ถูกต้อง';
$string['profilelocked'] = 'ล็อคฟิลด์นี้หรือไม่';
$string['profilemenudefaultnotinoptions'] = 'ค่าที่ตั้งไว้ไม่ได้อยู่ในกลุ่มตัวเลือก';
$string['profilemenunooptions'] = 'ไม่มีตัวเลือกในเมนู';
$string['profilemenuoptions'] = 'ตัวเลือก (หนึ่งตัวเลือกต่อบรรทัด)';
$string['profilemenutoofewoptions'] = 'ต้องใส่อย่างน้อย 2 ตัวเลือก';
$string['profilename'] = 'ชื่อ';
$string['profilenofieldsdefined'] = 'ยังไม่ได้ระบุฟิลด์';
$string['profilerequired'] = 'จำเป็นต้องกรอกหรือไม่';
$string['profilesforenrolledusersonly'] = 'ประวัติสำหรับสมาชิกที่สมัครเข้าเรียนแล้วเท่านั้น';
$string['profileshortname'] = 'ชื่อย่อ';
$string['profileshortnamenotunique'] = 'มีการใช้งานชื่อนี้ไปแล้ว';
$string['profilesignup'] = 'แสดงหน้าการสมัครใช้งาน';
$string['profilespecificsettings'] = 'การตั้งค่าเฉพาะ';
$string['profilevisible'] = 'ต้องการแสดงฟิลด์นี้แก่';
$string['profilevisibleall'] = 'ทุกคน';
$string['profilevisiblenone'] = 'ไม่ให้ใครเห็น';
$string['profilevisibleprivate'] = 'สมาชิกเท่านั้น';
$string['protectusernames'] = 'ป้องกันชื่อผู้ใช้';
$string['proxybypass'] = 'โฮสต์พร็อกซี่บายพาส';
$string['proxyhost'] = 'โฮสต์พร็อกซี';
$string['proxypassword'] = 'รหัสผ่านพร็อกซี';
$string['proxyport'] = 'พอร์ทพร็อกซี';
$string['proxytype'] = 'ประเภทพร็อกซี่';
$string['proxyuser'] = 'ชื่อผู้ใช้ของพร็อกซี่';
$string['question'] = 'คำถาม';
$string['questioncwqpfscheck'] = 'มีคำถามสุ่มหนึ่งข้อหรือกว่านั้นในแบบทดสอบที่มีการตั้งค่าให้เลือกคำถามจากคลังคำถามในประเภทที่มีการแชร์และไม่แชร์ ข้อมูลอย่างละเอียดมีดังนี้ <a href="{$a->reporturl}">รายละเอียด</a> และให้ดูเพิ่มเติมจากหน้า Moodle Docs <a href="{$a->docsurl}">รายละเอียดเพิ่มเติม</a>';
$string['questioncwqpfsok'] = 'ดีมากค่ะ แบบทดสอบของคุณไม่มีคำถามแบบสุ่มที่ต้องเลือกจากคลังที่มีการแชร์และไม่แชร์';
$string['questiontype'] = 'ประเภทคำถาม';
$string['questiontypes'] = 'ประเภทคำถาม';
$string['recaptchaprivatekey'] = 'ReCAPTCHA private key';
$string['recaptchapublickey'] = 'ReCAPTCHA public key';
$string['registration'] = 'ลงทะเบียน';
$string['releasenoteslink'] = 'สำหรับข้อมูลเพิ่มเติมเกี่ยวกับมูเดิ้ลเวอร์ชันนี้ กรุณาอ่านเพิ่มจาก <a target="_new" href="{$a}">Release Notes</a>';
$string['requiredentrieschanged'] = '<strong>ข้อควรรู้ - กรุณาอ่าน<br/>(ข้อความนี้จะปรากฎเฉพาะช่วงที่ทำการอัพเกรด)</strong><br/>เนื่องจากมีการแก้ไขช่องโหว่ต่าง ๆ ฐานข้อมูลที่มีการตั้งค่า \'Required entries\' และ \'Required entries before viewing settings\' จะเปลี่ยนแปลงไป รายละเอียดสามารถดูได้จาก <a href="http://moodle.org/mod/forum/discuss.php?d=110928" target="_blank">กระดานเสวนาโมดูลฐานข้อมูล</a> ผลจากการเปลี่ยนแปลงนี้สามารถอ่านรายละเอียดจาก <a href="http://docs.moodle.org/en/Adding/editing_a_database#Required_entries" target="_blank">Moodle Docs</a>.
<br/><br/>การเปลี่ยนแปลงนี้จะมีผลเฉพาะฐานข้อมูลต่อไปนี้ในระบบของคุณ: (กรุณาบันทึกรายการต่อนี้เอาไว้และทำการตรวจสอบว่าข้อมูลดังกล่าวยังอยู่ครบหรือไม่)<br/><strong>{$a->text}</strong><br/>';
$string['requiremodintro'] = 'รายละเอียดกิจกรรมที่ต้องการ';
$string['requires'] = 'ความต้องการ';
$string['reverseproxy'] = 'Reverse proxy';
$string['riskconfig'] = 'สมาชิกสามารถเปลี่ยนแปลงการตั้งค่าของเว็บไซต์และการแสดงผลของเว็บไซต์';
$string['riskconfigshort'] = 'ความเสี่ยงของการตั้งค่า';
$string['riskdataloss'] = 'สมาชิกสามารถลบเนื้อหาหรือข้อมูลจำนวนมาก';
$string['riskdatalossshort'] = 'ความเสี่ยงที่ข้อมูลจะสูญหาย';
$string['riskmanagetrust'] = 'สมาชิกสามารถเปลี่ยนค่าความน่าเชื่อถือของสมาชิกอื่น';
$string['riskmanagetrustshort'] = 'จัดการความน่าเชื่อถือ';
$string['riskpersonal'] = 'สมาชิกสามารถเข้าไปยังข้อมูลส่วนตัวของสมาชิกอื่น';
$string['riskpersonalshort'] = 'ความเสี่ยงด้านความเป็นส่วนตัว';
$string['riskspam'] = 'สมาชิกสามารถส่ง spam ไปยังสมาชิกทั้งเว็บไซต์และบุคคลอื่น';
$string['riskspamshort'] = 'ความเสี่ยงของ Spam';
$string['riskxss'] = 'สมาชิกสามารถเพิ่มไฟล์และข้อความที่สามารถใช้งาน cross-site scripting (XSS)';
$string['riskxssshort'] = 'ความเสี่ยงของ XSS';
$string['roleswithexceptions'] = '{$a->roles}  พร้อมกับ {$a->exceptions}';
$string['rssglobaldisabled'] = 'ปิดการใช้งานในระดับเซิร์ฟเวอร์';
$string['save'] = 'บันทึก';
$string['savechanges'] = 'บันทึกการเปลี่ยนแปลง';
$string['search'] = 'ค้นหา';
$string['searchinsettings'] = 'ค้นหาในการตั้งค่า';
$string['searchresults'] = 'ผลลัพธ์ของการค้นหา';
$string['sectionerror'] = 'มีข้อผิดพลาดในส่วนนี้ !';
$string['secureforms'] = 'ใช้แบบฟอร์มที่มีความปลอดภัยสูง';
$string['security'] = 'ความปลอดภัย';
$string['server'] = 'เซิร์ฟเวอร์';
$string['serverchecks'] = 'ตรวจสอบเวิร์ฟเวอร์';
$string['serverlimit'] = 'ข้อจำกัดของเซิร์ฟเวอร์';
$string['sessioncookie'] = 'คำนำหน้า cookies';
$string['sessioncookiedomain'] = 'โดเมน cookies';
$string['sessioncookiepath'] = 'path ของ cookies';
$string['sessionhandling'] = 'เซสชัน Cookies';
$string['sessiontimeout'] = 'หมดเวลา';
$string['settingfileuploads'] = 'กรุณาเปิดการใช้งาน php File uploading เพราะจำเป็นสำหรับการทำงานทั่วไป';
$string['settingmemorylimit'] = 'พบปัญหา หน่วยความจำไม่เพียงพอ กรุณาตั้งค่า memory limit ใน php ให้สูงขึ้น';
$string['settingsafemode'] = 'Moodle ไม่สามารถทำงานภายใต้ Safe mode กรุณาแจ้งให้ผู้ดูแลระบบปิดการใช้งานโหมดดังกล่าว';
$string['showdetails'] = 'แสดงรายละเอียด';
$string['simplexmlrequired'] = 'จำเป็นต้องเปิดการใช้งาน  SimpleXML PHP extension';
$string['sitemailcharset'] = 'ชุดอักขระ';
$string['sitemaintenance'] = 'เว็บไซต์นี้กำลังอยู่ระหว่างการปรับปรุง กรุณากลับเข้ามาใหม่ค่ะ';
$string['sitemaintenancemode'] = 'โหมดบำรุงรักษา';
$string['sitemaintenanceoff'] = 'ปิดการใช้งานโหมดบำรุงรักษาและใช้งานเว็บไซต์ตามปกติ';
$string['sitemaintenanceon'] = 'เว็บไซต์ของท่านอยู่ในโหมดบำรุงรักษา (เฉพาะผู้ดูแลระบบเท่านั้นที่จะสามารถเข้าสู่ระบบได้)';
$string['sitemaintenancewarning'] = 'เว็บไซต์ของท่านอยู่ในโหมดบำรุงรักษา (เฉพาะผู้ดูแลระบบเท่านั้นที่จะสามารถเข้าสู่ระบบได้) หากต้องการใช้งานเว็บไซต์ตามปกติให้ <a href="maintenance.php">ปิดการใช้งาน</a>';
$string['sitemaintenancewarning2'] = 'ขณะนี้กำลังทำการปรับปรุงเว็บไซต์อยู่ค่ะ (เฉพาะผู้ดูแลระบบเท่านั้นที่สามารถเข้าสู่ระบบได้)  หากต้องการกลับเข้าสู่เว็บปกติ ให้ทำการ <a href="{$a}">ปิดการใช้งานโหมดซ่อมบำรุง</a>.';
$string['sitepolicies'] = 'ข้อตกลงการใช้งานเว็บไซต์';
$string['sitepolicy'] = 'ข้อตกลงการใช้งานเว็บไซต์  URL';
$string['sitepolicy_help'] = 'ถ้าหากมีข้อตกลงการใช้งานที่สมาชิกต้องอ่านก่อนที่จะสมัครให้ใส่ URL ของข้อตกลงนั้นที่นี่ หรือไม่ให้ปล่อยว่างไว้';
$string['sitesectionhelp'] = 'หัวข้อที่ถูกเลือก จะแสดงในหน้าแรกของเว็บไซต์';
$string['slasharguments'] = 'ใช้ slash arguments';
$string['smartpix'] = 'ค้นหารูปภาพ';
$string['smtphosts'] = 'โฮสต์ SMTP';
$string['smtpmaxbulk'] = 'จำนวนสูงสุดของ SMTP เซสชัน';
$string['smtppass'] = 'รหัสผ่าน SMTP';
$string['smtpuser'] = 'ชื่อผู้ใช้ SMTP';
$string['stats'] = 'สถิติ';
$string['statsfirstrun'] = 'จำนวนงานที่กำลังถูกประมวลผลสูงสุดในแต่ละรอบ';
$string['statsmaxruntime'] = 'เวลาประมวลผลสูงสุด';
$string['statsruntimedays'] = 'จำนวนวันประมวลผล';
$string['statsruntimestart'] = 'ประมวลผลที่';
$string['statsuserthreshold'] = 'จำนวนสูงสุด';
$string['stickyblocks'] = 'บล็อคบังคับ';
$string['stickyblockscourseview'] = 'หน้ารายวิชา';
$string['stickyblocksduplicatenotice'] = 'ถ้าหากบล็อคที่คุณเพิ่มลงไปนี้อยู่ในหน้าใดหน้าหนึ่งอยู่ก่อนแล้ว จะทำให้เกิดการซ้ำซ้อนเกิดขึ้น บล็อคที่บังคับให้แสดงนี้จะไม่สามารถแก้ไขได้  แต่บล็อคที่ซ้ำซ้อนจะยังทำการแก้ไขได้';
$string['stickyblocksmymoodle'] = 'My Moodle';
$string['stickyblockspagetype'] = 'ประเภทของหน้าที่ต้องการตั้งค่า';
$string['stripalltitletags'] = 'เอาแท็ก html ออกจากชื่อกิจกรรม';
$string['supportemail'] = 'อีเมลเจ้าหน้าที่';
$string['supportname'] = 'ชื่อเจ้าหน้าที่';
$string['supportpage'] = 'หน้าสนับสนุนการใช้งาน';
$string['switchlang'] = 'เปลี่ยนไดเรกทอรีของภาษา';
$string['systempaths'] = 'Path ของระบบ';
$string['tabselectedtofront'] = 'ในตารางที่มีแท็บ  ควรให้แถวที่มีแท็กที่เลือกไว้แสดงอยู่ด้านหน้าหรือไม่';
$string['tabselectedtofronttext'] = 'แสดงแท็บที่เลือกด้านหน้า';
$string['themelist'] = 'รายการรูปแบบเว็บ';
$string['themeselector'] = 'เลือกรูปแบบเว็บ';
$string['themesettings'] = 'ตั้งค่ารูปแบบเว็บ';
$string['therewereerrors'] = 'ข้อมูลผิดพลาด';
$string['timezone'] = 'โซนเวลาเริ่มต้น';
$string['timezoneforced'] = 'ผู้ดูแลระบบทำการบังคับการใช้งานโซนเวลา';
$string['timezoneisforcedto'] = 'บังคับสมาชิกทุกคนใช้โซนเวลานี้';
$string['timezonenotforced'] = 'สมาชิกสามารถเลือกโซนเวลาของตนได้';
$string['tokenizerrecommended'] = 'ระบบแนะนำให้ติดตั้ง PHP Tokenizer extension เพื่อพัฒนาความสามารถในการ ทำงานในระบบเน็ตเวิร์กได้ดีขึ้น';
$string['unattendedoperation'] = 'กระบวนการที่ไม่มีการดูแล';
$string['unbookmarkthispage'] = 'ลบรายการโปรด';
$string['unicoderequired'] = 'ระบบนี้จำเป็นที่ต้องเก็บข้อมูลไว้ในรูปแบบ unicode (UTF-8 ) ในการติดตั้งใหม่ควรตั้งค่าชุดอักขระของฐานข้อมูลเป็น unicode ในกรณีที่ทำการอัพเกรดควรทำการเปลี่ยนชุดอักขระเดิมให้เป็น UTF-8 (ดูรายละเอียดใน ผู้ดูแลระบบ)';
$string['unsupported'] = 'ไม่สนับสนุน';
$string['updateaccounts'] = 'อัพเดทบัญชีผู้ใช้ที่มีอยู่';
$string['updatecomponent'] = 'อัพเดทคอมโพเนนท์';
$string['upgradeerror'] = 'มีข้อผิดพลาด ในการอัพเกรดจากเวอร์ชัน {$a->plugin} เป็น version {$a->version} ไม่สามารถไปขั้นต่อไปได้';
$string['upgradeforumread'] = 'มีการเพิ่มฟังก์ชันใหม่ลงใน Moodle 1.5 นั้นคือสามารถที่จะตรวจกระทู้ โพสต์ที่ได้อ่านไปแล้วหรือยังไม่ได้อ่าน หากต้องการใช้งานฟังก์ชันนี้ให้ทำการ <a href="{$a}">อัพเดทตาราง </a>';
$string['upgradeforumreadinfo'] = 'มีการเพิ่มฟังก์ชันใหม่ลงใน Moodle 1.5 นั้นคือสามารถที่จะตรวจกระทู้ โพสต์ที่ได้อ่านไปแล้วหรือยังไม่ได้อ่าน หากต้องการใช้งานฟังก์ชันนี้คุณต้องทำการอัพเดทตารางพร้อมทั้งข้อมูลการอ่านโพสต์ต่างๆ เวลาที่ใช้ในการอัพเดทนั้นขึ้นอยู่กับขนาดของเว็บไซต์ของท่านซึ่งอาจใช้เวลาเป็นชั่วโมงเพราะฐานข้อมูลอาจมีขนาดใหญ่ ควรเลือกอัพเดทในเวลาที่ไม่ค่อยมีผู้ใช้งานเว็บไซต์แล้วอย่างไรก็ตาม สมาชิกยังสามารถใช้งานเว็บไซต์ได้ตามปกติในระหว่างการอัพเดทนี้ หากเริ่มต้นทำการอัพเดทแล้วควรปล่อยให้ระบบทำงานจนสำเร็จจากนั้นจึงปิดหน้าต่าง แต่หากทำการปิดไปก่อนหน้าที่จะเสร็จสิ้นก็สามารถที่จะทำการเริ่มต้นใหม่ได้ภายหลัง <br /><br /> ต้องการเริ่มต้นอัพเกรดหรือยังคะ ?';
$string['upgradelogs'] = 'เพื่อให้เว็บไซต์ทำงานได้ตามปกติคุณควรจะทำการอัพเกรดบันทึกการใช้งานเว็บไซต์ <a href="{$a}"> อ่านเพิ่มเติม </a>';
$string['upgradelogsinfo'] = 'มีการเปลี่ยนแปลงวิธีการเก็บไฟล์บันทึกการใช้งานเว็บไซต์เมื่อไม่นานนี้ ถ้าหากคุณต้องการดูบันทึกการใช้งานเก่าที่เก็บไว้คุณควรจะทำการอัพเกรดบันทึกนี้เสียก่อน ส่วนเวลาที่ใช้จะนานหรือไม่ขึ้นอยู่กับขนาดของเว็บไซต์ และขนาดของฐานข้อมูลที่มีอยู่ อาจจะใช้เวลาเป็นชั่วโมงก็ได้ ในการอัพเกรดเมื่อเริ่มอัพเกรดแล้วให้เปิดหน้าจอนี้ทิ้งไว้จนกว่าจะเสร็จสิ้นกระบวนการ สมาชิกอื่น ๆ ก็ยังสามารถใช้เว็บไซต์ได้ตามปกติในช่วงระยะเวลานี้ <b> คุณต้องการอัพเกรดบันทึกการใช้งานเว็บไซต์ตอนนี้เลยหรือเปล่าคะ ?</b>';
$string['upgradesettings'] = 'ตั้งค่าใหม่';
$string['upgradesettingsintro'] = 'การตั้งค่าที่แสดงอยู่ด้านล่างนี้ เป็นผลจากการอัพเกรด Moodle ครั้งล่าสุด ให้ทำการเปลี่ยนแปลงค่าต่าง ๆ ตามความเหมาะสมจากนั้นคลิก "บันทึกการเปลี่ยนแปลง"';
$string['upgradesure'] = 'มีการเปลี่ยนแปลงไฟล์ใน Moodle โปรแกรมจะทำการอัพเกรดเซิร์ฟเวอร์ของคุณเป็นเวอร์ชั่น<p><b>{$a}</b> อัตโนมัติ</p> <p>หลังจากอัพเกรดแล้วคุณไม่สามารถกลับไปใช้เวอร์ชั่นเดิมได้นะคะ</p> <p>แน่ใจหรือเปล่าคะว่าต้องการอัพเกรดเซิร์ฟเวอร์ด้วยเวอร์ชั่นใหม่ <p>';
$string['upgradetimedout'] = 'หมดเวลาในการอัพเกรพ กรุณาเริ่มต้นใหม่อีกครั้ง';
$string['upgradingdata'] = 'อัพเกรดข้อมูล';
$string['upgradinglogs'] = 'อัพเกรดบันทึกการใช้งานเว็บไซต์';
$string['upgradingversion'] = 'อัพเกรดเป็นเวอร์ชันใหม่';
$string['upwards'] = 'ขึ้นไป';
$string['useblogassociations'] = 'เปิดการใช้งานบล็อกที่เกี่ยวข้อง';
$string['useexternalyui'] = 'ใช้ไลบราลี YUI  ออนไลน์';
$string['user'] = 'สมาชิก';
$string['userbulk'] = 'การปฎิบัติการกับสมาชิกหลายคนในคราวเดียว';
$string['userlist'] = 'รายชื่อสมาชิก';
$string['userpolicies'] = 'ข้อตกลงการเป็นสมาชิก';
$string['users'] = 'สมาชิก';
$string['usetags'] = 'เปิดการใช้งานฟังก์ชันแท็ก';
$string['validateerror'] = 'ค่าต่อไปนี้ไม่ถูกต้อง:';
$string['verifychangedemail'] = 'จำกัดโดเมนเมื่อเปลี่ยนอีเมล';
$string['warningcurrentsetting'] = 'ค่าปัจจุบันไม่ถูกต้อง : {$a}';
$string['webproxy'] = 'เว็บพร็อกซี่';
$string['webproxyinfo'] = 'เติมค่าต่อไปนี้ในกรณีที่ไม่สามารถใช้งานอินเทอร์เน็ตได้โดยตรง การเชื่อมต่ออินเทอร์เน็ตมีความจำเป็นในการดาวน์โหลดข้อมูล อาทิ ภาษาต่าง ๆ , การป้อนข่าวสาร RSS, ตั้งค่าโซนเวลา ฯลฯ <br /><em>ควรเปิดใช้งาน PHP cURL extension เป็นอย่างยิ่ง</em>';
$string['ziprequired'] = 'ต้องเปิดการใช้งาน Zip PHP extension ส่วนค่า  info-ZIP binaries หรือ PclZip library ไม่จำเป็นอีกต่อไป';
