( function( $ ) {
/* ---------------------------------------------------------------- */
/* Twitter widget
/* ---------------------------------------------------------------- */
	var $twitterWidgets = $('.mpc-w-twitter-wrap'),
			twitterScript = '<script async src="//platform.twitter.com/widgets.js" charset="utf-8"></script>',
			widgetApplied;

	$twitterWidgets.each(function() {
		var $this = $(this);
		var unique = $this.attr('data-unique'),
			id = $this.attr('data-id'),
			number = $this.attr('data-number'),
			style = $this.attr('data-style'),
			transparent,
			isLinkCorrect;
			
		if(style == 'light' || style == 'dark'){
			transparent = false;
		}else{
			transparent = true;
		}

		isLinkCorrect = id.includes('https://twitter.com/'); 
		if( isLinkCorrect ){
			// new widget
			$this.append(
				'<a class="twitter-timeline"'
				+ ' data-height="205"' 
				+ (( !transparent ) ? ' data-theme="' + style + '"' : '')
				//+ ' data-link-color="#19CF86"'				
				+ ' href="' + id + '"'
				+ ((number !== '') ? ' data-tweet-limit="' + number + '"' : '') 
				+ ' data-chrome="nofooter noheader'
				+ (( transparent ) ? ' transparent' : '')
				+ '">'
				+ '>Tweets in Blaszok</a>'
				);
			if(widgetApplied !== true){
				$this.append(twitterScript);
			}
			widgetApplied = true;
		}else{
			$this.append('Make sure that you have provided correct <strong>Link to Twitter Timeline</strong> in Appearance->Widgets->MPC - Latest Tweets </br> It should look like this: https://twitter.com/mpcreation');
		}
	});
} )( jQuery );