<?php

// Admin bar notify
add_action( 'admin_bar_menu', 'mpcth_maintenance_toolbar', 999 );
function mpcth_maintenance_toolbar( $wp_admin_bar ) {
	global $mpcth_options;
	
	if( $mpcth_options['mpcth_enable_maintenance'] ) {
		$args = array(
			'id'    => 'mpcth_maintenance',
			'title' => __( 'Maintenance: ENABLED', 'mpc-ex' ),
			'href'  => '',
			'meta'  => array( 'class' => 'mpcth-maintenance-active' )
		);
		
		$wp_admin_bar->add_node( $args );
	}
}

// Redirect to homepage
add_action( 'template_redirect', 'mpcth_maintenance_template', 99 );
function mpcth_maintenance_template( ) {
	global $mpcth_options;	
	
	$url = ( is_ssl() ) ? 'https://' : 'http://';	
	$url .= $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
	
	$mpcth_is_front = ( $url === home_url('/') || $url === home_url() ) ? true : false;
	
	if( $mpcth_options['mpcth_enable_maintenance'] && !current_user_can('manage_options') && !$mpcth_is_front ) 
		wp_redirect( home_url() );
	
	return;
}

// Replace the page ID before query
add_action('pre_get_posts', 'mpcth_maintenance_pre_get_posts', 999);
function mpcth_maintenance_pre_get_posts( $query ) {
	global $mpcth_options;
	
	if( $mpcth_options['mpcth_enable_maintenance'] && !current_user_can('manage_options') && $query->is_main_query()) {
		$query->query_vars = array();
		$query->query_vars['p'] = $mpcth_options['mpcth_maintenance_page'];
	}
	
	return $query;
}
	
// Add body class to work as Fullwidth template
function mpcth_maintenance_classes( $classes ) {      
	$classes[] = 'page-template-template-fullwidth-php mpcth-sidebar-none';
	
    return $classes;
}
add_filter( 'template_include', 'portfolio_page_template', 99 );
function portfolio_page_template( $template ) {
	$maintenance = locate_template( array( 'template-maintenance.php' ) );
	if( $template == $maintenance ) 
		add_filter('body_class', 'mpcth_maintenance_classes');

	return $template;
}
