<?php
/* Register badge custom post type */
add_action('init', 'mpc_ex_badge');
function mpc_ex_badge() {
	$labels = array(
		'name' => __('Lookbook Badges', 'mpc-ex'),
		'singular_name' => __('Lookbook Badge', 'mpc-ex'),
		'all_items' => __('Badges', 'mpc-ex'),
		'add_new_item' => __('Add New Badge', 'mpc-ex'),
		'edit_item' => __('Edit Badge', 'mpc-ex'),
		'new_item' => __('New Badge', 'mpc-ex'),
		'view_item' => __('View Badge', 'mpc-ex'),
		'search_items' => __('Search Badges', 'mpc-ex'),
		'not_found' => __('No Badges found', 'mpc-ex'),
		'not_found_in_trash' => __('No Badges found in Trash', 'mpc-ex')
	);

	$grid_args = array(
		'labels' => $labels,
		'public' => false,
		'show_ui' => true,
		'exclude_from_search' => true,
		'menu_icon' => 'dashicons-awards',
		'capability_type' => 'post',
		'hierarchical' => false,
		'supports' => array('title'),
	);

	register_post_type('mpc_badge', $grid_args);
}

/* Register mpc_rev_badge shortcode */
function mpc_rev_badge_shortcode( $atts ) {
	$id = 0; $return = $css = '';
	extract( shortcode_atts( array(
		'id'    => '',
	), $atts ) );

	if( $id === 0 )
		return;

	$badge_style	  = get_post_meta( $id, 'mpcth_badge_style', true );
	$badge_products   = get_post_meta( $id, 'mpcth_lookbook_products', true );

	if( !is_array( $badge_products ) )
		return;

	$font_color		  = get_post_meta( $id, 'mpcth_badge_color', true );
	$font_color_hover = get_post_meta( $id, 'mpcth_badge_color_hover', true );

	$bg_color		  = get_post_meta( $id, 'mpcth_badge_bg', true );
	$bg_color_opacity = get_post_meta( $id, 'mpcth_badge_bg_opacity', true );
	$bg_color = (function_exists( 'mpcth_hex_to_rgba' ) && $badge_style !== 'circle') ? mpcth_hex_to_rgba( $bg_color, $bg_color_opacity / 100 ) : $bg_color;
	if( is_array( $bg_color ) )
			$bg_color = 'rgba(' . implode( ',', $bg_color ) . ')';

	$css_id = 'mpc-' . mpcth_random_ID();

	if( $badge_style !== 'circle' )
		$css .= '#' . $css_id . '.mpcth-rev-badge{background:' . $bg_color . ';}';

	$css .= '#' . $css_id . '.mpcth-rev-badge a{color:' . $font_color . ';}#' . $css_id . '.mpcth-rev-badge a:hover{color:' . $font_color_hover . ';}';

	if( $badge_style === 'dropdown') {
		$bar_font_color = get_post_meta( $id, 'mpcth_badge_bar_color', true );
		$bar_bg_color = get_post_meta( $id, 'mpcth_badge_bar_bg', true );
                $dropdown_position = get_post_meta( $id, 'mpcth_badge_drodpown_position', true );

		$css .= '#' . $css_id . '.mpcth-rev-badge.mpcth-badge-dropdown .mpcth-badge-toggle{background:' . $bar_bg_color . ';color:' . $bar_font_color . ';}';
                $css .= '#' . $css_id . '.mpcth-rev-badge.mpcth-badge-dropdown .mpcth-badge-content-wrap{background:' . $bg_color . ';}';
        }

	if( $badge_style === 'circle') {
		$border_color = get_post_meta( $id, 'mpcth_badge_border', true );
		$border_opacity = get_post_meta( $id, 'mpcth_badge_border_opacity', true );
		$border_color = function_exists( 'mpcth_hex_to_rgba' ) ? mpcth_hex_to_rgba( $border_color, $border_opacity / 100 ) : $border_color;

		if( is_array( $border_color ) )
			$border_color = 'rgba(' . implode( ',', $border_color ) . ')';

		$css .= '#' . $css_id . '.mpcth-rev-badge.mpcth-badge-circle .mpcth-badge-toggle,#' . $css_id . '.mpcth-rev-badge.mpcth-badge-circle .mpcth-badge-content{color:' . $font_color . ';background:' . $bg_color . ';}';
		$css .= '#' . $css_id . '.mpcth-rev-badge.mpcth-badge-circle .mpcth-badge-toggle-wrap{background:' . $border_color .';}';
		$css .= '#' . $css_id . '.mpcth-rev-badge.mpcth-badge-circle .mpcth-badge-content-wrap{background:' . $border_color . ';}';
	}

	$badge_content = '';
	foreach( $badge_products as $product_id ) {

		$product = wc_get_product( $product_id );

		if( !is_object( $product ) ) {
			return '';
		}

		$badge_content .= '<a href="' . get_permalink( $product_id ) . '"><span>' . $product->get_title() . ',</span> ' . $product->get_price_html() . '</a>';
	}

	$return .= '<div id="' . $css_id . '" class="mpcth-rev-badge mpcth-badge-' . $badge_style . ' ' . (isset( $dropdown_position ) ? 'mpcth-dropdown-' . $dropdown_position : 'mpcth-dropdown-bottom') . '">';
		if( $badge_style != 'default' ) {
			$return .= '<div class="mpcth-badge-toggle-wrap"><div class="mpcth-badge-toggle">';
				$return .= $badge_style == 'dropdown' ? '<i class="fa fa-tag"></i>' . __( 'Shop this look', 'mpc-ex' ) : '<i class="fa fa-shopping-cart"></i>';
			$return .= '</div></div>';
		}
		$return .= '<div class="mpcth-badge-content-wrap">';
            $return .= '<div class="mpcth-badge-content">' . $badge_content . '</div>';
        $return .= '</div>';
	$return .= '</div>';

	$return .= '<style>' . $css . '</style>';

	return $return;
}
add_shortcode('mpc_rev_badge', 'mpc_rev_badge_shortcode');

add_filter( 'manage_edit-mpc_badge_columns', 'mpc_set_custom_edit_mpc_badge_columns' );
add_action( 'manage_mpc_badge_posts_custom_column' , 'mpc_custom_mpc_badge_column', 10, 2 );

function mpc_set_custom_edit_mpc_badge_columns($columns) {
    $date = $columns['date'];
    unset( $columns['date'] );
    $columns['shortcode'] = __( 'Shortcode', 'mpc-ex' );
    $columns['date'] = $date;

    return $columns;
}

function mpc_custom_mpc_badge_column( $column, $post_id ) {
    switch ( $column ) {

        case 'shortcode' : echo '<pre>[mpc_rev_badge id="' . $post_id . '"]</pre>';
            break;
    }
}